/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.WriterOutputStream;

public final class SwallowingHttpServletResponse
implements HttpServletResponse {
    private int bufferSize = 0;
    private String characterEncoding;
    private boolean committed = false;
    private String contentType = null;
    private String errorMessage = null;
    private Locale locale = Locale.getDefault();
    private final ServletOutputStream outputStream;
    private final PrintWriter pout;
    private String redirectedUrl = null;
    private int status = 200;
    private static final Log log = LogFactory.getLog(SwallowingHttpServletResponse.class);

    public SwallowingHttpServletResponse(HttpServletResponse response, Writer sout, String characterEncoding) {
        this.pout = new PrintWriter(sout);
        this.outputStream = new WriterOutputStream(sout, characterEncoding);
        this.characterEncoding = characterEncoding;
    }

    public void addCookie(Cookie cookie) {
    }

    public void addDateHeader(String name, long value) {
    }

    public void addHeader(String name, String value) {
    }

    public void addIntHeader(String name, int value) {
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public void flushBuffer() throws IOException {
        this.pout.flush();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() {
        return this.pout;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void sendError(int newStatus) {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        log.warn((Object)("Ignoring call to sendError(" + newStatus + ")"));
        this.status = newStatus;
        this.committed = true;
    }

    public void sendError(int newStatus, String newErrorMessage) {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        log.warn((Object)("Ignoring call to sendError(" + newStatus + ", " + newErrorMessage + ")"));
        this.status = newStatus;
        this.errorMessage = newErrorMessage;
        this.committed = true;
    }

    public void sendRedirect(String location) {
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        log.warn((Object)("Ignoring call to sendRedirect(" + location + ")"));
        this.redirectedUrl = location;
        this.committed = true;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int i) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDateHeader(String name, long value) {
    }

    public void setHeader(String name, String value) {
    }

    public void setIntHeader(String name, int value) {
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setStatus(int status) {
        this.status = status;
        log.warn((Object)("Ignoring call to setStatus(" + status + ")"));
    }

    @Deprecated
    public void setStatus(int newStatus, String newErrorMessage) {
        this.status = newStatus;
        this.errorMessage = newErrorMessage;
        log.warn((Object)("Ignoring call to setStatus(" + newStatus + ", " + newErrorMessage + ")"));
    }

    public String encodeURL(String paramString) {
        return null;
    }

    public String encodeRedirectURL(String paramString) {
        return null;
    }

    public String encodeUrl(String paramString) {
        return null;
    }

    public String encodeRedirectUrl(String paramString) {
        return null;
    }

    public String getHeader(String paramString) {
        return null;
    }

    public Collection<String> getHeaders(String paramString) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }
}

