/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class LogErrorHandler
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(LogErrorHandler.class);

    @Override
    public void fatalError(SAXParseException ex) {
        log.fatal((Object)LogErrorHandler.getMessage(ex));
    }

    @Override
    public void error(SAXParseException ex) {
        log.error((Object)LogErrorHandler.getMessage(ex));
    }

    @Override
    public void warning(SAXParseException ex) {
        log.warn((Object)LogErrorHandler.getMessage(ex));
    }

    private static String getMessage(SAXParseException ex) {
        if (ex.getSystemId() != null) {
            return "SystemID=" + ex.getSystemId() + " Line=" + ex.getLineNumber() + " " + ex.getMessage();
        }
        if (ex.getPublicId() != null) {
            return "PublicID=" + ex.getPublicId() + " Line=" + ex.getLineNumber() + " " + ex.getMessage();
        }
        return "Line=" + ex.getLineNumber() + " " + ex.getMessage();
    }
}

