/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.FakeRequestDispatcher;

class FakeServletContextObject24 {
    private static final Log log = LogFactory.getLog(FakeServletContextObject24.class);
    private final String resourceBasePath;
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String servletContextName = "FakeServletContext";

    public FakeServletContextObject24() {
        this("");
    }

    public FakeServletContextObject24(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        Object output = path;
        if (!((String)output).startsWith("/")) {
            output = "/" + (String)output;
        }
        output = this.resourceBasePath + (String)output;
        return output;
    }

    public ServletContext getContext(String name) {
        throw new UnsupportedOperationException("getContext");
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String filePath) {
        throw new UnsupportedOperationException("getMimeType");
    }

    public Set<String> getResourcePaths(String path) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String path) throws MalformedURLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return new FileInputStream(this.resourceBasePath + path);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new FakeRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        throw new UnsupportedOperationException("getNamedDispatcher");
    }

    @Deprecated
    public Servlet getServlet(String name) {
        throw new UnsupportedOperationException("getServlet");
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException("getServlets");
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException("getServletNames");
    }

    public void log(String message) {
        log.info((Object)message);
    }

    @Deprecated
    public void log(Exception ex, String message) {
        log.warn((Object)message, (Throwable)ex);
    }

    public void log(String message, Throwable ex) {
        log.warn((Object)message, ex);
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo() {
        return "FakeServletContext";
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public String getContextPath() {
        throw new UnsupportedOperationException("getContextPath");
    }
}

