/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.util.LocalUtil;
import org.springframework.util.StringUtils;

public class SpringConfigurator
implements Configurator {
    private Map<String, String> creatorTypes;
    private Map<String, String> converterTypes;
    private Map<String, CreatorConfig> creators;
    private Map<String, ConverterConfig> converters;
    private String signatures;
    private List<AjaxFilter> filters;

    @Override
    public void configure(Container container) {
        String className;
        String typeName;
        AccessControl accessControl = container.getBean(AccessControl.class);
        AjaxFilterManager ajaxFilterManager = container.getBean(AjaxFilterManager.class);
        ConverterManager converterManager = container.getBean(ConverterManager.class);
        CreatorManager creatorManager = container.getBean(CreatorManager.class);
        if (null != this.filters) {
            for (AjaxFilter ajaxFilter : this.filters) {
                ajaxFilterManager.addAjaxFilter(ajaxFilter);
            }
        }
        if (this.creatorTypes != null) {
            for (Map.Entry entry : this.creatorTypes.entrySet()) {
                typeName = (String)entry.getKey();
                className = (String)entry.getValue();
                creatorManager.addCreatorType(typeName, className);
            }
        }
        if (this.converterTypes != null) {
            for (Map.Entry entry : this.converterTypes.entrySet()) {
                typeName = (String)entry.getKey();
                className = (String)entry.getValue();
                converterManager.addConverterType(typeName, className);
            }
        }
        if (this.creators != null) {
            try {
                for (Map.Entry entry : this.creators.entrySet()) {
                    String scriptName = (String)entry.getKey();
                    CreatorConfig creatorConfig = (CreatorConfig)entry.getValue();
                    if (creatorConfig.getCreator() != null) {
                        Creator creator = creatorConfig.getCreator();
                        creatorManager.addCreator(creator);
                    } else {
                        Iterator<String> creatorName = creatorConfig.getCreatorType();
                        Map<String, String> map = creatorConfig.getParams();
                        creatorManager.addCreator((String)((Object)creatorName), map);
                    }
                    for (String string : creatorConfig.getExcludes()) {
                        accessControl.addExcludeRule(scriptName, string);
                    }
                    for (String string : creatorConfig.getIncludes()) {
                        accessControl.addIncludeRule(scriptName, string);
                    }
                    Map<String, List<String>> auth = creatorConfig.getAuth();
                    for (Map.Entry<String, List<String>> entry2 : auth.entrySet()) {
                        for (String role : entry2.getValue()) {
                            accessControl.addRoleRestriction(scriptName, entry2.getKey(), role);
                        }
                    }
                    for (Object obj : creatorConfig.getFilters()) {
                        if (obj instanceof String) {
                            String filterName = (String)obj;
                            AjaxFilter filter = LocalUtil.classNewInstance(filterName, filterName, AjaxFilter.class);
                            if (filter == null) continue;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        if (obj instanceof AjaxFilter) {
                            AjaxFilter filter = (AjaxFilter)obj;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        throw new IllegalArgumentException("An invalid filter is added for script '" + scriptName + "'. It should either be the class name of the filter or an instantiated AjaxFilter, but was: '" + obj + "'.");
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (this.converters != null) {
            try {
                for (Map.Entry<String, ConverterConfig> entry : this.converters.entrySet()) {
                    String string;
                    String match = entry.getKey();
                    ConverterConfig converterConfig = entry.getValue();
                    Map<String, String> params = converterConfig.getParams();
                    if (!converterConfig.getIncludes().isEmpty()) {
                        params.put("include", StringUtils.collectionToCommaDelimitedString(converterConfig.getIncludes()));
                    }
                    if (!converterConfig.getExcludes().isEmpty()) {
                        params.put("exclude", StringUtils.collectionToCommaDelimitedString(converterConfig.getExcludes()));
                    }
                    if (StringUtils.hasText((String)converterConfig.getJavascriptClassName())) {
                        params.put("javascript", converterConfig.getJavascriptClassName());
                    }
                    if (converterConfig.isForce()) {
                        params.put("force", String.valueOf(converterConfig.isForce()));
                    }
                    if ((string = converterConfig.getType()).startsWith("preconfigured")) {
                        converterManager.addConverter(match, (Converter)container.getBean(string.substring(14)));
                        continue;
                    }
                    converterManager.addConverter(match, string, params);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("An error occurred while configuring the converters.");
            }
        }
        if (StringUtils.hasText((String)this.signatures)) {
            SignatureParser sigp = new SignatureParser(converterManager, creatorManager);
            sigp.parse(this.signatures);
        }
    }

    public void setCreatorTypes(Map<String, String> creatorTypes) {
        this.creatorTypes = creatorTypes;
    }

    public void setConverterTypes(Map<String, String> converterTypes) {
        this.converterTypes = converterTypes;
    }

    public void setCreators(Map<String, CreatorConfig> creators) {
        this.creators = creators;
    }

    public void setConverters(Map<String, ConverterConfig> converters) {
        this.converters = converters;
    }

    public void setSignatures(String signatures) {
        this.signatures = signatures;
    }

    public String getSignatures() {
        return this.signatures;
    }

    public void setFilters(List<AjaxFilter> filters) {
        this.filters = filters;
    }
}

