/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.directwebremoting.servlet.JavaScriptHandler;
import org.directwebremoting.util.CopyUtils;
import org.directwebremoting.util.LocalUtil;

public class FileJavaScriptHandler
extends JavaScriptHandler {
    private final String resource;
    private final String copyright;

    public FileJavaScriptHandler(String resource) {
        this.resource = resource;
        this.copyright = null;
    }

    public FileJavaScriptHandler(String resource, String copyright) {
        this.resource = resource;
        this.copyright = copyright;
    }

    @Override
    public String generateCachableContent(String contextPath, String servletPath, String pathInfo) throws IOException {
        Object output = super.generateCachableContent(contextPath, servletPath, pathInfo);
        if (!this.debug && this.copyright != null) {
            output = this.getCopyright() + (String)output;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String generateTemplate(String contextPath, String servletPath, String pathInfo) throws IOException {
        StringWriter sw = new StringWriter();
        InputStream raw = null;
        try {
            raw = LocalUtil.getInternalResourceAsStream(this.resource);
            if (raw == null) {
                throw new IOException("Failed to find resource: " + this.resource);
            }
            CopyUtils.copy(raw, (Writer)sw);
        }
        finally {
            LocalUtil.close(raw);
        }
        return sw.toString();
    }

    protected String getCopyright() throws IOException {
        StringWriter sw = new StringWriter();
        InputStream raw = null;
        if (this.copyright != null) {
            try {
                raw = LocalUtil.getInternalResourceAsStream(this.copyright);
                if (raw == null) {
                    throw new IOException("Failed to find resource: " + this.copyright);
                }
                CopyUtils.copy(raw, (Writer)sw);
            }
            finally {
                LocalUtil.close(raw);
            }
        }
        return sw.toString();
    }

    @Override
    protected long getLastModifiedTime() {
        URL url = FileJavaScriptHandler.class.getResource(LocalUtil.remappedResourcePath(this.resource));
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.getFile());
            return file.lastModified();
        }
        return LocalUtil.getSystemClassloadTime();
    }
}

