/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.parse.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.json.parse.JsonDecoder;
import org.directwebremoting.json.parse.JsonParseException;

public class DebuggingJsonDecoder<T>
implements JsonDecoder {
    private final JsonDecoder proxy;
    private String indent = "";
    private static final Log log = LogFactory.getLog(DebuggingJsonDecoder.class);

    public DebuggingJsonDecoder(JsonDecoder proxy) {
        this.proxy = proxy;
    }

    @Override
    public Object getRoot() throws JsonParseException {
        return this.proxy.getRoot();
    }

    @Override
    public void beginObject(String propertyName) throws JsonParseException {
        if (this.indent.length() == 0) {
            log.info((Object)"--------");
        }
        log.info((Object)(this.indent + "{"));
        this.increaseIndent();
        this.proxy.beginObject(propertyName);
    }

    @Override
    public void endObject(String propertyName) throws JsonParseException {
        this.proxy.endObject(propertyName);
        this.decreaseIndent();
        log.info((Object)(this.indent + "}"));
        if (this.indent.length() == 0) {
            log.info((Object)"--------");
        }
    }

    @Override
    public void beginArray(String propertyName) throws JsonParseException {
        log.info((Object)(this.indent + "["));
        this.increaseIndent();
        this.proxy.beginArray(propertyName);
    }

    @Override
    public void endArray(String propertyName) throws JsonParseException {
        this.proxy.endArray(propertyName);
        this.decreaseIndent();
        log.info((Object)(this.indent + "]"));
    }

    @Override
    public void addString(String propertyName, String value) throws JsonParseException {
        log.info((Object)(this.indent + value));
        this.proxy.addString(propertyName, value);
    }

    @Override
    public void addNumber(String propertyName, String intPart, String floatPart, String expPart) throws JsonParseException {
        Object value = intPart;
        if (floatPart != null) {
            value = (String)value + "." + floatPart;
        }
        if (expPart != null) {
            value = (String)value + "." + expPart;
        }
        log.info((Object)(this.indent + (String)value));
        this.proxy.addNumber(propertyName, intPart, floatPart, expPart);
    }

    @Override
    public void addBoolean(String propertyName, boolean value) throws JsonParseException {
        log.info((Object)(this.indent + value));
        this.proxy.addBoolean(propertyName, value);
    }

    @Override
    public void addNull(String propertyName) throws JsonParseException {
        log.info((Object)(this.indent + "null"));
        this.proxy.addNull(propertyName);
    }

    private void increaseIndent() {
        this.indent = this.indent + "  ";
    }

    private void decreaseIndent() {
        this.indent = this.indent.substring(2);
    }
}

