/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jms;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Hub;
import org.directwebremoting.event.MessageEvent;
import org.directwebremoting.jms.Unsupported;

public class DwrMessage
implements Message,
MapMessage,
TextMessage,
ObjectMessage {
    private String correlationId;
    private int deliveryMode;
    private Destination destination;
    private long expiration;
    private String messageId;
    private int priority;
    private boolean redelivered;
    private Destination replyTo;
    private long timestamp;
    private String type;
    private Map<String, Object> properties = new HashMap<String, Object>();
    protected Source source = null;
    protected Serializable object;
    protected String text;
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected Hub hub;
    protected MessageEvent message;
    private static final Log log = LogFactory.getLog(DwrMessage.class);

    public DwrMessage() {
    }

    public DwrMessage(String text) {
        this.setText(text);
    }

    public DwrMessage(Serializable object) {
        this.setObject(object);
    }

    public DwrMessage(Hub hub, MessageEvent message) {
        this.setMessageEvent(hub, message);
    }

    public void acknowledge() {
        throw Unsupported.noManualAcknowledgment();
    }

    public void clearBody() {
        throw new IllegalStateException("Can raw JMS messages have bodies?");
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.properties.keySet());
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(this.getStringProperty(name));
    }

    public byte getByteProperty(String name) {
        return Byte.parseByte(this.getStringProperty(name));
    }

    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.getStringProperty(name));
    }

    public float getFloatProperty(String name) {
        return Float.parseFloat(this.getStringProperty(name));
    }

    public int getIntProperty(String name) {
        return Integer.parseInt(this.getStringProperty(name));
    }

    public long getLongProperty(String name) {
        return Long.parseLong(this.getStringProperty(name));
    }

    public Object getObjectProperty(String name) {
        return this.properties.get(name);
    }

    public short getShortProperty(String name) {
        return Short.parseShort(this.getStringProperty(name));
    }

    public String getStringProperty(String name) {
        return this.properties.get(name).toString();
    }

    public void setBooleanProperty(String name, boolean value) {
        this.properties.put(name, value);
    }

    public void setByteProperty(String name, byte value) {
        this.properties.put(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.properties.put(name, value);
    }

    public void setFloatProperty(String name, float value) {
        this.properties.put(name, Float.valueOf(value));
    }

    public void setIntProperty(String name, int value) {
        this.properties.put(name, value);
    }

    public void setLongProperty(String name, long value) {
        this.properties.put(name, value);
    }

    public void setObjectProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setShortProperty(String name, short value) {
        this.properties.put(name, value);
    }

    public void setStringProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationId.getBytes();
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public Destination getJMSDestination() {
        return this.destination;
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public String getJMSMessageID() {
        return this.messageId;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public long getJMSTimestamp() {
        return this.timestamp;
    }

    public String getJMSType() {
        return this.type;
    }

    public void setJMSCorrelationID(String correlationID) {
        this.correlationId = correlationID;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.correlationId = new String(correlationID);
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        throw Unsupported.noTransactions();
    }

    public void setJMSDestination(Destination destination) {
        this.destination = destination;
    }

    public void setJMSExpiration(long expiration) {
        this.expiration = expiration;
        throw Unsupported.noMessageExpiry();
    }

    public void setJMSMessageID(String messageId) {
        this.messageId = messageId;
    }

    public void setJMSPriority(int priority) {
        this.priority = priority;
        throw Unsupported.noMessagePriority();
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
        throw Unsupported.noTransactions();
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
        throw Unsupported.noPointToPoint();
    }

    public void setJMSTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setJMSType(String type) {
        this.type = type;
    }

    public Enumeration<String> getMapNames() {
        return Collections.enumeration(this.map.keySet());
    }

    public boolean itemExists(String name) {
        return this.map.containsKey(name);
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getString(name));
    }

    public byte getByte(String name) {
        return Byte.parseByte(this.getString(name));
    }

    public byte[] getBytes(String name) {
        return this.getString(name).getBytes();
    }

    public char getChar(String name) {
        return this.getString(name).charAt(0);
    }

    public double getDouble(String name) {
        return Double.parseDouble(this.getString(name));
    }

    public float getFloat(String name) {
        return Float.parseFloat(this.getString(name));
    }

    public int getInt(String name) {
        return Integer.parseInt(this.getString(name));
    }

    public long getLong(String name) {
        return Long.parseLong(this.getString(name));
    }

    public short getShort(String name) {
        return Short.parseShort(this.getString(name));
    }

    public String getString(String name) {
        return this.getObject(name).toString();
    }

    public Object getObject(String name) {
        switch (this.source) {
            case MAP: {
                return this.map.get(name);
            }
            case MESSAGE_EVENT: {
                return this.message.getData(Map.class);
            }
            case NONE: {
                return "";
            }
            case SERIALIZABLE: {
                return ((Map)((Object)this.object)).get(name);
            }
            case TEXT: {
                return "";
            }
        }
        return "";
    }

    public void setBoolean(String name, boolean value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setByte(String name, byte value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setBytes(String name, byte[] value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setBytes(String name, byte[] value, int offset, int length) {
        byte[] data = new byte[length];
        System.arraycopy(data, 0, value, offset, length);
        this.map.put(name, data);
        this.setSource(Source.MAP);
    }

    public void setChar(String name, char value) {
        this.map.put(name, Character.valueOf(value));
        this.setSource(Source.MAP);
    }

    public void setDouble(String name, double value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setFloat(String name, float value) {
        this.map.put(name, Float.valueOf(value));
        this.setSource(Source.MAP);
    }

    public void setInt(String name, int value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setLong(String name, long value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setObject(String name, Object value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setShort(String name, short value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public void setString(String name, String value) {
        this.map.put(name, value);
        this.setSource(Source.MAP);
    }

    public String getText() {
        switch (this.source) {
            case MAP: {
                return null;
            }
            case MESSAGE_EVENT: {
                return this.message.getData(String.class);
            }
            case NONE: {
                return null;
            }
            case SERIALIZABLE: {
                return this.object.toString();
            }
            case TEXT: {
                return this.text;
            }
        }
        return null;
    }

    public void setText(String text) {
        this.text = text;
        this.setSource(Source.TEXT);
    }

    public Serializable getObject() {
        switch (this.source) {
            case MAP: {
                return null;
            }
            case MESSAGE_EVENT: {
                return (Serializable)this.message.getRawData();
            }
            case NONE: {
                return null;
            }
            case SERIALIZABLE: {
                return this.object;
            }
            case TEXT: {
                return this.text;
            }
        }
        return null;
    }

    public void setObject(Serializable object) {
        this.object = object;
        this.setSource(Source.SERIALIZABLE);
    }

    private void setMessageEvent(Hub hub, MessageEvent message) {
        this.hub = hub;
        this.message = message;
        this.setSource(Source.MESSAGE_EVENT);
    }

    private void setSource(Source source) {
        if (this.source != null && this.source != source) {
            log.warn((Object)("Changing source of message from " + this.source + " to " + source));
        }
        this.source = source;
    }

    static enum Source {
        MESSAGE_EVENT,
        NONE,
        TEXT,
        MAP,
        SERIALIZABLE;

    }
}

