/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Compressor;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YahooJSCompressor
implements Compressor {
    private static final Log log = LogFactory.getLog(YahooJSCompressor.class);
    private final Map<String, Object> compressorParameters = new HashMap<String, Object>();
    private static final String PARAMETER_MUNGE = "munge";
    private static final String PARAMETER_VERBOSE = "verbose";
    private static final String PARAMETER_LINEBREAK = "linebreak";
    private static final String PARAMETER_PRESERVE_ALL_SEMICOLONS = "preserveAllSemiColons";
    private static final String PARAMETER_DISABLE_OPTIMIZATIONS = "disableOptimizations";
    private static final Boolean DEFAULT_MUNGE = Boolean.FALSE;
    private static final Boolean DEFAULT_VERBOSE = Boolean.FALSE;
    private static final Integer DEFAULT_LINEBREAK = 20000;
    private static final Boolean DEFAULT_PRESERVE_ALL_SEMICOLONS = Boolean.FALSE;
    private static final Boolean DEFAULT_DISABLE_OPTIMIZATIONS = Boolean.FALSE;

    public YahooJSCompressor() throws InstantiationException {
        this(null);
    }

    public YahooJSCompressor(Map<String, Object> specifiedCompressorParameters) throws InstantiationException {
        try {
            new JavaScriptCompressor((Reader)new StringReader(""), (ErrorReporter)new YahooJSErrorReporter());
        }
        catch (NoClassDefFoundError ncdf) {
            throw new InstantiationException("com.yahoo.platform.yui.compressor.JavaScriptCompressor is not available, assuming Yahoo Compressor is not here from yuicompressor.jar ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCompressorParameters(specifiedCompressorParameters);
    }

    @Override
    public String compressJavaScript(String script) throws IOException {
        StringReader stringReader = new StringReader(script);
        JavaScriptCompressor yuiJavaScriptCompressor = new JavaScriptCompressor((Reader)stringReader, (ErrorReporter)new YahooJSErrorReporter());
        StringWriter stringWriter = new StringWriter();
        yuiJavaScriptCompressor.compress((Writer)stringWriter, ((Integer)this.compressorParameters.get(PARAMETER_LINEBREAK)).intValue(), ((Boolean)this.compressorParameters.get(PARAMETER_MUNGE)).booleanValue(), ((Boolean)this.compressorParameters.get(PARAMETER_VERBOSE)).booleanValue(), ((Boolean)this.compressorParameters.get(PARAMETER_PRESERVE_ALL_SEMICOLONS)).booleanValue(), ((Boolean)this.compressorParameters.get(PARAMETER_DISABLE_OPTIMIZATIONS)).booleanValue());
        String compressedScript = stringWriter.toString();
        return compressedScript;
    }

    private void setCompressorParameters(Map<String, Object> configuredCompressorParameters) {
        String mungeString = null;
        String disableOptString = null;
        String preserveSemiString = null;
        String verboseString = null;
        String linebreakString = null;
        if (null != configuredCompressorParameters) {
            mungeString = (String)configuredCompressorParameters.get(PARAMETER_MUNGE);
            disableOptString = (String)configuredCompressorParameters.get(PARAMETER_DISABLE_OPTIMIZATIONS);
            preserveSemiString = (String)configuredCompressorParameters.get(PARAMETER_PRESERVE_ALL_SEMICOLONS);
            verboseString = (String)configuredCompressorParameters.get(PARAMETER_VERBOSE);
            linebreakString = (String)configuredCompressorParameters.get(PARAMETER_LINEBREAK);
        }
        this.compressorParameters.put(PARAMETER_MUNGE, null != mungeString ? Boolean.valueOf(mungeString) : DEFAULT_MUNGE);
        this.compressorParameters.put(PARAMETER_DISABLE_OPTIMIZATIONS, null != disableOptString ? Boolean.valueOf(disableOptString) : DEFAULT_DISABLE_OPTIMIZATIONS);
        this.compressorParameters.put(PARAMETER_PRESERVE_ALL_SEMICOLONS, null != preserveSemiString ? Boolean.valueOf(preserveSemiString) : DEFAULT_PRESERVE_ALL_SEMICOLONS);
        this.compressorParameters.put(PARAMETER_VERBOSE, null != verboseString ? Boolean.valueOf(verboseString) : DEFAULT_VERBOSE);
        this.compressorParameters.put(PARAMETER_LINEBREAK, null != linebreakString ? Integer.valueOf(linebreakString) : DEFAULT_LINEBREAK);
    }

    protected static class YahooJSErrorReporter
    implements ErrorReporter {
        protected YahooJSErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                log.warn((Object)message);
            } else {
                log.error((Object)("\n" + line + ":" + lineOffset + ":" + message));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                log.error((Object)message);
            } else {
                log.error((Object)(line + 58 + lineOffset + 58 + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

