/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.OverrideProperty;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.impl.LegacyCompressor;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

public class SignatureParser {
    private final Map<String, String> classImports = new HashMap<String, String>();
    private final List<String> packageImports = new ArrayList<String>();
    private final ConverterManager converterManager;
    private final CreatorManager creatorManager;
    private static final Log log = LogFactory.getLog(SignatureParser.class);

    public SignatureParser(ConverterManager converterManager, CreatorManager creatorManager) {
        this.converterManager = converterManager;
        this.creatorManager = creatorManager;
        this.packageImports.add("java.lang");
    }

    public void parse(String sigtext) {
        try {
            Loggers.STARTUP.debug((Object)"Parsing extra type info: ");
            String reply = LegacyCompressor.stripMultiLineComments(sigtext);
            String process = reply = LegacyCompressor.stripSingleLineComments(reply);
            process = process.replace('\n', ' ');
            process = process.replace('\r', ' ');
            process = process.replace('\t', ' ');
            StringTokenizer st = new StringTokenizer(process, ";");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("import ")) {
                    this.parseImportLine(line);
                    continue;
                }
                this.parseDeclarationLine(line);
            }
        }
        catch (Exception ex) {
            Loggers.STARTUP.error((Object)"Unexpected Error", (Throwable)ex);
        }
    }

    private void parseImportLine(String line) {
        String shortcut = line.substring(7, line.length());
        shortcut = shortcut.trim();
        if (line.endsWith(".*")) {
            shortcut = shortcut.substring(0, shortcut.length() - 2);
            this.packageImports.add(shortcut);
        } else {
            int lastDot = line.lastIndexOf(46);
            if (lastDot == -1) {
                Loggers.STARTUP.error((Object)("Missing . from import statement: " + line));
                return;
            }
            String leaf = line.substring(lastDot + 1);
            this.classImports.put(leaf, shortcut);
        }
    }

    private void parseDeclarationLine(String line) {
        int openBrace = line.indexOf(40);
        int closeBrace = line.indexOf(41);
        if (openBrace == -1) {
            Loggers.STARTUP.error((Object)("Missing ( in declaration: " + line));
            return;
        }
        if (closeBrace == -1) {
            Loggers.STARTUP.error((Object)("Missing ) in declaration: " + line));
            return;
        }
        if (openBrace > closeBrace) {
            Loggers.STARTUP.error((Object)("( Must come before ) in declaration: " + line));
            return;
        }
        String classMethod = line.substring(0, openBrace).trim();
        Method method = this.findMethod(classMethod);
        if (method == null) {
            return;
        }
        String paramDecl = line.substring(openBrace + 1, closeBrace);
        String[] paramNames = SignatureParser.split(paramDecl);
        if (method.getParameterTypes().length != paramNames.length) {
            Loggers.STARTUP.error((Object)("Parameter mismatch parsing signatures section in dwr.xml on line: " + line));
            Loggers.STARTUP.info((Object)("- Reflected method had: " + method.getParameterTypes().length + " parameters: " + method.toString()));
            Loggers.STARTUP.info((Object)("- Signatures section had: " + paramNames.length + " parameters"));
            Loggers.STARTUP.info((Object)"- This can be caused by method overloading which is not supported by Javascript or DWR");
            return;
        }
        for (int i = 0; i < paramNames.length; ++i) {
            String[] genericList = SignatureParser.getGenericParameterTypeList(paramNames[i]);
            for (int j = 0; j < genericList.length; ++j) {
                String type = genericList[j].trim();
                Class<?> clazz = this.findClass(type);
                if (clazz != null) {
                    ParameterProperty parent = new ParameterProperty(new MethodDeclaration(method), i);
                    Property child = parent.createChild(j);
                    child = this.converterManager.checkOverride(child);
                    OverrideProperty replacement = new OverrideProperty(clazz);
                    this.converterManager.setOverrideProperty(child, replacement);
                    if (!Loggers.STARTUP.isDebugEnabled()) continue;
                    Loggers.STARTUP.debug((Object)("- " + child + " = " + clazz.getName()));
                    continue;
                }
                Loggers.STARTUP.warn((Object)("Missing class (" + type + ") while parsing signature section on line: " + line));
            }
        }
    }

    private Class<?> findClass(String type) {
        Creator creator;
        String itype = type;
        Class<?> clazz = null;
        try {
            if (type.contains("[]")) {
                itype = type.substring(0, type.indexOf(91));
            }
        }
        catch (Exception ex) {
            log.debug((Object)("SignatureParser can't find class: " + ex.getMessage()));
        }
        if (itype.indexOf(46) != -1) {
            Loggers.STARTUP.debug((Object)("Inner class detected: " + itype));
            itype = itype.replace('.', '$');
        }
        if (null == (clazz = this.retrieveClassFromClassImports(itype))) {
            clazz = this.retrieveClassFromPackageImports(itype);
        }
        if (null == clazz && (creator = this.creatorManager.getCreator(type, false)) != null) {
            clazz = creator.getType();
        }
        if (null != clazz) {
            if (type.contains("[]")) {
                return Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }
        Loggers.STARTUP.error((Object)("Failed to find class: '" + itype + "' from <signature> block."));
        Loggers.STARTUP.info((Object)"- Looked in the following class imports:");
        for (Map.Entry<String, String> entry : this.classImports.entrySet()) {
            Loggers.STARTUP.info((Object)("  - " + entry.getKey() + " -> " + entry.getValue()));
        }
        Loggers.STARTUP.info((Object)"- Looked in the following package imports:");
        for (String pkg : this.packageImports) {
            Loggers.STARTUP.info((Object)("  - " + pkg));
        }
        return null;
    }

    private Class<?> retrieveClassFromClassImports(String itype) {
        try {
            String full = this.classImports.get(itype);
            if (full == null) {
                full = itype;
            }
            return LocalUtil.classForName(full);
        }
        catch (Exception ex) {
            log.debug((Object)"SignatureParser - Can't find class in signature class imports, will attempt package imports.");
            return null;
        }
    }

    private Class<?> retrieveClassFromPackageImports(String itype) {
        for (String pkg : this.packageImports) {
            String lookup = pkg + "." + itype;
            try {
                return LocalUtil.classForName(lookup);
            }
            catch (Exception ex) {
                log.debug((Object)("SignatureParser - Can't find class in package imports: " + lookup));
            }
        }
        return null;
    }

    private static String[] getGenericParameterTypeList(String paramName) {
        int openGeneric = paramName.indexOf(60);
        if (openGeneric == -1) {
            Loggers.STARTUP.debug((Object)("No < in paramter declaration: " + paramName));
            return new String[0];
        }
        int closeGeneric = paramName.lastIndexOf(62);
        if (closeGeneric == -1) {
            Loggers.STARTUP.error((Object)("Missing > in generic declaration: " + paramName));
            return new String[0];
        }
        String generics = paramName.substring(openGeneric + 1, closeGeneric);
        StringTokenizer st = new StringTokenizer(generics, ",");
        String[] types = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            types[i] = st.nextToken();
            ++i;
        }
        return types;
    }

    private Method findMethod(String classMethod) {
        Method[] methods;
        int lastDot;
        String classMethodChop = classMethod;
        int lastSpace = classMethodChop.lastIndexOf(32);
        if (lastSpace >= 0) {
            classMethodChop = classMethodChop.substring(lastSpace);
        }
        if ((lastDot = classMethodChop.lastIndexOf(46)) == -1) {
            Loggers.STARTUP.error((Object)("Missing . to separate class name and method: " + classMethodChop));
            return null;
        }
        String className = classMethodChop.substring(0, lastDot).trim();
        String methodName = classMethodChop.substring(lastDot + 1).trim();
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        Method method = null;
        for (Method test : methods = clazz.getMethods()) {
            if (!test.getName().equals(methodName)) continue;
            if (method == null) {
                method = test;
                continue;
            }
            Loggers.STARTUP.warn((Object)"Setting extra type info to overloaded methods may fail with <parameter .../>");
        }
        if (method == null) {
            Loggers.STARTUP.error((Object)("Unable to find method called: " + methodName + " on type: " + clazz.getName()));
        }
        return method;
    }

    private static String[] split(String paramDecl) {
        ArrayList<String> params = new ArrayList<String>();
        boolean inGeneric = false;
        int start = 0;
        for (int i = 0; i < paramDecl.length(); ++i) {
            char c = paramDecl.charAt(i);
            if (c == '<') {
                if (inGeneric) {
                    Loggers.STARTUP.error((Object)("Found < while parsing generic section: " + paramDecl));
                    break;
                }
                inGeneric = true;
            }
            if (c == '>') {
                if (!inGeneric) {
                    Loggers.STARTUP.error((Object)("Found > while not parsing generic section: " + paramDecl));
                    break;
                }
                inGeneric = false;
            }
            if (inGeneric || c != ',') continue;
            String param = paramDecl.substring(start, i);
            params.add(param);
            start = i + 1;
        }
        String param = paramDecl.substring(start, paramDecl.length());
        params.add(param);
        return params.toArray(new String[params.size()]);
    }
}

