/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Compressor;
import org.directwebremoting.util.LocalUtil;

public class LegacyCompressor
implements Compressor {
    protected int compressionLevel = 7;
    public static final int COMPRESS_STRIP_SL_COMMENTS = 1;
    public static final int COMPRESS_STRIP_ML_COMMENTS = 2;
    public static final int COMPRESS_TRIM_LINES = 4;
    public static final int COMPRESS_STRIP_BLANKLINES = 8;
    public static final int COMPRESS_SHRINK_VARS = 16;
    public static final int COMPRESS_REMOVE_NEWLINES = 32;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_DEBUGGABLE = 7;
    public static final int LEVEL_NORMAL = 31;
    public static final int LEVEL_ULTRA = 63;
    private static final String COMMENT_ML_START = "/*";
    private static final String COMMENT_ML_END = "*/";
    private static final String COMMENT_SL_START = "//";
    private static final String COMMENT_RETAIN = "#DWR";
    private static final Log log = LogFactory.getLog(LegacyCompressor.class);

    @Override
    public String compressJavaScript(String script) throws IOException {
        return LegacyCompressor.compress(script, this.compressionLevel);
    }

    public static String compress(String text, int level) {
        String reply = text;
        if ((level & 2) != 0) {
            reply = LegacyCompressor.stripMultiLineComments(text);
        }
        if ((level & 1) != 0) {
            reply = LegacyCompressor.stripSingleLineComments(reply);
        }
        if ((level & 4) != 0) {
            reply = LegacyCompressor.trimLines(reply);
        }
        if ((level & 8) != 0) {
            reply = LegacyCompressor.stripBlankLines(reply);
        }
        if ((level & 0x10) != 0) {
            reply = LegacyCompressor.shrinkVariableNames(reply);
        }
        if ((level & 0x20) != 0) {
            reply = LegacyCompressor.stripNewlines(reply);
        }
        return reply;
    }

    public static String trimLines(String text) {
        String string;
        if (text == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String line;
            StringBuffer output = new StringBuffer();
            in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line.trim());
                output.append('\n');
            }
            string = output.toString();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"IOExecption unexpected.", (Throwable)ex);
                throw new IllegalArgumentException("IOExecption unexpected.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public static String stripSingleLineComments(String text) {
        String string;
        if (text == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String line;
            StringBuffer output = new StringBuffer();
            in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                int cstart;
                if (line.contains(COMMENT_SL_START) && !line.contains(COMMENT_RETAIN) && !line.matches(".*https?://.*") && (cstart = line.indexOf(COMMENT_SL_START)) >= 0) {
                    line = line.substring(0, cstart);
                }
                output.append(line);
                output.append('\n');
            }
            string = output.toString();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"IOExecption unexpected.", (Throwable)ex);
                throw new IllegalArgumentException("IOExecption unexpected.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public static String stripMultiLineComments(String text) {
        String string;
        if (text == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            Object line;
            StringBuffer output = new StringBuffer();
            boolean inMultiLine = false;
            in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                if (!inMultiLine) {
                    int cstart = ((String)line).indexOf(COMMENT_ML_START);
                    if (cstart >= 0) {
                        int cend = ((String)line).indexOf(COMMENT_ML_END, cstart + COMMENT_ML_START.length());
                        if (cend >= 0) {
                            line = ((String)line).substring(0, cstart) + " " + ((String)line).substring(cend + COMMENT_ML_END.length());
                        } else {
                            inMultiLine = true;
                            line = ((String)line).substring(0, cstart) + " ";
                        }
                    }
                } else {
                    int cend = ((String)line).indexOf(COMMENT_ML_END);
                    if (cend >= 0) {
                        line = ((String)line).substring(cend + COMMENT_ML_END.length());
                        inMultiLine = false;
                    } else {
                        line = " ";
                    }
                }
                output.append((String)line);
                output.append('\n');
            }
            string = output.toString();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"IOExecption unexpected.", (Throwable)ex);
                throw new IllegalArgumentException("IOExecption unexpected.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public static String stripBlankLines(String text) {
        String string;
        if (text == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String line;
            StringBuffer output = new StringBuffer();
            in = new BufferedReader(new StringReader(text));
            boolean doneOneLine = false;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                output.append(line);
                output.append('\n');
                doneOneLine = true;
            }
            if (!doneOneLine) {
                output.append('\n');
            }
            string = output.toString();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"IOExecption unexpected.", (Throwable)ex);
                throw new IllegalArgumentException("IOExecption unexpected.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public static String stripNewlines(String text) {
        String string;
        if (text == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String line;
            StringBuffer output = new StringBuffer();
            in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                output.append(line);
                output.append(" ");
            }
            output.append('\n');
            string = output.toString();
        }
        catch (IOException ex) {
            try {
                log.error((Object)"IOExecption unexpected.", (Throwable)ex);
                throw new IllegalArgumentException("IOExecption unexpected.");
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public static String shrinkVariableNames(String text) {
        if (text == null) {
            return null;
        }
        throw new UnsupportedOperationException("Variable name shrinking is not supported");
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }
}

