/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.IdGenerator;
import org.directwebremoting.util.Base64;

public class DefaultSecureIdGenerator
implements IdGenerator {
    protected SecureRandom random = null;
    protected int count = 0;
    protected int countSinceSeed = 0;
    protected long seedTime = 0L;
    protected int countSinceTimeChange = 0;
    protected long lastGenTime = 0L;
    protected int lastHashCode = 0;
    private static final Log log = LogFactory.getLog(DefaultSecureIdGenerator.class);

    public DefaultSecureIdGenerator() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        try {
            if (this.random == null) {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(new byte[1]);
        this.reseed();
    }

    @Override
    public synchronized String generate() {
        long time;
        long remainder;
        this.reseedIfNeeded();
        StringBuilder idbuf = new StringBuilder();
        byte[] bytes = new byte[21];
        this.random.nextBytes(bytes);
        String base64 = new String(Base64.encodeBase64(bytes));
        String base64Adjusted = base64.replaceAll("\\+", "!").replaceAll("/", "~");
        idbuf.append(base64Adjusted);
        char[] charmap = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!~".toCharArray();
        for (remainder = time = System.currentTimeMillis(); remainder > 0L; remainder >>>= 6) {
            idbuf.append(charmap[(int)remainder & 0x3F]);
        }
        if (time == this.lastGenTime) {
            idbuf.append('-');
            for (remainder = (long)this.countSinceTimeChange; remainder > 0L; remainder >>>= 6) {
                idbuf.append(charmap[(int)remainder & 0x3F]);
            }
        } else {
            this.countSinceTimeChange = 0;
        }
        ++this.count;
        ++this.countSinceSeed;
        ++this.countSinceTimeChange;
        this.lastGenTime = time;
        String id = idbuf.toString();
        this.lastHashCode = System.identityHashCode(id);
        return id;
    }

    protected void reseedIfNeeded() {
        boolean needReseed = false;
        long time = System.currentTimeMillis();
        if (time - this.seedTime > 900000L) {
            needReseed = true;
        }
        if (this.countSinceSeed > 1000) {
            needReseed = true;
        }
        if (needReseed) {
            this.reseed();
            this.seedTime = time;
            this.countSinceSeed = 0;
        }
    }

    protected void reseed() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(os);
            data.writeLong(System.nanoTime());
            byte[] prngOutput = new byte[128];
            this.random.nextBytes(prngOutput);
            data.write(prngOutput);
            data.write(this.count);
            data.write(this.lastHashCode);
            os.close();
            byte[] base = os.toByteArray();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base);
            byte[] hash128 = new byte[16];
            System.arraycopy(hash, 0, hash128, 0, 16);
            log.debug((Object)("Reseeding with " + Arrays.toString(hash128)));
            this.random.setSeed(hash128);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

