/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.event.ScriptSessionEvent;
import org.directwebremoting.event.ScriptSessionListener;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Loggers;

public class DefaultScriptSessionManager
implements ScriptSessionManager,
InitializingBean,
UninitializingBean {
    private long scriptSessionTimeout = 300000L;
    protected PageNormalizer pageNormalizer;
    protected long scriptSessionCheckTime = 30000L;
    protected ConverterManager converterManager = null;
    protected boolean jsonOutput = false;
    protected ScheduledThreadPoolExecutor executor;
    protected static final String ATTRIBUTE_INVALIDATIONLISTENER = DefaultScriptSessionManager.class.getName() + ".InvalidationListener";
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected List<ScriptSessionListener> scriptSessionListeners = new CopyOnWriteArrayList<ScriptSessionListener>();
    private volatile ScheduledFuture<?> future;
    protected volatile long lastSessionCheckAt = System.currentTimeMillis();
    protected final ConcurrentMap<String, DefaultScriptSession> sessionMap = new ConcurrentHashMap<String, DefaultScriptSession>();
    protected final ConcurrentMap<String, Set<DefaultScriptSession>> httpSessionXref = new ConcurrentHashMap<String, Set<DefaultScriptSession>>();

    @Override
    public void afterContainerSetup(Container container) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefaultScriptSessionManager.this.maybeCheckTimeouts();
            }
        };
        this.future = this.executor.scheduleWithFixedDelay(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void destroy() {
        this.future.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealScriptSession getOrCreateScriptSession(String sentScriptId, String page, HttpSession httpSession) {
        DefaultScriptSession scriptSession;
        this.maybeCheckTimeouts();
        if ("".equals(sentScriptId)) {
            scriptSession = this.createScriptSession("", page);
            Loggers.SESSION.debug((Object)("Creating temporary script session on " + scriptSession.getPage()));
        } else {
            HttpSessionBindingListener invalidationListener;
            scriptSession = (DefaultScriptSession)this.sessionMap.get(sentScriptId);
            if (scriptSession == null) {
                scriptSession = this.createScriptSession(sentScriptId, page);
                Loggers.SESSION.debug((Object)("Creating " + scriptSession + " on " + scriptSession.getPage()));
                this.sessionMap.putIfAbsent(sentScriptId, scriptSession);
                this.fireScriptSessionCreatedEvent(scriptSession);
            } else {
                scriptSession.updateLastAccessedTime();
                String storedPage = scriptSession.getPage();
                if (!storedPage.equals(page)) {
                    scriptSession.setPage(page);
                }
            }
            String httpSessionId = httpSession != null ? httpSession.getId() : null;
            DefaultScriptSession defaultScriptSession = scriptSession;
            synchronized (defaultScriptSession) {
                if (scriptSession.getHttpSessionId() != null && !scriptSession.getHttpSessionId().equals(httpSessionId)) {
                    this.disassociateScriptSessionAndHttpSession(scriptSession, httpSessionId);
                }
                if (httpSessionId != null && !httpSessionId.equals(scriptSession.getHttpSessionId())) {
                    this.associateScriptSessionAndHttpSession(scriptSession, httpSessionId);
                }
            }
            if (httpSession != null && (invalidationListener = (HttpSessionBindingListener)httpSession.getAttribute(ATTRIBUTE_INVALIDATIONLISTENER)) == null) {
                DefaultScriptSessionManager defaultScriptSessionManager = this;
                synchronized (defaultScriptSessionManager) {
                    invalidationListener = (HttpSessionBindingListener)httpSession.getAttribute(ATTRIBUTE_INVALIDATIONLISTENER);
                    if (invalidationListener == null) {
                        httpSession.setAttribute(ATTRIBUTE_INVALIDATIONLISTENER, (Object)new InvalidationListener(this, httpSessionId));
                    }
                }
            }
        }
        return scriptSession;
    }

    protected DefaultScriptSession createScriptSession(String sentScriptId, String page) {
        return new DefaultScriptSession(sentScriptId, this, page, this.converterManager, this.jsonOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateScriptSessionAndHttpSession(DefaultScriptSession scriptSession, String httpSessionId) {
        if (httpSessionId == null) {
            return;
        }
        boolean done = false;
        do {
            HashSet<DefaultScriptSession> scriptSessions;
            if ((scriptSessions = (HashSet<DefaultScriptSession>)this.httpSessionXref.get(httpSessionId)) == null) {
                scriptSessions = new HashSet<DefaultScriptSession>();
                this.httpSessionXref.putIfAbsent(httpSessionId, scriptSessions);
            }
            HashSet<DefaultScriptSession> hashSet = scriptSessions;
            synchronized (hashSet) {
                if (this.httpSessionXref.get(httpSessionId) == scriptSessions) {
                    scriptSessions.add(scriptSession);
                    done = true;
                }
            }
        } while (!done);
        scriptSession.setHttpSessionId(httpSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disassociateScriptSessionAndHttpSession(DefaultScriptSession scriptSession, String httpSessionId) {
        if (httpSessionId == null) {
            return;
        }
        Set scriptSessions = (Set)this.httpSessionXref.get(httpSessionId);
        if (scriptSessions == null) {
            return;
        }
        Set set = scriptSessions;
        synchronized (set) {
            if (!scriptSessions.contains(scriptSession)) {
                return;
            }
            scriptSessions.remove(scriptSession);
            if (scriptSessions.size() == 0) {
                this.httpSessionXref.remove(httpSessionId);
            }
        }
        scriptSession.setHttpSessionId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disassociateAllScriptSessionsFromHttpSession(String httpSessionId) {
        if (httpSessionId == null) {
            return;
        }
        Set scriptSessions = (Set)this.httpSessionXref.get(httpSessionId);
        if (scriptSessions == null) {
            return;
        }
        HashSet copy = new HashSet();
        Object object = scriptSessions;
        synchronized (object) {
            copy.addAll(scriptSessions);
            scriptSessions.clear();
            this.httpSessionXref.remove(httpSessionId);
        }
        object = copy.iterator();
        while (object.hasNext()) {
            DefaultScriptSession scriptSession;
            DefaultScriptSession defaultScriptSession = scriptSession = (DefaultScriptSession)object.next();
            synchronized (defaultScriptSession) {
                if (httpSessionId.equals(scriptSession.getHttpSessionId())) {
                    scriptSession.setHttpSessionId(null);
                }
            }
        }
    }

    @Override
    public ScriptSession getScriptSessionById(String scriptSessionId) {
        return (ScriptSession)this.sessionMap.get(scriptSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ScriptSession> getScriptSessionsByHttpSessionId(String httpSessionId) {
        HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
        Set scriptSessions = (Set)this.httpSessionXref.get(httpSessionId);
        if (scriptSessions != null) {
            Set set = scriptSessions;
            synchronized (set) {
                reply.addAll(scriptSessions);
            }
        }
        return reply;
    }

    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
        reply.addAll(this.sessionMap.values());
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(DefaultScriptSession scriptSession) {
        Loggers.SESSION.debug((Object)("Invalidating " + scriptSession + " from " + scriptSession.getPage()));
        this.sessionMap.remove(scriptSession.getId());
        DefaultScriptSession defaultScriptSession = scriptSession;
        synchronized (defaultScriptSession) {
            this.disassociateScriptSessionAndHttpSession(scriptSession, scriptSession.getHttpSessionId());
        }
        this.fireScriptSessionDestroyedEvent(scriptSession);
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        for (DefaultScriptSession defaultScriptSession : this.sessionMap.values()) {
            long age;
            if (defaultScriptSession.isInvalidated() || (age = now - defaultScriptSession.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
            timeouts.add(defaultScriptSession);
        }
        for (ScriptSession scriptSession : timeouts) {
            DefaultScriptSession session = (DefaultScriptSession)scriptSession;
            session.invalidate();
        }
    }

    @Override
    public void addScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.add(li);
    }

    @Override
    public void removeScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.remove(li);
    }

    protected void fireScriptSessionCreatedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionCreated(ev);
        }
    }

    protected void fireScriptSessionDestroyedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionDestroyed(ev);
        }
    }

    @Override
    public String getInitCode() {
        return "dwr.engine._execute(dwr.engine._pathToDwrServlet, '__System', 'pageLoaded', [ function() { dwr.engine._ordered = false; }]);";
    }

    @Override
    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long scriptSessionTimeout) {
        this.scriptSessionTimeout = scriptSessionTimeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    private static class InvalidationListener
    implements HttpSessionBindingListener,
    Serializable {
        private final transient DefaultScriptSessionManager scriptSessionManager;
        private final transient String httpSessionId;

        public InvalidationListener(DefaultScriptSessionManager scriptSessionManager, String httpSessionId) {
            this.scriptSessionManager = scriptSessionManager;
            this.httpSessionId = httpSessionId;
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
        }

        public void valueUnbound(HttpSessionBindingEvent arg0) {
            if (this.scriptSessionManager != null && this.httpSessionId != null) {
                this.scriptSessionManager.disassociateAllScriptSessionsFromHttpSession(this.httpSessionId);
            }
        }
    }
}

