/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.Module;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.util.Loggers;

public class CreatorModule
implements Module {
    private final Creator creator;
    private final AjaxFilterManager ajaxFilterManager;
    private final AccessControl accessControl;
    private final boolean allowImpossibleTests;
    protected final String accessLogLevel;
    private final boolean debug;
    private Object unwrappedTarget;
    private MethodDeclaration[] methodDecls;
    private static Class<?> advisedClass;
    private static Class<?> targetSourceClass;
    private static final Log log;

    public CreatorModule(Creator creator, AjaxFilterManager ajaxFilterManager, AccessControl accessControl, boolean allowImpossibleTests, String accessLogLevel, boolean debug) {
        this.creator = creator;
        this.ajaxFilterManager = ajaxFilterManager;
        this.accessControl = accessControl;
        this.allowImpossibleTests = allowImpossibleTests;
        this.accessLogLevel = accessLogLevel;
        this.debug = debug;
    }

    @Override
    public String getName() {
        return this.creator.getJavascript();
    }

    @Override
    public boolean isCacheable() {
        return this.creator.isCacheable();
    }

    @Override
    public MethodDeclaration[] getMethods() {
        if (this.methodDecls == null) {
            Class<?> creatorType = this.creator.getType();
            Method[] methods = creatorType.getMethods();
            ArrayList<MethodDeclaration> methodDeclsArray = new ArrayList<MethodDeclaration>();
            for (Method method : methods) {
                Method unwrappedMethod = this.unwrapProxiedMethod(method);
                try {
                    this.accessControl.assertMethodDisplayable(creatorType, unwrappedMethod);
                }
                catch (SecurityException ex) {
                    if (!this.allowImpossibleTests) continue;
                }
                methodDeclsArray.add(new MethodDeclaration(unwrappedMethod));
            }
            this.methodDecls = methodDeclsArray.toArray(new MethodDeclaration[0]);
        }
        return this.methodDecls;
    }

    @Override
    public MethodDeclaration getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = this.unwrapProxiedMethod(this.creator.getType().getMethod(methodName, parameterTypes));
        return new MethodDeclaration(method);
    }

    @Override
    public Object executeMethod(MethodDeclaration methodDecl, Object[] parameters) throws Exception {
        Method method = this.creator.getType().getMethod(methodDecl.getName(), methodDecl.getParameterTypes());
        this.accessControl.assertMethodExecutionIsPossible(this.creator.getType(), method);
        Object object = null;
        String scope = this.creator.getScope();
        boolean create = false;
        if (!Modifier.isStatic(method.getModifiers())) {
            object = this.getScopedInstance();
        }
        if (AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
            StringBuffer buffer = new StringBuffer();
            if (create) {
                buffer.append("Object created, ");
                if (!scope.equals("page")) {
                    buffer.append(" stored in ");
                    buffer.append(scope);
                } else {
                    buffer.append(" not stored");
                }
            } else {
                buffer.append("Object found in ");
                buffer.append(scope);
            }
            buffer.append(".");
            Loggers.ACCESS.info((Object)buffer.toString());
        }
        List<AjaxFilter> filters = this.ajaxFilterManager.getAjaxFilters(this.getName());
        final Iterator<AjaxFilter> it = filters.iterator();
        AjaxFilterChain chain = new AjaxFilterChain(){

            @Override
            public Object doFilter(Object obj, Method meth, Object[] params) throws Exception {
                if (it.hasNext()) {
                    AjaxFilter next = (AjaxFilter)it.next();
                    return next.doFilter(obj, meth, params, this);
                }
                if (null != obj && meth.getDeclaringClass().equals(obj.getClass()) || Modifier.isStatic(meth.getModifiers())) {
                    return meth.invoke(obj, params);
                }
                Method m = obj.getClass().getMethod(meth.getName(), meth.getParameterTypes());
                return m.invoke(obj, params);
            }
        };
        Object reply = chain.doFilter(object, method, parameters);
        return reply;
    }

    public Object getScopedInstance() throws InstantiationException {
        WebContext webcx = WebContextFactory.get();
        String name = this.creator.getJavascript();
        String scope = this.creator.getScope();
        Object object = null;
        boolean create = false;
        if (scope.equals("application")) {
            object = webcx.getServletContext().getAttribute(name);
        } else if (scope.equals("session")) {
            object = webcx.getSession().getAttribute(name);
        } else if (scope.equals("script")) {
            object = webcx.getScriptSession().getAttribute(name);
        } else if (scope.equals("request")) {
            object = webcx.getHttpServletRequest().getAttribute(name);
        }
        try {
            if (object == null) {
                create = true;
                object = this.creator.getInstance();
            }
        }
        catch (InstantiationException ex) {
            log.info((Object)("Error creating an instance of the following DWR Creator: " + (null != this.creator.getClass() ? this.creator.getClass().getName() : "None Specified") + "."), (Throwable)ex);
            throw ex;
        }
        if (create) {
            if (scope.equals("application")) {
                webcx.getServletContext().setAttribute(name, object);
            } else if (scope.equals("session")) {
                webcx.getSession().setAttribute(name, object);
            } else if (scope.equals("script")) {
                webcx.getScriptSession().setAttribute(name, object);
            } else if (scope.equals("request")) {
                webcx.getHttpServletRequest().setAttribute(name, object);
            }
        }
        return object;
    }

    @Override
    public String toString() {
        return this.creator.getClass().getSimpleName() + " for " + this.creator.getType().getName();
    }

    private Method unwrapProxiedMethod(Method method) {
        try {
            if (this.unwrappedTarget == null) {
                Object possiblyProxy = this.getScopedInstance();
                this.unwrappedTarget = this.unwrapProxy(possiblyProxy);
            }
            return this.unwrappedTarget.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return method;
        }
    }

    private Object unwrapProxy(Object instance) {
        Object unwrappedInstance = instance;
        if (advisedClass != null && advisedClass.isAssignableFrom(instance.getClass())) {
            try {
                Method targetSourceMethod = instance.getClass().getMethod("getTargetSource", new Class[0]);
                unwrappedInstance = targetSourceMethod.invoke(instance, new Object[0]);
            }
            catch (Exception targetSourceMethod) {}
        } else if (targetSourceClass != null && targetSourceClass.isAssignableFrom(instance.getClass())) {
            try {
                Method targetMethod = instance.getClass().getMethod("getTarget", new Class[0]);
                unwrappedInstance = targetMethod.invoke(instance, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (unwrappedInstance != instance) {
            unwrappedInstance = this.unwrapProxy(unwrappedInstance);
        }
        return unwrappedInstance;
    }

    static {
        log = LogFactory.getLog(CreatorModule.class);
        try {
            advisedClass = Class.forName("org.springframework.aop.framework.Advised");
            log.debug((Object)"Found org.springframework.aop.framework.Advised enabling AOP checks");
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"ClassNotFoundException on org.springframework.aop.framework.Advised skipping AOP checks");
        }
        try {
            targetSourceClass = Class.forName("org.springframework.aop.TargetSource");
            log.debug((Object)"Found org.springframework.aop.TargetSource enabling AOP checks");
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"ClassNotFoundException on org.springframework.aop.TargetSource skipping AOP checks");
        }
    }
}

