/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.extend.PlainProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.hibernate.H3PropertyDescriptorProperty;
import org.hibernate.Hibernate;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class H3BeanConverter
extends BeanConverter {
    protected boolean assumeSession = false;
    private final ConcurrentMap<String, Method> methods = new ConcurrentHashMap<String, Method>();
    private static final Log log = LogFactory.getLog(H3BeanConverter.class);

    @Override
    public Map<String, Property> getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws ConversionException {
        Class<?> clazz = this.getClass(example);
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (PropertyDescriptor descriptor : descriptors) {
                String name = descriptor.getName();
                if ("class".equals(name) || "hibernateLazyInitializer".equals(name) || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                if (!this.assumeSession) {
                    Method method = this.findGetter(example, name);
                    if (method == null) {
                        log.warn((Object)("Failed to find property: " + name));
                        properties.put(name, new PlainProperty(name, null));
                        continue;
                    }
                    if (!Hibernate.isPropertyInitialized((Object)example, (String)name)) {
                        properties.put(name, new PlainProperty(name, null));
                        continue;
                    }
                    Object retval = method.invoke(example, new Object[0]);
                    if (!Hibernate.isInitialized((Object)retval)) {
                        properties.put(name, new PlainProperty(name, null));
                        continue;
                    }
                }
                properties.put(name, new H3PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (Exception ex) {
            throw new ConversionException(clazz, (Throwable)ex);
        }
    }

    public Class<?> getClass(Object example) {
        if (example instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)example;
            LazyInitializer initializer = proxy.getHibernateLazyInitializer();
            SessionImplementor implementor = initializer.getSession();
            if (initializer.isUninitialized()) {
                try {
                    if (implementor.isClosed()) {
                        return example.getClass();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return initializer.getImplementation().getClass();
        }
        return example.getClass();
    }

    protected Method findGetter(Object data, String property) throws IntrospectionException {
        Class<?> clazz = this.getClass(data);
        String key = clazz.getName() + ":" + property;
        Method method = (Method)this.methods.get(key);
        if (method == null) {
            PropertyDescriptor[] props;
            Method newMethod = null;
            for (PropertyDescriptor prop : props = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!prop.getName().equalsIgnoreCase(property)) continue;
                newMethod = prop.getReadMethod();
            }
            method = this.methods.putIfAbsent(key, newMethod);
            if (method == null) {
                method = newMethod;
            }
        }
        return method;
    }

    public void setAssumeSession(boolean assumeSession) {
        this.assumeSession = assumeSession;
    }
}

