/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.directwebremoting.ServerContext;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.guice.AbstractDwrGuiceServletContextListener;
import org.directwebremoting.impl.StartupUtil;

public class DwrGuiceUtil {
    public static final String INJECTOR = "org.directwebremoting.guice.Injector";
    private static final ThreadLocal<LinkedList<ServletContext>> servletContexts = new ThreadLocal<LinkedList<ServletContext>>(){

        @Override
        protected LinkedList<ServletContext> initialValue() {
            return new LinkedList<ServletContext>();
        }
    };

    public static Injector getInjector() {
        return AbstractDwrGuiceServletContextListener.getPublishedInjector(DwrGuiceUtil.getServletContext());
    }

    public static ServletContext getServletContext() {
        LinkedList<ServletContext> sclist = servletContexts.get();
        if (!sclist.isEmpty()) {
            return sclist.getFirst();
        }
        WebContext webcx = WebContextFactory.get();
        if (webcx != null) {
            return webcx.getServletContext();
        }
        ServerContext serverContext = StartupUtil.getSingletonServerContext();
        if (serverContext != null) {
            return serverContext.getServletContext();
        }
        Iterator<ServerContext> iterator = StartupUtil.getAllServerContexts().iterator();
        if (iterator.hasNext()) {
            ServerContext sc = iterator.next();
            return sc.getServletContext();
        }
        return null;
    }

    public static void withServletContext(ServletContext servletContext, Runnable runnable) {
        DwrGuiceUtil.pushServletContext(servletContext);
        try {
            runnable.run();
        }
        finally {
            DwrGuiceUtil.popServletContext();
        }
    }

    public static <T> T withServletContext(ServletContext servletContext, Callable<T> callable) throws Exception {
        DwrGuiceUtil.pushServletContext(servletContext);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            DwrGuiceUtil.popServletContext();
        }
    }

    private static void pushServletContext(ServletContext context) {
        servletContexts.get().addFirst(context);
    }

    private static void popServletContext() {
        servletContexts.get().removeFirst();
    }
}

