/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.Module;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.util.LocalUtil;

public class Call {
    private final String callId;
    private final String scriptName;
    private final String methodName;
    private MethodDeclaration methodDeclaration = null;
    private Object[] parameters = null;
    private Throwable exception = null;
    private static final Log log = LogFactory.getLog(Call.class);

    public Call(String callId, String scriptName, String methodName) {
        this.callId = callId;
        this.scriptName = scriptName;
        this.methodName = methodName;
    }

    public void setMarshallFailure(Throwable exception) {
        this.exception = exception;
        this.methodDeclaration = null;
        this.parameters = null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public MethodDeclaration getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public void setMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.methodDeclaration = methodDeclaration;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void findMethod(ModuleManager moduleManager, ConverterManager converterManager, InboundContext inctx, int callNum) {
        Class<?>[] methodParamTypes;
        Object m;
        if (this.scriptName == null) {
            throw new IllegalArgumentException("Missing class parameter");
        }
        if (this.methodName == null) {
            throw new IllegalArgumentException("Missing method parameter");
        }
        int inputArgCount = inctx.getParameterCount(callNum);
        Module module = moduleManager.getModule(this.scriptName, true);
        ArrayList<MethodDeclaration> allMethods = new ArrayList<MethodDeclaration>();
        allMethods.addAll(Arrays.asList(module.getMethods()));
        Iterator it = allMethods.iterator();
        while (it.hasNext()) {
            if (((MethodDeclaration)it.next()).getName().equals(this.methodName)) continue;
            it.remove();
        }
        if (allMethods.isEmpty()) {
            log.warn((Object)("No method called '" + this.methodName + "' found in " + module.toString()));
            throw new IllegalArgumentException("Method name not found. See logs for details");
        }
        it = allMethods.iterator();
        block1: while (it.hasNext()) {
            m = (MethodDeclaration)it.next();
            methodParamTypes = ((MethodDeclaration)m).getParameterTypes();
            if (!((MethodDeclaration)m).isVarArgs() && methodParamTypes.length < inputArgCount) {
                it.remove();
                continue;
            }
            int argIndex = 0;
            for (int paramIndex = 0; paramIndex < methodParamTypes.length; ++paramIndex) {
                Class<?> methodParamType = methodParamTypes[paramIndex];
                if (LocalUtil.isServletClass(methodParamType)) continue;
                InboundVariable param = inctx.getParameter(callNum, argIndex);
                Class<?> inputType = converterManager.getClientDeclaredType(param);
                if (inputType == null && !converterManager.isConvertable(methodParamType)) {
                    it.remove();
                    continue block1;
                }
                if (inputArgCount <= argIndex && methodParamType.isPrimitive()) {
                    it.remove();
                    continue block1;
                }
                if (inputType != null && !methodParamType.isAssignableFrom(inputType)) {
                    it.remove();
                    continue block1;
                }
                ++argIndex;
            }
        }
        if (allMethods.size() > 1) {
            it = allMethods.iterator();
            block3: while (it.hasNext()) {
                m = (MethodDeclaration)it.next();
                methodParamTypes = ((MethodDeclaration)m).getParameterTypes();
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    Class<?> methodParamType = methodParamTypes[i];
                    InboundVariable param = inctx.getParameter(callNum, i);
                    String javaScriptType = param.getType();
                    if (((MethodDeclaration)m).isVarArgs() && !"array".equals(javaScriptType) && i == methodParamTypes.length - 1) {
                        methodParamType = methodParamType.getComponentType();
                    }
                    if (LocalUtil.isJavaScriptTypeAssignableTo(javaScriptType, methodParamType)) continue;
                    it.remove();
                    continue block3;
                }
            }
        }
        if (allMethods.isEmpty()) {
            log.warn((Object)("No methods called '" + this.methodName + "' in " + module.toString() + " are applicable for the passed parameters."));
            throw new IllegalArgumentException("Method not found. See logs for details");
        }
        if (allMethods.size() == 1) {
            this.methodDeclaration = (MethodDeclaration)allMethods.get(0);
            return;
        }
        ArrayList<MethodDeclaration> exactParamCountMatches = new ArrayList<MethodDeclaration>();
        for (MethodDeclaration m2 : allMethods) {
            if (m2.isVarArgs() || m2.getParameterTypes().length != inputArgCount) continue;
            exactParamCountMatches.add(m2);
        }
        if (exactParamCountMatches.size() == 1) {
            this.methodDeclaration = (MethodDeclaration)exactParamCountMatches.get(0);
            return;
        }
        if (exactParamCountMatches.size() == 2) {
            int choose = -1;
            boolean compatible = true;
            Class<?>[] params1 = ((MethodDeclaration)exactParamCountMatches.get(0)).getParameterTypes();
            Class<?>[] params2 = ((MethodDeclaration)exactParamCountMatches.get(1)).getParameterTypes();
            for (int i = 0; i < params1.length; ++i) {
                if (!compatible || params1[i].equals(params2[i])) continue;
                if (choose < 0) {
                    choose = params1[i].isAssignableFrom(params2[i]) ? 1 : 0;
                }
                compatible &= choose == 1 || params2[i].isAssignableFrom(params1[i]);
            }
            if (compatible && choose >= 0) {
                this.methodDeclaration = (MethodDeclaration)exactParamCountMatches.get(choose);
                return;
            }
        }
        ArrayList<MethodDeclaration> varargsMethods = new ArrayList<MethodDeclaration>();
        for (MethodDeclaration m3 : allMethods) {
            if (!m3.isVarArgs()) continue;
            varargsMethods.add(m3);
        }
        if (varargsMethods.size() == 1) {
            this.methodDeclaration = (MethodDeclaration)varargsMethods.get(0);
            return;
        }
        log.warn((Object)("Can't find single method to match method '" + this.methodName + "' in " + module.toString()));
        log.warn((Object)"- DWR does not continue where there is ambiguity about which method to execute.");
        log.warn((Object)("- Input parameters: " + inputArgCount + ".Matching methods with param count match: " + exactParamCountMatches.size() + ". Number of matching varargs methods: " + varargsMethods.size()));
        log.warn((Object)"- Potential matches include:");
        for (MethodDeclaration m4 : allMethods) {
            log.warn((Object)("  - " + m4.toString()));
        }
        throw new IllegalArgumentException("Method not found. See logs for details");
    }

    public String toString() {
        try {
            return this.scriptName + "." + this.methodName + "(...)";
        }
        catch (Exception ex) {
            return "Call(undefined)";
        }
    }
}

