/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.FileUpload;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.LocalUtil;

public class Batch {
    private String batchId;
    private String instanceId;
    private Long nextReverseAjaxIndex;
    private final boolean get;
    private String scriptSessionId;
    private String dwrSessionId;
    private String page;
    private String documentDomain;
    private final Map<String, FormField> extraParameters;
    private String parametersDebug = null;
    protected static final String THROW = "throw";
    private static final FileUpload UPLOADER;
    private static final Log log;

    public Batch(HttpServletRequest request) throws ServerException {
        this.get = "GET".equals(request.getMethod());
        this.extraParameters = this.get ? this.parseGet(request) : this.parsePost(request);
        this.parseParameters();
    }

    public Batch(Map<String, FormField> allParameters, boolean get) {
        this.extraParameters = allParameters;
        this.get = get;
        if (log.isDebugEnabled()) {
            this.parametersDebug = allParameters.toString();
        }
        this.parseParameters();
    }

    private void parseParameters() {
        this.batchId = this.extractParameter("batchId", THROW);
        if (!LocalUtil.isLetterOrDigitOrUnderline(this.batchId)) {
            throw new SecurityException("Batch IDs must be a number");
        }
        this.instanceId = this.extractParameter("instanceId", THROW);
        if (!LocalUtil.isLetterOrDigitOrUnderline(this.instanceId)) {
            throw new SecurityException("Batch instance IDs must be a number");
        }
        this.scriptSessionId = this.extractParameter("scriptSessionId", THROW);
        this.dwrSessionId = this.scriptSessionId.contains("/") ? this.scriptSessionId.substring(0, this.scriptSessionId.indexOf(47)) : "";
        String nextReverseAjaxIndexStr = this.extractParameter("nextReverseAjaxIndex", null);
        if (nextReverseAjaxIndexStr != null) {
            this.nextReverseAjaxIndex = Long.parseLong(nextReverseAjaxIndexStr);
        }
        this.documentDomain = this.extractParameter("documentDomain", null);
        this.page = LocalUtil.urlDecode(this.extractParameter("page", THROW));
    }

    protected String extractParameter(String paramName, String defaultValue) {
        FormField formField = this.extraParameters.remove(paramName);
        if (formField != null) {
            return formField.getString();
        }
        if (defaultValue == THROW) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to find parameter: " + paramName + " in batch parameters:\n" + this.parametersDebug));
            } else {
                log.error((Object)("Failed to find parameter: " + paramName + ", enable debug logging to see more info."));
            }
            throw new IllegalArgumentException("Failed to find parameter: " + paramName + " (check server log for more info).");
        }
        return defaultValue;
    }

    private Map<String, FormField> parsePost(HttpServletRequest req) throws ServerException {
        Map<String, FormField> paramMap = Batch.isMultipartContent(req) ? UPLOADER.parseRequest(req) : this.parseBasicPost(req);
        if (paramMap.size() == 1) {
            Batch.parseBrokenMacPost(paramMap);
        }
        return paramMap;
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    private Map<String, FormField> parseBasicPost(HttpServletRequest req) throws ServerException {
        HashMap<String, FormField> paramMap = new HashMap<String, FormField>();
        StringBuilder debugBuf = new StringBuilder();
        BufferedReader in = null;
        try {
            String charEncoding = req.getCharacterEncoding();
            in = charEncoding != null ? new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), charEncoding)) : new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
            block9: while (true) {
                String line;
                if ((line = in.readLine()) == null) {
                    if (paramMap.isEmpty()) {
                        Enumeration en = req.getParameterNames();
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            paramMap.put(name, new FormField(req.getParameter(name)));
                        }
                    }
                    break;
                }
                if (log.isDebugEnabled()) {
                    debugBuf.append(line);
                    debugBuf.append("\n");
                }
                if (line.indexOf(38) != -1) {
                    log.debug((Object)"Using iframe POST mode");
                    StringTokenizer st = new StringTokenizer(line, "&");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block9;
                        String part = st.nextToken();
                        part = LocalUtil.urlDecode(part);
                        Batch.parsePostLine(part, paramMap);
                    }
                }
                Batch.parsePostLine(line, paramMap);
            }
        }
        catch (Exception ex) {
            throw new ServerException("Failed to read input", ex);
        }
        finally {
            if (log.isDebugEnabled()) {
                this.parametersDebug = debugBuf.toString();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return paramMap;
    }

    private static void parseBrokenMacPost(Map<String, FormField> paramMap) {
        log.debug((Object)"Using Broken Safari POST mode");
        Iterator<Map.Entry<String, FormField>> it = paramMap.entrySet().iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("No entries in non empty map!");
        }
        Map.Entry<String, FormField> entry = it.next();
        String key = entry.getKey();
        String value = entry.getValue().getString();
        String line = key + "=" + value;
        StringTokenizer st = new StringTokenizer(line, "\n");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            part = LocalUtil.urlDecode(part);
            Batch.parsePostLine(part, paramMap);
        }
    }

    private static void parsePostLine(String line, Map<String, FormField> paramMap) {
        if (line.length() == 0) {
            return;
        }
        int sep = line.indexOf("=");
        if (sep == -1) {
            paramMap.put(line, null);
        } else {
            String key = line.substring(0, sep);
            String value = line.substring(sep + "=".length());
            paramMap.put(key, new FormField(value));
        }
    }

    private Map<String, FormField> parseGet(HttpServletRequest req) throws ServerException {
        if (log.isDebugEnabled()) {
            this.parametersDebug = req.getQueryString();
        }
        HashMap<String, FormField> convertedMap = new HashMap<String, FormField>();
        Map paramMap = req.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] array = (String[])entry.getValue();
            if (array.length == 1) {
                convertedMap.put(key, new FormField(array[0]));
                continue;
            }
            log.error((Object)("Multiple values for key: " + key + "in parameters:\n" + req.getQueryString()));
            throw new ServerException("Multiple values for key. See console for more information");
        }
        return convertedMap;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Long getNextReverseAjaxIndex() {
        return this.nextReverseAjaxIndex;
    }

    public boolean isGet() {
        return this.get;
    }

    public String getScriptSessionId() {
        return this.scriptSessionId;
    }

    public String getDwrSessionId() {
        return this.dwrSessionId;
    }

    public String getPage() {
        return this.page;
    }

    public String getDocumentDomain() {
        return this.documentDomain;
    }

    public Map<String, FormField> getExtraParameters() {
        return this.extraParameters;
    }

    static {
        Container container = WebContextFactory.get().getContainer();
        UPLOADER = container.getBean(FileUpload.class);
        log = LogFactory.getLog(Batch.class);
    }
}

