/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.datasync;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.datasync.AbstractStoreProvider;
import org.directwebremoting.io.Item;
import org.directwebremoting.io.ItemUpdate;
import org.directwebremoting.io.MatchedItems;
import org.directwebremoting.io.SortCriterion;
import org.directwebremoting.io.StoreChangeListener;
import org.directwebremoting.io.StoreRegion;

class SqlStoreProvider<T>
extends AbstractStoreProvider<T> {
    private static final String BASE_SQL = "SELECT col1, col2 FROM table";
    protected DataSource dataSource;
    private static final Log log = LogFactory.getLog(SqlStoreProvider.class);

    private SqlStoreProvider(Class<T> type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchedItems view(StoreRegion region) {
        Object paging;
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, String> entry : region.getQuery().entrySet()) {
            if (where.length() == 0) {
                where.append(" WHERE ");
            } else {
                where.append(" AND ");
            }
            String key = entry.getKey();
            where.append(key);
            where.append(" = :");
            where.append(key);
            params.add(entry.getValue());
        }
        StringBuilder orderBy = new StringBuilder();
        for (SortCriterion element : region.getSort()) {
            if (where.length() == 0) {
                where.append(" ORDER BY ");
            } else {
                where.append(", ");
            }
            where.append(element.getAttribute());
            where.append(element.isAscending() ? "ASC" : "DESC");
        }
        int n = region.getStart();
        int count = region.getCount();
        if (n == 0) {
            paging = count == -1 ? "" : " LIMIT " + count;
        } else {
            if (count == -1) {
                throw new UnsupportedOperationException("Can't select a start point without selecting a count");
            }
            paging = " LIMIT " + count + " OFFSET " + n;
        }
        String sql = BASE_SQL + where + orderBy + (String)paging;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Item> matchedValues = new ArrayList<Item>();
        try {
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(sql);
            int index = 1;
            for (String element : params) {
                stmt.setString(index++, element);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            String[] columnNames = new String[columnCount + 1];
            for (int col = 1; col <= columnCount; ++col) {
                columnNames[col] = metaData.getColumnName(col);
            }
            HashMap<String, String> data = new HashMap<String, String>();
            while (rs.next()) {
                String itemId = rs.getString(1);
                for (int col = 2; col <= columnCount; ++col) {
                    data.put(columnNames[col], rs.getString(col));
                }
                matchedValues.add(new Item(itemId, data));
            }
        }
        catch (SQLException ex) {
            log.warn((Object)"SQL Failure", (Throwable)ex);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex2) {
                    log.warn((Object)"Error closing connection", (Throwable)ex2);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex2) {
                    log.warn((Object)"Error closing statement", (Throwable)ex2);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex2) {
                    log.warn((Object)"Error closing resultset", (Throwable)ex2);
                }
            }
        }
        MatchedItems reply = new MatchedItems(matchedValues, -1);
        return reply;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void put(String itemId, T value) {
        throw new UnsupportedOperationException("SqlStoreProvider is read only");
    }

    @Override
    protected T getObject(String itemId) {
        return null;
    }

    @Override
    public void unsubscribe(StoreChangeListener<T> listener) {
    }

    @Override
    public void update(List<ItemUpdate> changes) {
    }

    @Override
    public Item viewItem(String itemId, StoreChangeListener<T> listener) {
        return null;
    }

    @Override
    public MatchedItems viewRegion(StoreRegion region) {
        return null;
    }

    @Override
    public MatchedItems viewRegion(StoreRegion region, StoreChangeListener<T> listener) {
        return null;
    }
}

