/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XOMConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.urlDecode();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            try {
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            Builder builder = new Builder(reader);
            Document doc = builder.build((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            if (!(data instanceof Node)) {
                throw new ConversionException(data.getClass());
            }
            Node node = (Node)data;
            String script = data instanceof Element ? EnginePrivate.xmlStringToJavascriptDomElement(node.toXML()) : EnginePrivate.xmlStringToJavascriptDomDocument(node.toXML());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
    }
}

