/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

public class PrimitiveConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(PrimitiveConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue().trim();
        try {
            return LocalUtil.simpleConvert(value, paramType);
        }
        catch (NumberFormatException ex) {
            log.debug((Object)("Error converting " + value + " to a number."));
            throw new ConversionException(paramType, "Format error converting number.");
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException(paramType);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        Class<?> paramType = data.getClass();
        if (data.equals(Boolean.TRUE)) {
            return new NonNestedOutboundVariable("true");
        }
        if (data.equals(Boolean.FALSE)) {
            return new NonNestedOutboundVariable("false");
        }
        if (paramType == Character.class) {
            return new NonNestedOutboundVariable("\"" + JavascriptUtil.escapeJavaScript(data.toString()) + "\"");
        }
        return new NonNestedOutboundVariable(data.toString());
    }
}

