/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDOMConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.urlDecode();
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            try {
                builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            Document doc = builder.build((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            String script;
            StringWriter xml;
            Format outformat = Format.getRawFormat();
            outformat.setEncoding("UTF-8");
            if (data instanceof Document) {
                xml = new StringWriter();
                XMLOutputter writer = new XMLOutputter(outformat);
                writer.output((Document)data, (Writer)xml);
                xml.flush();
                script = EnginePrivate.xmlStringToJavascriptDomDocument(xml.toString());
            } else if (data instanceof Element) {
                xml = new StringWriter();
                XMLOutputter writer = new XMLOutputter(outformat);
                writer.output((Element)data, (Writer)xml);
                xml.flush();
                script = EnginePrivate.xmlStringToJavascriptDomElement(xml.toString());
            } else {
                throw new ConversionException(data.getClass());
            }
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
    }
}

