/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMConverter
extends AbstractConverter {
    private final TransformerFactory xslFact = TransformerFactory.newInstance();
    private DocumentBuilderFactory buildFactory = null;

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.urlDecode();
        try {
            if (this.buildFactory == null) {
                this.buildFactory = DocumentBuilderFactory.newInstance();
                this.buildFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.buildFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                try {
                    this.buildFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DocumentBuilder builder = this.buildFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            InputSource is = new InputSource(new StringReader(value));
            Document doc = builder.parse(is);
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getDocumentElement();
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            Transformer transformer = this.xslFact.newTransformer();
            if (!(data instanceof Node)) {
                throw new ConversionException(data.getClass());
            }
            Node node = (Node)data;
            DOMSource source = new DOMSource(node);
            StringWriter xml = new StringWriter();
            StreamResult result = new StreamResult(xml);
            transformer.transform(source, result);
            xml.flush();
            String script = data instanceof Element ? EnginePrivate.xmlStringToJavascriptDomElement(xml.toString()) : EnginePrivate.xmlStringToJavascriptDomDocument(xml.toString());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
    }
}

