/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOM4JConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.urlDecode();
        try {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            try {
                xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            xmlReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            Document doc = xmlReader.read((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            if (!(data instanceof Node)) {
                throw new ConversionException(data.getClass());
            }
            Node node = (Node)data;
            OutputFormat outformat = OutputFormat.createCompactFormat();
            outformat.setEncoding("UTF-8");
            StringWriter xml = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)xml, outformat);
            writer.write(node);
            writer.flush();
            xml.flush();
            String script = data instanceof Element ? EnginePrivate.xmlStringToJavascriptDomElement(xml.toString()) : EnginePrivate.xmlStringToJavascriptDomDocument(xml.toString());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
    }
}

