/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.ConstructorProperty;
import org.directwebremoting.extend.ConvertUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.ObjectOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Pair;

public abstract class BasicObjectConverter
implements NamedConverter {
    protected ConverterManager converterManager = null;
    protected String javascript = null;
    protected String javascriptSuperClass = null;
    protected Class<?> instanceType = null;
    protected String paramsString;
    protected Map<Class<?>, Constructor<?>> constructorCache = new HashMap();
    protected final List<Pair<Class<?>, String>> parameters = new ArrayList();
    protected List<String> exclusions = null;
    protected List<String> inclusions = null;
    private static final Log log = LogFactory.getLog(BasicObjectConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value == null) {
            throw new NullPointerException(data.toString());
        }
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{") || !value.endsWith("}")) {
            log.warn((Object)("Expected object while converting data for " + paramType.getName() + " in " + data.getContext().getCurrentProperty() + ". Passed: " + value));
            throw new ConversionException(paramType, "Data conversion error. See logs for more details.");
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map<String, String> tokens = BasicObjectConverter.extractInboundTokens(paramType, value);
            if (this.paramsString == null) {
                return this.createUsingSetterInjection(paramType, data, tokens);
            }
            return this.createUsingConstructorInjection(paramType, data, tokens);
        }
        catch (InvocationTargetException ex) {
            throw new ConversionException(paramType, ex.getTargetException());
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    private Object createUsingConstructorInjection(Class<?> paramType, InboundVariable data, Map<String, String> tokens) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor;
        Class<?> type = this.instanceType != null ? this.instanceType : paramType;
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        for (Pair<Class<?>, String> parameter : this.parameters) {
            parameterTypes.add((Class)parameter.left);
        }
        Class[] paramTypeArray = parameterTypes.toArray(new Class[parameterTypes.size()]);
        try {
            constructor = type.getConstructor(paramTypeArray);
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)("Can't find a constructor for " + type.getName() + " with params " + parameterTypes));
            throw ex;
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        int paramNum = 0;
        for (Pair<Class<?>, String> parameter : this.parameters) {
            String argument = tokens.get(parameter.right);
            ConstructorProperty property = new ConstructorProperty(constructor, (String)parameter.right, paramNum);
            Object output = this.convert(argument, (Class)parameter.left, data.getContext(), property);
            arguments.add(output);
            ++paramNum;
        }
        Object[] argArray = arguments.toArray(new Object[arguments.size()]);
        try {
            return constructor.newInstance(argArray);
        }
        catch (InstantiationException ex) {
            log.error((Object)("Error building using constructor " + constructor.getName() + " with arguments " + argArray));
            throw ex;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("Error building using constructor " + constructor.getName() + " with arguments " + argArray));
            throw ex;
        }
        catch (InvocationTargetException ex) {
            log.error((Object)("Error building using constructor " + constructor.getName() + " with arguments " + argArray));
            throw ex;
        }
    }

    private Object createUsingSetterInjection(Class<?> paramType, InboundVariable data, Map<String, String> tokens) throws InstantiationException, IllegalAccessException {
        Object bean = this.instanceType != null ? this.instanceType.newInstance() : this.createParameterInstance(paramType);
        if (this.instanceType != null) {
            data.getContext().addConverted(data, this.instanceType, bean);
        } else {
            data.getContext().addConverted(data, paramType, bean);
        }
        Map<String, Property> properties = this.getPropertyMapFromObject(bean, false, true);
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("%24dwr")) continue;
            Property property = properties.get(key);
            if (property == null) {
                log.warn((Object)("Missing setter: " + paramType.getName() + ".set" + Character.toTitleCase(key.charAt(0)) + key.substring(1) + "() to match javascript property: " + key + ". Check include/exclude rules and overloaded methods."));
                continue;
            }
            Object output = this.convert(entry.getValue(), property.getPropertyType(), data.getContext(), property);
            property.setValue(bean, output);
        }
        return bean;
    }

    protected Object createParameterInstance(Class<?> paramType) throws InstantiationException, IllegalAccessException {
        return paramType.newInstance();
    }

    protected Object convert(String val, Class<?> propType, InboundContext inboundContext, Property property) {
        String[] split = ConvertUtil.splitInbound(val);
        String splitValue = split[1];
        String splitType = split[0];
        InboundVariable nested = new InboundVariable(inboundContext, null, splitType, splitValue);
        nested.dereference();
        Property incc = this.createTypeHintContext(inboundContext, property);
        return this.converterManager.convertInbound(propType, nested, incc);
    }

    protected abstract Property createTypeHintContext(InboundContext var1, Property var2);

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        TreeMap<String, OutboundVariable> ovs = new TreeMap<String, OutboundVariable>();
        ObjectOutboundVariable ov = new ObjectOutboundVariable(outctx, data.getClass(), this.getJavascript());
        outctx.put(data, ov);
        try {
            Map<String, Property> properties = this.getPropertyMapFromObject(data, true, false);
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                String name = entry.getKey();
                Property property = entry.getValue();
                Object value = property.getValue(data);
                OutboundVariable nested = this.getConverterManager().convertOutbound(value, outctx);
                ovs.put(name, nested);
            }
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(data.getClass(), (Throwable)ex);
        }
        ov.setChildren(ovs);
        return ov;
    }

    public void setExclude(String excludes) {
        if (this.inclusions != null) {
            throw new IllegalArgumentException("Can't have both inclusions and exclusions for a Converter");
        }
        this.exclusions = new ArrayList<String>();
        String toSplit = excludes.replace(",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn((Object)("Exclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name."));
            }
            this.exclusions.add(rule);
        }
    }

    public void setInclude(String includes) {
        if (this.exclusions != null) {
            throw new IllegalArgumentException("Can't have both inclusions and exclusions for a Converter");
        }
        this.inclusions = new ArrayList<String>();
        String toSplit = includes.replace(",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn((Object)("Inclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name."));
            }
            this.inclusions.add(rule);
        }
    }

    public void setImplementation(String name) throws ClassNotFoundException {
        this.setInstanceType(LocalUtil.classForName(name));
    }

    protected boolean isAllowedByIncludeExcludeRules(String property) {
        if (this.exclusions != null) {
            for (String exclusion : this.exclusions) {
                if (!property.equals(exclusion)) continue;
                return false;
            }
        }
        if (this.inclusions != null) {
            for (String inclusion : this.inclusions) {
                if (!property.equals(inclusion)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static Map<String, String> extractInboundTokens(Class<?> paramType, String value) throws ConversionException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            if (token.trim().length() == 0) continue;
            int colonpos = token.indexOf(":");
            if (colonpos == -1) {
                throw new ConversionException(paramType, "Missing : in object description: " + token);
            }
            String key = token.substring(0, colonpos).trim();
            String val = token.substring(colonpos + 1).trim();
            tokens.put(key, val);
        }
        return tokens;
    }

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    @Override
    public String getJavascript() {
        return this.javascript;
    }

    @Override
    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    @Override
    public String getJavascriptSuperClass() {
        return this.javascriptSuperClass;
    }

    @Override
    public void setJavascriptSuperClass(String javascriptSuperClass) {
        this.javascriptSuperClass = javascriptSuperClass;
    }

    @Override
    public Class<?> getInstanceType() {
        return this.instanceType;
    }

    @Override
    public void setInstanceType(Class<?> instanceType) {
        this.instanceType = instanceType;
    }

    public void setConstructor(String paramsString) {
        this.paramsString = paramsString;
        StringTokenizer st = new StringTokenizer(paramsString, ",");
        while (st.hasMoreTokens()) {
            String paramString = st.nextToken().trim();
            String[] paramParts = paramString.split(" ");
            if (paramParts.length != 2) {
                log.error((Object)("Parameter list includes parameter '" + paramString + "' that can't be parsed into a [type] and [name]"));
                throw new IllegalArgumentException("Badly formatted constructor parameter list. See log console for details.");
            }
            String typeName = paramParts[0];
            try {
                Class<?> type = LocalUtil.classForName(typeName);
                Pair parameter = new Pair(type, paramParts[1]);
                this.parameters.add(parameter);
            }
            catch (ClassNotFoundException ex) {
                if (typeName.contains(".")) {
                    log.error((Object)("Parameter list includes unknown type '" + typeName + "'"));
                    throw new IllegalArgumentException("Unknown type in constructor parameter list. See log console for details.");
                }
                try {
                    Class<?> type = LocalUtil.classForName("java.lang." + typeName);
                    Pair parameter = new Pair(type, paramParts[1]);
                    this.parameters.add(parameter);
                }
                catch (ClassNotFoundException ex2) {
                    log.error((Object)("Parameter list includes unknown type '" + typeName + "' (also tried java.lang." + typeName + ")"));
                    throw new IllegalArgumentException("Unknown type in constructor parameter list. See log console for details.");
                }
            }
        }
    }

    public List<String> getInclusions() {
        return Collections.unmodifiableList(this.inclusions);
    }
}

