/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.beehive;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

public class PageFlowCreator
extends AbstractCreator
implements Creator {
    private static final Log log = LogFactory.getLog(PageFlowCreator.class);
    private Class<?> instanceType = null;
    private Method getter = null;
    private Method bhGetter = null;
    private Method wlGetter = null;
    private Class<?> bhFlowClass = null;
    private Class<?> wlFlowClass = null;

    public PageFlowCreator() throws ClassNotFoundException {
        try {
            this.bhFlowClass = LocalUtil.classForName("org.apache.beehive.netui.pageflow.PageFlowController");
            Class<?> bhUtilClass = LocalUtil.classForName("org.apache.beehive.netui.pageflow.PageFlowUtils");
            this.bhGetter = bhUtilClass.getMethod("getCurrentPageFlow", HttpServletRequest.class);
        }
        catch (Exception bhUtilClass) {
            // empty catch block
        }
        try {
            this.wlFlowClass = LocalUtil.classForName("com.bea.wlw.netui.pageflow.PageFlowController");
            Class<?> wlUtilClass = LocalUtil.classForName("com.bea.wlw.netui.pageflow.PageFlowUtils");
            this.wlGetter = wlUtilClass.getMethod("getCurrentPageFlow", HttpServletRequest.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.bhGetter == null && this.wlGetter == null || this.bhFlowClass == null && this.wlFlowClass == null) {
            throw new ClassNotFoundException("Beehive/Weblogic jar file not available.");
        }
    }

    public void setForceWebLogic(boolean forceWebLogic) {
        if (forceWebLogic) {
            this.bhGetter = null;
            this.bhFlowClass = null;
        }
    }

    @Override
    public Object getInstance() throws InstantiationException {
        if (this.getter == null) {
            this.getter = this.bhGetter != null ? this.bhGetter : this.wlGetter;
        }
        try {
            HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
            return this.getter.invoke(null, request);
        }
        catch (InvocationTargetException ex) {
            throw new InstantiationException(ex.getTargetException().toString());
        }
        catch (Exception ex) {
            throw new InstantiationException(ex.toString());
        }
    }

    @Override
    public Class<?> getType() {
        if (this.instanceType == null) {
            try {
                this.instanceType = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error((Object)"Failed to instansiate object to detect type.", (Throwable)ex);
                return Object.class;
            }
        }
        return this.instanceType;
    }
}

