/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting;

import java.util.ArrayList;
import java.util.Collection;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ScriptSessionFilter;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AllScriptSessionFilter;
import org.directwebremoting.extend.AndScriptSessionFilter;
import org.directwebremoting.extend.IdScriptSessionFilter;
import org.directwebremoting.extend.PageScriptSessionFilter;
import org.directwebremoting.extend.TaskDispatcher;
import org.directwebremoting.extend.TaskDispatcherFactory;
import org.directwebremoting.io.JavascriptObject;

public class Browser {
    private static final ThreadLocal<ServerContext> currentServerContext = new ThreadLocal();

    public static void withAllSessions(Runnable task) {
        Browser.withAllSessions(Browser.getServerContext(), task);
    }

    public static void withAllSessions(ServerContext serverContext, Runnable task) {
        currentServerContext.set(serverContext);
        try {
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
            taskDispatcher.dispatchTask(new AllScriptSessionFilter(), task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    public static void withAllSessionsFiltered(ScriptSessionFilter filter, Runnable task) {
        Browser.withAllSessionsFiltered(Browser.getServerContext(), filter, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withAllSessionsFiltered(ServerContext serverContext, ScriptSessionFilter filter, Runnable task) {
        currentServerContext.set(serverContext);
        try {
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
            taskDispatcher.dispatchTask(filter, task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCurrentPage(Runnable task) {
        WebContext webContext = WebContextFactory.get();
        currentServerContext.set(webContext);
        try {
            String page = webContext.getCurrentPage();
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(webContext);
            taskDispatcher.dispatchTask(new PageScriptSessionFilter(webContext, page), task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    public static void withPage(String page, Runnable task) {
        Browser.withPage(Browser.getServerContext(), page, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withPage(ServerContext serverContext, String page, Runnable task) {
        currentServerContext.set(serverContext);
        try {
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
            taskDispatcher.dispatchTask(new PageScriptSessionFilter(serverContext, page), task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    public static void withCurrentPageFiltered(ScriptSessionFilter filter, Runnable task) {
        WebContext webContext = WebContextFactory.get();
        String page = webContext.getCurrentPage();
        PageScriptSessionFilter pageFilter = new PageScriptSessionFilter(webContext, page);
        AndScriptSessionFilter realFilter = new AndScriptSessionFilter(pageFilter, filter);
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(webContext);
        taskDispatcher.dispatchTask(realFilter, task);
    }

    public static void withPageFiltered(String page, ScriptSessionFilter filter, Runnable task) {
        Browser.withPageFiltered(Browser.getServerContext(), page, filter, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withPageFiltered(ServerContext serverContext, String page, ScriptSessionFilter filter, Runnable task) {
        currentServerContext.set(serverContext);
        try {
            PageScriptSessionFilter pageFilter = new PageScriptSessionFilter(serverContext, page);
            AndScriptSessionFilter realFilter = new AndScriptSessionFilter(pageFilter, filter);
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
            taskDispatcher.dispatchTask(realFilter, task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    public static void withSession(String sessionId, Runnable task) {
        Browser.withSession(Browser.getServerContext(), sessionId, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withSession(ServerContext serverContext, String sessionId, Runnable task) {
        currentServerContext.set(serverContext);
        try {
            TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(serverContext);
            taskDispatcher.dispatchTask(new IdScriptSessionFilter(sessionId), task);
        }
        finally {
            currentServerContext.remove();
        }
    }

    public static void close(Object proxy) {
        if (proxy instanceof JavascriptObject) {
            JavascriptObject dproxy = (JavascriptObject)proxy;
            dproxy.close();
        }
    }

    public static Collection<ScriptSession> getTargetSessions() {
        TaskDispatcher taskDispatcher = TaskDispatcherFactory.get(Browser.getServerContext());
        Collection<ScriptSession> sessions = taskDispatcher.getTargetSessions();
        if (sessions != null) {
            return sessions;
        }
        WebContext webContext = WebContextFactory.get();
        if (webContext != null) {
            sessions = new ArrayList<ScriptSession>();
            sessions.add(webContext.getScriptSession());
            return sessions;
        }
        throw new IllegalStateException("No current UI to manipulate. See org.directwebremoting.Browser to set one.");
    }

    private static ServerContext getServerContext() {
        ServerContext servCtx = currentServerContext.get();
        if (servCtx != null) {
            return servCtx;
        }
        return ServerContextFactory.get();
    }
}

