(function () {
	CKEDITOR.plugins.add("accordion", {
		requires: ["button", "dialog"],
		init: function (editor) {
			CKEDITOR.skin.addIcon("accordion", this.path + "icon/accordion.png");
			CKEDITOR.dialog.add("accordion", this.path + "dialogs/accordion.js");

			editor.filter.allow(
				"div(!panel,!panel-default,!panel-collapse,!collapse,!panel-heading,!panel-body){!id,!data-bs.collapse}; " +
					"h4(!panel-title,!clearfix); " +
					"a(!collapsed)[!href,!role,!data-toggle]; " +
					"span(!caret); ",
				"accordion"
			);

			editor.addCommand("open.accordion.dialog", {
				context: "accordion",
				exec: function () {
					editor.openDialog("accordion");
				}
			});

			editor.widgets.add("accordion", {
				allowedContent:
					"div(!panel,!panel-default,!panel-collapse,!collapse,!panel-heading,!panel-body){!id,!data-bs.collapse}; " +
					"h4(!panel-title); " +
					"a(!collapsed)[!href,!role,!data-toggle]; " +
					"span(!caret); ",

				template:
					'<div class="panel panel-default">' +
					'<div class="panel-heading">' +
					"<h4 class='panel-title'>" +
					'<a class="collapsed" role="button" data-toggle="collapse" href="#"></a>' +
					'<span class="caret">&nbsp;</span>' +
					"</h4>" +
					"</div>" +
					'<div class="panel-collapse collapse">' +
					'<div class="panel-body"></div>' +
					"</div>" +
					"</div>",

				data: function () {
					var link = this.element.findOne(".collapsed");
					var collapse = this.element.findOne(".panel-collapse");

					link.setText(this.data.title);
					link.setAttribute(
						"href",
						this.data.id ? "#WIKI_" + $("#selected_pdService").val() + "_" + this.data.id : "#"
					);
					collapse.setAttribute(
						"id",
						this.data.id ? "WIKI_" + $("#selected_pdService").val() + "_" + this.data.id : ""
					);
				}
			});

			editor.ui.addButton("accordion", {
				label: "Include Page",
				command: "open.accordion.dialog",
				toolbar: "basicstyles,1"
			});
		}
	});

	CKEDITOR.ACCORDION = "accordion";
})();
