Bridge.assembly("OrgChart.Layout",function($asm){"use strict";Bridge.define("OrgChart.Annotations.CanBeNullAttribute",{inherits:[System.Attribute]});Bridge.define("OrgChart.Annotations.ContractAnnotationAttribute",{inherits:[System.Attribute],config:{properties:{Contract:null,ForceFullStates:!1}},ctor:function(contract){OrgChart.Annotations.ContractAnnotationAttribute.$ctor1.call(this,contract,!1)},$ctor1:function(contract,forceFullStates){this.$initialize();System.Attribute.ctor.call(this);this.setContract(contract);this.setForceFullStates(forceFullStates)}});Bridge.define("OrgChart.Annotations.NotNullAttribute",{inherits:[System.Attribute]});Bridge.define("OrgChart.Annotations.PureAttribute",{inherits:[System.Attribute]});Bridge.define("OrgChart.Layout.Boundary",{Left:null,Right:null,m_spacerMerger:null,config:{properties:{BoundingRect:null},init:function(){this.BoundingRect=new OrgChart.Layout.Rect}},ctor:function(){OrgChart.Layout.Boundary.$ctor1.call(this,!0)},$ctor1:function(frompublic){this.$initialize();this.Left=new(System.Collections.Generic.List$1(OrgChart.Layout.Boundary.Step));this.Right=new(System.Collections.Generic.List$1(OrgChart.Layout.Boundary.Step));frompublic&&(this.m_spacerMerger=new OrgChart.Layout.Boundary.$ctor1(!1))},PrepareForHorizontalLayout:function(node){if(this.Prepare(node),!node.getElement().DisableCollisionDetection){var rect=node.getState();this.Left.add(new OrgChart.Layout.Boundary.Step.$ctor1(node,rect.getLeft(),rect.getTop(),rect.getBottom()));this.Right.add(new OrgChart.Layout.Boundary.Step.$ctor1(node,rect.getRight(),rect.getTop(),rect.getBottom()))}},Prepare:function(node){this.Left.clear();this.Right.clear();this.setBoundingRect(new OrgChart.Layout.Rect.$ctor1(node.getState().TopLeft,node.getState().Size))},VerticalMergeFrom:function(other){this.setBoundingRect(OrgChart.Layout.Rect.op_Addition(this.getBoundingRect(),other.getBoundingRect()))},MergeFrom:function(other){var merge,my,th,theirWins;if(other.getBoundingRect().getTop()>=other.getBoundingRect().getBottom())throw new System.ArgumentException("Cannot merge boundary of height "+System.Double.format(other.getBoundingRect().getBottom()-other.getBoundingRect().getTop(),"G"));for(merge=114;merge!==0;){for(var mySteps=merge===114?this.Right:this.Left,theirSteps=merge===114?other.Right:other.Left,i=0,k=0;k<theirSteps.getCount()&&i<mySteps.getCount();){if(my=mySteps.getItem(i),th=theirSteps.getItem(k),my.Bottom<=th.Top){i=i+1|0;continue}if(th.Bottom<=my.Top){mySteps.insert(i,th);k=k+1|0;this.ValidateState();continue}theirWins=merge===114?my.X<=th.X:my.X>=th.X;OrgChart.Layout.LayoutAlgorithm.IsEqual(my.Top,th.Top)?OrgChart.Layout.LayoutAlgorithm.IsEqual(my.Bottom,th.Bottom)?(theirWins&&mySteps.setItem(i,th),i=i+1|0,k=k+1|0,this.ValidateState()):my.Bottom<th.Bottom?(theirWins&&mySteps.setItem(i,my.ChangeOwner(th.Node,th.X)),theirSteps.setItem(k,th.ChangeTop(my.Bottom)),i=i+1|0,this.ValidateState()):(theirWins&&(mySteps.setItem(i,my.ChangeTop(th.Bottom)),mySteps.insert(i,th),i=i+1|0),k=k+1|0,this.ValidateState()):OrgChart.Layout.LayoutAlgorithm.IsEqual(my.Bottom,th.Bottom)?my.Top<th.Top?(theirWins&&(mySteps.setItem(i,my.ChangeBottom(th.Top)),mySteps.insert(i+1|0,th),i=i+1|0),i=i+1|0,k=k+1|0,this.ValidateState()):(theirWins?mySteps.setItem(i,th):(mySteps.insert(i,th.ChangeBottom(my.Top)),i=i+1|0),i=i+1|0,k=k+1|0,this.ValidateState()):my.Top<th.Top&&my.Bottom<th.Bottom?(theirWins&&(mySteps.setItem(i,my.ChangeBottom(th.Top)),mySteps.insert(i+1|0,new OrgChart.Layout.Boundary.Step.$ctor1(th.Node,th.X,th.Top,my.Bottom)),i=i+1|0),theirSteps.setItem(k,th.ChangeTop(my.Bottom)),i=i+1|0,this.ValidateState()):my.Top<th.Top&&my.Bottom>th.Bottom?(theirWins&&(mySteps.setItem(i,my.ChangeBottom(th.Top)),mySteps.insert(i+1|0,th),mySteps.insert(i+2|0,my.ChangeTop(th.Bottom)),i=i+2|0),k=k+1|0,this.ValidateState()):my.Bottom>th.Bottom?(theirWins?(mySteps.setItem(i,my.ChangeTop(th.Bottom)),mySteps.insert(i,th)):mySteps.insert(i,th.ChangeBottom(my.Top)),i=i+1|0,k=k+1|0,this.ValidateState()):(theirWins?mySteps.setItem(i,th.ChangeBottom(my.Bottom)):(mySteps.insert(i,th.ChangeBottom(my.Top)),i=i+1|0),theirSteps.setItem(k,th.ChangeTop(my.Bottom)),i=i+1|0,this.ValidateState())}if(i===mySteps.getCount())while(k<theirSteps.getCount())mySteps.add(theirSteps.getItem(k)),k=k+1|0,this.ValidateState();merge=merge===114?108:0}this.setBoundingRect(OrgChart.Layout.Rect.op_Addition(this.getBoundingRect(),other.getBoundingRect()))},MergeFrom$1:function(node){node.getElement().DisableCollisionDetection||OrgChart.Layout.LayoutAlgorithm.IsZero(node.getState().Size.Height)||(this.m_spacerMerger.PrepareForHorizontalLayout(node),this.MergeFrom(this.m_spacerMerger))},ValidateState:function(){for(var i1,i=1;i<this.Left.getCount();i=i+1|0)if(OrgChart.Layout.LayoutAlgorithm.IsEqual(this.Left.getItem(i).Top,this.Left.getItem(i).Bottom)||this.Left.getItem(i).Top<this.Left.getItem(i-1|0).Bottom||this.Left.getItem(i).Top<=this.Left.getItem(i-1|0).Top||this.Left.getItem(i).Bottom<=this.Left.getItem(i).Top||this.Left.getItem(i).Bottom<=this.Left.getItem(i-1|0).Bottom)throw new System.Exception("State error at Left index "+i);for(i1=1;i1<this.Right.getCount();i1=i1+1|0)if(OrgChart.Layout.LayoutAlgorithm.IsEqual(this.Right.getItem(i1).Top,this.Right.getItem(i1).Bottom)||this.Right.getItem(i1).Top<this.Right.getItem(i1-1|0).Bottom||this.Right.getItem(i1).Top<=this.Right.getItem(i1-1|0).Top||this.Right.getItem(i1).Bottom<=this.Right.getItem(i1).Top||this.Right.getItem(i1).Bottom<=this.Right.getItem(i1-1|0).Bottom)throw new System.Exception("State error at Right index "+i1);},ComputeOverlap:function(other,siblingSpacing,branchSpacing){for(var i=0,k=0,offense=0,my,th,desiredSpacing,diff;i<this.Right.getCount()&&k<other.Left.getCount();)my=this.Right.getItem(i),th=other.Left.getItem(k),my.Bottom<=th.Top?i=i+1|0:th.Bottom<=my.Top?k=k+1|0:(my.Node.getElement().DisableCollisionDetection||th.Node.getElement().DisableCollisionDetection||(desiredSpacing=my.Node.getElement().IsSpecial||th.Node.getElement().IsSpecial?0:my.Node.getElement().ParentId===th.Node.getElement().ParentId?siblingSpacing:branchSpacing,diff=my.X+desiredSpacing-th.X,diff>offense&&(offense=diff)),my.Bottom>=th.Bottom&&(k=k+1|0),th.Bottom>=my.Bottom&&(i=i+1|0));return offense},ReloadFromBranch:function(branchRoot){for(var left,newLeft,i1,right,newRight,leftmost=System.Double.max,rightmost=System.Double.min,i=0;i<this.Left.getCount();i=i+1|0)left=this.Left.getItem(i),newLeft=left.Node.getState().getLeft(),this.Left.setItem(i,left.ChangeX(newLeft)),leftmost=Math.min(leftmost,newLeft);for(i1=0;i1<this.Right.getCount();i1=i1+1|0)right=this.Right.getItem(i1),newRight=right.Node.getState().getRight(),this.Right.setItem(i1,right.ChangeX(newRight)),rightmost=Math.max(rightmost,newRight);leftmost=Math.min(branchRoot.getState().getLeft(),leftmost);rightmost=Math.max(branchRoot.getState().getRight(),rightmost);this.setBoundingRect(new OrgChart.Layout.Rect.$ctor1(new OrgChart.Layout.Point.$ctor1(leftmost,this.getBoundingRect().getTop()),new OrgChart.Layout.Size.$ctor1(rightmost-leftmost,this.getBoundingRect().Size.Height)))}});Bridge.define("OrgChart.Layout.Boundary.Step",{$kind:"struct",statics:{getDefaultValue:function(){return new OrgChart.Layout.Boundary.Step}},Node:null,X:0,Top:0,Bottom:0,$ctor1:function(node,x,top,bottom){this.$initialize();this.Node=node;this.X=x;this.Top=top;this.Bottom=bottom},ctor:function(){this.$initialize()},ChangeTop:function(newTop){return new OrgChart.Layout.Boundary.Step.$ctor1(this.Node,this.X,newTop,this.Bottom)},ChangeBottom:function(newBottom){return new OrgChart.Layout.Boundary.Step.$ctor1(this.Node,this.X,this.Top,newBottom)},ChangeOwner:function(newNode,newX){return new OrgChart.Layout.Boundary.Step.$ctor1(newNode,newX,this.Top,this.Bottom)},ChangeX:function(newX){return new OrgChart.Layout.Boundary.Step.$ctor1(this.Node,newX,this.Top,this.Bottom)},getHashCode:function(){return Bridge.addHash([1885697107,this.Node,this.X,this.Top,this.Bottom])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Boundary.Step)?Bridge.equals(this.Node,o.Node)&&Bridge.equals(this.X,o.X)&&Bridge.equals(this.Top,o.Top)&&Bridge.equals(this.Bottom,o.Bottom):!1},$clone:function(to){var s=to||new OrgChart.Layout.Boundary.Step;return s.Node=this.Node,s.X=this.X,s.Top=this.Top,s.Bottom=this.Bottom,s}});Bridge.define("OrgChart.Layout.BoundaryChangedEventArgs",{State:null,LayoutLevel:null,Boundary:null,ctor:function(boundary,layoutLevel,state){this.$initialize();this.Boundary=boundary;this.LayoutLevel=layoutLevel;this.State=state}});Bridge.define("OrgChart.Layout.Box",{statics:{None:-1,Special:function(id,visualParentId,disableCollisionDetection){return new OrgChart.Layout.Box.$ctor1(null,id,visualParentId,!0,disableCollisionDetection,!1)}},Id:0,ParentId:0,DataId:null,IsSpecial:!1,IsAssistant:!1,DisableCollisionDetection:!1,LayoutStrategyId:null,AssistantLayoutStrategyId:null,IsCollapsed:!1,config:{init:function(){this.Size=new OrgChart.Layout.Size}},ctor:function(dataId,id,parentId,isAssistant){OrgChart.Layout.Box.$ctor1.call(this,dataId,id,parentId,!1,!1,isAssistant)},$ctor1:function(dataId,id,parentId,isSpecial,disableCollisionDetection,isAssistant){if(this.$initialize(),id===0)throw new System.ArgumentOutOfRangeException("id");this.Id=id;this.ParentId=parentId;this.DataId=dataId;this.IsSpecial=isSpecial;this.IsAssistant=isAssistant;this.DisableCollisionDetection=disableCollisionDetection},getIsDataBound:function(){return!System.String.isNullOrEmpty(this.DataId)}});Bridge.define("OrgChart.Layout.BoxContainer",{m_lastBoxId:0,m_boxesById:null,m_boxesByDataId:null,config:{properties:{SystemRoot:null},init:function(){this.m_boxesById=new(System.Collections.Generic.Dictionary$2(System.Int32,OrgChart.Layout.Box));this.m_boxesByDataId=new(System.Collections.Generic.Dictionary$2(String,OrgChart.Layout.Box))}},ctor:function(){this.$initialize()},$ctor1:function(source){this.$initialize();this.ReloadBoxes(source)},getBoxesById:function(){return this.m_boxesById},getBoxesByDataId:function(){return this.m_boxesByDataId},ReloadBoxes:function(source){var $t,$t1,map,dataId,getDataItem;for(this.m_boxesByDataId.clear(),this.m_boxesById.clear(),this.m_lastBoxId=0,this.setSystemRoot(OrgChart.Layout.Box.Special(this.m_lastBoxId=this.m_lastBoxId+1|0,OrgChart.Layout.Box.None,!0)),this.m_boxesById.add(this.getSystemRoot().Id,this.getSystemRoot()),map=new(System.Collections.Generic.Dictionary$2(String,System.Int32)),$t=Bridge.getEnumerator(source.OrgChart$Layout$IChartDataSource$getAllDataItemIds(),String);$t.moveNext();)dataId=$t.getCurrent(),map.add(dataId,this.NextBoxId());for(getDataItem=source.OrgChart$Layout$IChartDataSource$getGetDataItemFunc(),$t1=Bridge.getEnumerator(source.OrgChart$Layout$IChartDataSource$getAllDataItemIds(),String);$t1.moveNext();){var dataId1=$t1.getCurrent(),parentDataId=System.String.isNullOrEmpty(dataId1)?null:source.OrgChart$Layout$IChartDataSource$getGetParentKeyFunc()(dataId1),visualParentId=System.String.isNullOrEmpty(parentDataId)?this.getSystemRoot().Id:map.get(parentDataId);this.AddBox$1(dataId1,map.get(dataId1),visualParentId,getDataItem(dataId1).OrgChart$Layout$IChartDataItem$getIsAssistant())}},AddBox:function(dataId,visualParentId,isAssistant){return this.AddBox$1(dataId,this.NextBoxId(),visualParentId,isAssistant)},AddBox$1:function(dataId,id,visualParentId,isAssistant){var box=new OrgChart.Layout.Box.ctor(dataId,id,visualParentId,isAssistant);return this.m_boxesById.add(box.Id,box),System.String.isNullOrEmpty(dataId)||this.m_boxesByDataId.add(box.DataId,box),box},NextBoxId:function(){return this.m_lastBoxId=this.m_lastBoxId+1|0,this.m_lastBoxId}});Bridge.define("OrgChart.Layout.BoxTree",{statics:{Build:function(state){for(var $t1,result=new OrgChart.Layout.BoxTree,box,node,$t=Bridge.getEnumerator(state.getDiagram().getBoxes().getBoxesById().System$Collections$Generic$IDictionary$2$System$Int32$OrgChart$Layout$Box$getValues(),OrgChart.Layout.Box);$t.moveNext();)box=$t.getCurrent(),node=new OrgChart.Layout.BoxTree.Node(box),result.getNodes().add(box.Id,node);for($t1=Bridge.getEnumerator(result.getNodes().getValues(),OrgChart.Layout.BoxTree.Node);$t1.moveNext();){var node1=$t1.getCurrent(),parentKey=node1.getElement().ParentId,parentNode={};if(result.getNodes().tryGetValue(parentKey,parentNode))node1.getElement().IsAssistant&&parentNode.v.getElement().ParentId!==OrgChart.Layout.Box.None?parentNode.v.AddAssistantChild(node1):parentNode.v.AddRegularChild$1(node1);else{if(result.getRoot()!=null)throw new System.InvalidOperationException("More then one root found: "+node1.getElement().Id);result.setRoot(node1)}}return result}},config:{properties:{Root:null,Nodes:null,Depth:0}},ctor:function(){this.$initialize();this.setNodes(new(System.Collections.Generic.Dictionary$2(System.Int32,OrgChart.Layout.BoxTree.Node)))},IterateChildFirst:function(func){return this.getRoot().IterateChildFirst(func)},IterateParentFirst:function(enter,exit){exit===void 0&&(exit=null);this.getRoot().IterateParentFirst(enter,exit)},UpdateHierarchyStats:function(){this.setDepth(0);this.IterateParentFirst(Bridge.fn.bind(this,$asm.$.OrgChart.Layout.BoxTree.f1))}});Bridge.ns("OrgChart.Layout.BoxTree",$asm.$);Bridge.apply($asm.$.OrgChart.Layout.BoxTree,{f1:function(x){return x.getParentNode()!=null?(x.setLevel(x.getParentNode().getLevel()),x.getParentNode().getIsAssistantRoot()||x.setLevel(x.getLevel()+1|0),this.setDepth(Math.max(1+x.getLevel()|0,this.getDepth()))):(x.setLevel(0),this.setDepth(1)),!0}});Bridge.define("OrgChart.Layout.BoxTree.Node",{config:{properties:{Level:0,Element:null,State:null,ParentNode:null,Children:null,AssistantsRoot:null}},ctor:function(element){this.$initialize();this.setElement(element);this.setState(new OrgChart.Layout.NodeLayoutInfo)},getChildCount:function(){return this.getChildren()==null?0:System.Array.getCount(this.getChildren(),OrgChart.Layout.BoxTree.Node)},getIsAssistantRoot:function(){var $t;return Bridge.referenceEquals(($t=this.getParentNode())!=null?$t.getAssistantsRoot():null,this)},AddAssistantChild:function(child){return this.getAssistantsRoot()==null&&this.setAssistantsRoot(Bridge.merge(new OrgChart.Layout.BoxTree.Node(OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,this.getElement().Id,!0)),{setParentNode:this,setLevel:this.getLevel()+1|0})),this.getAssistantsRoot().AddRegularChild$1(child),this},AddRegularChild$1:function(child){return this.InsertRegularChild$1(this.getChildCount(),child)},AddRegularChild:function(child){return this.InsertRegularChild(this.getChildCount(),child)},InsertRegularChild:function(index,child){return this.InsertRegularChild$1(index,new OrgChart.Layout.BoxTree.Node(child))},InsertRegularChild$1:function(index,child){return this.getChildren()==null&&this.setChildren(new(System.Collections.Generic.List$1(OrgChart.Layout.BoxTree.Node))),System.Array.insert(this.getChildren(),index,child,OrgChart.Layout.BoxTree.Node),child.setParentNode(this),child.setLevel(this.getLevel()+1|0),this},IterateChildFirst:function(func){var $t,child;if(this.getAssistantsRoot()!=null&&!this.getAssistantsRoot().IterateChildFirst(func))return!1;if(this.getChildren()!=null)for($t=Bridge.getEnumerator(this.getChildren(),OrgChart.Layout.BoxTree.Node);$t.moveNext();)if(child=$t.getCurrent(),!child.IterateChildFirst(func))return!1;return func(this)},IterateParentFirst:function(enter,exit){var $t,$t1,child;if(exit===void 0&&(exit=null),!enter(this))return Bridge.staticEquals(exit,null)?null:exit(this),!1;if(($t=this.getAssistantsRoot())!=null?$t.IterateParentFirst(enter,exit):null,this.getChildren()!=null)for($t1=Bridge.getEnumerator(this.getChildren(),OrgChart.Layout.BoxTree.Node);$t1.moveNext();)child=$t1.getCurrent(),child.IterateParentFirst(enter,exit);return Bridge.staticEquals(exit,null)?null:exit(this),!0},SuppressAssistants:function(){var $t,child;if(this.getAssistantsRoot()!=null){for($t=Bridge.getEnumerator(this.getAssistantsRoot().getChildren(),OrgChart.Layout.BoxTree.Node);$t.moveNext();)child=$t.getCurrent(),this.AddRegularChild$1(child);this.setAssistantsRoot(null)}}});Bridge.define("OrgChart.Layout.BranchParentAlignment",{$kind:"enum",statics:{InvalidValue:0,Left:1,Center:2,Right:3}});Bridge.define("OrgChart.Layout.Connector",{config:{properties:{Segments:null}},ctor:function(segments){if(this.$initialize(),segments.length===0)throw new System.ArgumentException("Need at least one segment","segments");this.setSegments(segments)}});Bridge.define("OrgChart.Layout.Diagram",{m_visualTree:null,m_boxes:null,config:{properties:{LayoutSettings:null}},ctor:function(){this.$initialize();this.setLayoutSettings(new OrgChart.Layout.DiagramLayoutSettings)},getBoxes:function(){return this.m_boxes},setBoxes:function(value){this.m_visualTree=null;this.m_boxes=value},getVisualTree:function(){return this.m_visualTree},setVisualTree:function(value){this.m_visualTree=value}});Bridge.define("OrgChart.Layout.DiagramLayoutSettings",{m_branchSpacing:0,config:{properties:{LayoutStrategies:null,DefaultAssistantLayoutStrategyId:null,DefaultLayoutStrategyId:null}},ctor:function(){this.$initialize();this.setBranchSpacing(50);this.setLayoutStrategies(new(System.Collections.Generic.Dictionary$2(String,OrgChart.Layout.LayoutStrategyBase)))},getBranchSpacing:function(){return this.m_branchSpacing},setBranchSpacing:function(value){if(value<0)throw new System.ArgumentOutOfRangeException("value","Cannot be negative",null,value);this.m_branchSpacing=value},RequireDefaultLayoutStrategy:function(){var result={};if(System.String.isNullOrEmpty(this.getDefaultLayoutStrategyId())||!this.getLayoutStrategies().tryGetValue(this.getDefaultLayoutStrategyId(),result))throw new System.InvalidOperationException("defaultLayoutStrategyId is null or not valid");return result.v},RequireDefaultAssistantLayoutStrategy:function(){var result={};if(System.String.isNullOrEmpty(this.getDefaultAssistantLayoutStrategyId())||!this.getLayoutStrategies().tryGetValue(this.getDefaultAssistantLayoutStrategyId(),result))throw new System.InvalidOperationException("defaultAssistantLayoutStrategyId is null or not valid");return result.v}});Bridge.define("OrgChart.Layout.DiagramLayoutTemplates");Bridge.define("OrgChart.Layout.Dimensions",{$kind:"struct",statics:{MinMax:function(){return new OrgChart.Layout.Dimensions.$ctor1(System.Double.max,System.Double.min)},op_Addition:function(x,y){return new OrgChart.Layout.Dimensions.$ctor1(Math.min(x.From,y.From),Math.max(x.To,y.To))},getDefaultValue:function(){return new OrgChart.Layout.Dimensions}},From:0,To:0,$ctor1:function(from,to){this.$initialize();this.From=from;this.To=to},ctor:function(){this.$initialize()},getHashCode:function(){return Bridge.addHash([3570880544,this.From,this.To])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Dimensions)?Bridge.equals(this.From,o.From)&&Bridge.equals(this.To,o.To):!1},$clone:function(to){var s=to||new OrgChart.Layout.Dimensions;return s.From=this.From,s.To=this.To,s}});Bridge.define("OrgChart.Layout.Edge",{$kind:"struct",statics:{getDefaultValue:function(){return new OrgChart.Layout.Edge}},config:{init:function(){this.From=new OrgChart.Layout.Point;this.To=new OrgChart.Layout.Point}},$ctor1:function(from,to){this.$initialize();this.From=from;this.To=to},ctor:function(){this.$initialize()},getHashCode:function(){return Bridge.addHash([1701274693,this.From,this.To])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Edge)?Bridge.equals(this.From,o.From)&&Bridge.equals(this.To,o.To):!1},$clone:function(to){var s=to||new OrgChart.Layout.Edge;return s.From=this.From,s.To=this.To,s}});Bridge.define("OrgChart.Layout.LayoutStrategyBase",{ParentAlignment:0,ParentChildSpacing:20,ParentConnectorShield:50,SiblingSpacing:20,ChildConnectorHookLength:5});Bridge.define("OrgChart.Layout.Frame1",{Connector:null,config:{init:function(){this.Exterior=new OrgChart.Layout.Rect;this.BranchExterior=new OrgChart.Layout.Rect;this.SiblingsRowV=new OrgChart.Layout.Dimensions}}});Bridge.define("OrgChart.Layout.IChartDataItem",{$kind:"interface"});Bridge.define("OrgChart.Layout.IChartDataSource",{$kind:"interface"});Bridge.define("OrgChart.Layout.LayoutAlgorithm",{statics:{ComputeBranchVisualBoundingRect:function(visualTree){var result=new OrgChart.Layout.Rect.ctor,initialized=!1;return visualTree.getRoot().IterateParentFirst(function(node){var box=node.getElement();return node.getState().IsHidden||box.IsSpecial||(initialized?result=OrgChart.Layout.Rect.op_Addition(result,new OrgChart.Layout.Rect.$ctor1(node.getState().TopLeft,node.getState().Size)):(initialized=!0,result=new OrgChart.Layout.Rect.$ctor1(node.getState().TopLeft,node.getState().Size))),!box.IsCollapsed}),result},Apply:function(state){var $t,$t1,tree,box,box1;if(state.getDiagram().getBoxes().getSystemRoot()==null)throw new System.InvalidOperationException("SystemRoot is not initialized on the box container");if(state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.Preparing),tree=OrgChart.Layout.BoxTree.Build(state),state.getDiagram().setVisualTree(tree),tree.getRoot()==null||tree.getRoot().getElement().Id!==state.getDiagram().getBoxes().getSystemRoot().Id)throw new System.Exception("SystemRoot is not on the top of the visual tree");if(tree.UpdateHierarchyStats(),state.AttachVisualTree(tree),tree.IterateParentFirst($asm.$.OrgChart.Layout.LayoutAlgorithm.f1),state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.PreprocessVisualTree),!Bridge.staticEquals(state.getBoxSizeFunc(),null))for($t=Bridge.getEnumerator(System.Linq.Enumerable.from(state.getDiagram().getBoxes().getBoxesById().System$Collections$Generic$IDictionary$2$System$Int32$OrgChart$Layout$Box$getValues()).where($asm.$.OrgChart.Layout.LayoutAlgorithm.f2));$t.moveNext();)box=$t.getCurrent(),box.Size=state.getBoxSizeFunc()(box.DataId);for($t1=Bridge.getEnumerator(state.getDiagram().getBoxes().getBoxesById().System$Collections$Generic$IDictionary$2$System$Int32$OrgChart$Layout$Box$getValues(),OrgChart.Layout.Box);$t1.moveNext();)box1=$t1.getCurrent(),OrgChart.Layout.LayoutAlgorithm.AssertBoxSize(box1);tree.IterateParentFirst($asm.$.OrgChart.Layout.LayoutAlgorithm.f3);OrgChart.Layout.LayoutAlgorithm.PreprocessVisualTree(state,tree);tree.UpdateHierarchyStats();state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.VerticalLayout);OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,tree.getRoot());state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.HorizontalLayout);OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,tree.getRoot());state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.ConnectorsLayout);OrgChart.Layout.LayoutAlgorithm.RouteConnectors(state,tree);state.setCurrentOperation(OrgChart.Layout.LayoutState.Operation.Completed)},AssertBoxSize:function(box){if(!(box.Size.Width>=0)||!(box.Size.Width<=1e9)||!(box.Size.Height>=0)||!(box.Size.Width<=1e9))throw new System.InvalidOperationException(System.String.format("Box {0} has invalid size: {1}x{2}",box.Id,box.Size.Width,box.Size.Height));},PreprocessVisualTree:function(state,visualTree){var defaultStrategy=state.getDiagram().getLayoutSettings().RequireDefaultLayoutStrategy(),defaultAssistantsStrategy=state.getDiagram().getLayoutSettings().RequireDefaultAssistantLayoutStrategy(),regular=new(System.Collections.Generic.Stack$1(OrgChart.Layout.LayoutStrategyBase).ctor),assistants;regular.push(defaultStrategy);assistants=new(System.Collections.Generic.Stack$1(OrgChart.Layout.LayoutStrategyBase).ctor);assistants.push(defaultAssistantsStrategy);visualTree.IterateParentFirst(function(node){var strategy,suggestedStrategyId;return node.getState().IsHidden?!1:(strategy=null,Bridge.staticEquals(state.getLayoutOptimizerFunc(),null)||(suggestedStrategyId=state.getLayoutOptimizerFunc()(node),System.String.isNullOrEmpty(suggestedStrategyId)||(strategy=state.getDiagram().getLayoutSettings().getLayoutStrategies().get(suggestedStrategyId))),node.getIsAssistantRoot()?(strategy==null&&(strategy=node.getParentNode().getElement().AssistantLayoutStrategyId!=null?state.getDiagram().getLayoutSettings().getLayoutStrategies().get(node.getParentNode().getElement().AssistantLayoutStrategyId):assistants.peek()),assistants.push(strategy)):(strategy==null&&(strategy=node.getElement().LayoutStrategyId!=null?state.getDiagram().getLayoutSettings().getLayoutStrategies().get(node.getElement().LayoutStrategyId):regular.peek()),regular.push(strategy),strategy.getSupportsAssistants()||node.SuppressAssistants()),node.getState().setEffectiveLayoutStrategy(strategy),node.getState().RequireLayoutStrategy().PreProcessThisNode(state,node),!node.getElement().IsCollapsed&&node.getChildCount()>0||node.getAssistantsRoot()!=null)},function(node){node.getState().IsHidden||(node.getIsAssistantRoot()?assistants.pop():regular.pop())})},HorizontalLayout:function(state,branchRoot){if(branchRoot.getState().IsHidden)throw new System.InvalidOperationException(System.String.format("Branch root {0} does not affect layout",branchRoot.getElement().Id));var level=state.PushLayoutLevel(branchRoot);try{(branchRoot.getLevel()===0||(branchRoot.getState().NumberOfSiblings>0||branchRoot.getAssistantsRoot()!=null)&&!branchRoot.getElement().IsCollapsed)&&branchRoot.getState().RequireLayoutStrategy().ApplyHorizontalLayout(state,level)}finally{state.PopLayoutLevel()}},VerticalLayout:function(state,branchRoot){if(branchRoot.getState().IsHidden)throw new System.InvalidOperationException(System.String.format("Branch root {0} does not affect layout",branchRoot.getElement().Id));var level=state.PushLayoutLevel(branchRoot);try{(branchRoot.getLevel()===0||(branchRoot.getState().NumberOfSiblings>0||branchRoot.getAssistantsRoot()!=null)&&!branchRoot.getElement().IsCollapsed)&&branchRoot.getState().RequireLayoutStrategy().ApplyVerticalLayout(state,level)}finally{state.PopLayoutLevel()}},RouteConnectors:function(state,visualTree){visualTree.IterateParentFirst(function(node){return node.getElement().IsCollapsed||node.getState().NumberOfSiblings===0&&node.getAssistantsRoot()==null?!1:node.getLevel()===0?!0:!node.getElement().IsSpecial||node.getIsAssistantRoot()?(node.getState().RequireLayoutStrategy().RouteConnectors(state,node),!0):!1})},MoveChildrenOnly:function(state,layoutLevel,offset){var $t,children=layoutLevel.BranchRoot.getChildren(),action,child;if(children==null||System.Array.getCount(children,OrgChart.Layout.BoxTree.Node)===0)throw new System.InvalidOperationException("Should never be invoked when children not set");for(action=function(node){return node.getState().IsHidden||(node.getState().TopLeft=node.getState().TopLeft.MoveH(offset),node.getState().BranchExterior=node.getState().BranchExterior.MoveH(offset)),!0},$t=Bridge.getEnumerator(children,OrgChart.Layout.BoxTree.Node);$t.moveNext();)child=$t.getCurrent(),child.IterateChildFirst(action);layoutLevel.Boundary.ReloadFromBranch(layoutLevel.BranchRoot);layoutLevel.BranchRoot.getState().BranchExterior=layoutLevel.Boundary.getBoundingRect()},MoveOneChild:function(state,root,offset){root.IterateChildFirst(function(node){return node.getState().IsHidden||(node.getState().TopLeft=node.getState().TopLeft.MoveH(offset),node.getState().BranchExterior=node.getState().BranchExterior.MoveH(offset)),!0})},MoveBranch:function(state,layoutLevel,offset){OrgChart.Layout.LayoutAlgorithm.MoveOneChild(state,layoutLevel.BranchRoot,offset);layoutLevel.Boundary.ReloadFromBranch(layoutLevel.BranchRoot);layoutLevel.BranchRoot.getState().BranchExterior=layoutLevel.Boundary.getBoundingRect()},AlignHorizontalCenters:function(state,level,subset){for(var $t1,center=System.Double.min,child,c,leftmost,rightmost,diff,$t=Bridge.getEnumerator(subset,OrgChart.Layout.BoxTree.Node);$t.moveNext();)child=$t.getCurrent(),c=child.getState().getCenterH(),c>center&&(center=c);for(leftmost=System.Double.max,rightmost=System.Double.min,$t1=Bridge.getEnumerator(subset,OrgChart.Layout.BoxTree.Node);$t1.moveNext();){var child1=$t1.getCurrent(),frame=child1.getState(),c1=frame.getCenterH();OrgChart.Layout.LayoutAlgorithm.IsEqual(c1,center)||(diff=center-c1,OrgChart.Layout.LayoutAlgorithm.MoveOneChild(state,child1,diff));leftmost=Math.min(leftmost,child1.getState().BranchExterior.getLeft());rightmost=Math.max(rightmost,child1.getState().BranchExterior.getRight())}return level.Boundary.ReloadFromBranch(level.BranchRoot),new OrgChart.Layout.Dimensions.$ctor1(leftmost,rightmost)},CopyExteriorFrom:function(state,other){state.TopLeft=other.TopLeft;state.Size=other.Size;state.BranchExterior=other.BranchExterior;state.SiblingsRowV=other.SiblingsRowV},IsMinValue:function(value){return value<=System.Double.min+494065645841247e-338},IsMaxValue:function(value){return value>=System.Double.max-494065645841247e-338},IsZero:function(value){return value<=494065645841247e-338&&value>=-494065645841247e-338},IsEqual:function(value,other){return Math.abs(value-other)<=494065645841247e-338},MoveTo:function(state,x,y){state.TopLeft=new OrgChart.Layout.Point.$ctor1(x,y)},AdjustSpacer:function(state,x,y,w,h){state.TopLeft=new OrgChart.Layout.Point.$ctor1(x,y);state.Size=new OrgChart.Layout.Size.$ctor1(w,h);state.BranchExterior=new OrgChart.Layout.Rect.$ctor3(x,y,w,h)}}});Bridge.ns("OrgChart.Layout.LayoutAlgorithm",$asm.$);Bridge.apply($asm.$.OrgChart.Layout.LayoutAlgorithm,{f1:function(node){return node.getState().IsHidden=node.getParentNode()!=null&&(node.getParentNode().getState().IsHidden||node.getParentNode().getElement().IsCollapsed),!0},f2:function(x){return x.getIsDataBound()},f3:function(node){return OrgChart.Layout.LayoutAlgorithm.MoveTo(node.getState(),0,0),node.getState().Size=node.getElement().Size,node.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(new OrgChart.Layout.Point.$ctor1(0,0),node.getElement().Size),!0}});Bridge.define("OrgChart.Layout.LayoutState",{m_layoutStack:null,m_pooledBoundaries:null,m_currentOperation:0,config:{events:{BoundaryChanged:null,OperationChanged:null},properties:{Diagram:null,BoxSizeFunc:null,LayoutOptimizerFunc:null},init:function(){this.m_layoutStack=new(System.Collections.Generic.Stack$1(OrgChart.Layout.LayoutState.LayoutLevel).ctor);this.m_pooledBoundaries=new(System.Collections.Generic.Stack$1(OrgChart.Layout.Boundary).ctor)}},ctor:function(diagram){this.$initialize();this.setDiagram(diagram)},getCurrentOperation:function(){return this.m_currentOperation},setCurrentOperation:function(value){this.m_currentOperation=value;Bridge.staticEquals(this.OperationChanged,null)?null:this.OperationChanged(this,new OrgChart.Layout.LayoutStateOperationChangedEventArgs(this))},AttachVisualTree:function(tree){while(this.m_pooledBoundaries.getCount()<tree.getDepth())this.m_pooledBoundaries.push(new OrgChart.Layout.Boundary.ctor)},PushLayoutLevel:function(node){var boundary,result;this.m_pooledBoundaries.getCount()===0&&this.m_pooledBoundaries.push(new OrgChart.Layout.Boundary.ctor);boundary=this.m_pooledBoundaries.pop();switch(this.getCurrentOperation()){case OrgChart.Layout.LayoutState.Operation.VerticalLayout:boundary.Prepare(node);break;case OrgChart.Layout.LayoutState.Operation.HorizontalLayout:boundary.PrepareForHorizontalLayout(node);break;default:throw new System.InvalidOperationException("This operation can only be invoked when performing vertical or horizontal layouts");}return result=new OrgChart.Layout.LayoutState.LayoutLevel(node,boundary),this.m_layoutStack.push(result),Bridge.staticEquals(this.BoundaryChanged,null)?null:this.BoundaryChanged(this,new OrgChart.Layout.BoundaryChangedEventArgs(boundary,result,this)),result},MergeSpacer:function(spacer){if(this.getCurrentOperation()!==OrgChart.Layout.LayoutState.Operation.HorizontalLayout)throw new System.InvalidOperationException("Spacers can only be merged during horizontal layout");if(this.m_layoutStack.getCount()===0)throw new System.InvalidOperationException("Cannot merge spacers at top nesting level");var level=this.m_layoutStack.peek();level.Boundary.MergeFrom$1(spacer);Bridge.staticEquals(this.BoundaryChanged,null)?null:this.BoundaryChanged(this,new OrgChart.Layout.BoundaryChangedEventArgs(level.Boundary,level,this))},PopLayoutLevel:function(){var innerLevel=this.m_layoutStack.pop(),higherLevel,strategy,overlap;if(Bridge.staticEquals(this.BoundaryChanged,null)?null:this.BoundaryChanged(this,new OrgChart.Layout.BoundaryChangedEventArgs(innerLevel.Boundary,innerLevel,this)),this.m_layoutStack.getCount()>0){higherLevel=this.m_layoutStack.peek();switch(this.getCurrentOperation()){case OrgChart.Layout.LayoutState.Operation.VerticalLayout:higherLevel.Boundary.VerticalMergeFrom(innerLevel.Boundary);higherLevel.BranchRoot.getState().BranchExterior=higherLevel.Boundary.getBoundingRect();break;case OrgChart.Layout.LayoutState.Operation.HorizontalLayout:Bridge.referenceEquals(higherLevel.BranchRoot.getAssistantsRoot(),innerLevel.BranchRoot)||(strategy=higherLevel.BranchRoot.getState().RequireLayoutStrategy(),overlap=higherLevel.Boundary.ComputeOverlap(innerLevel.Boundary,strategy.SiblingSpacing,this.getDiagram().getLayoutSettings().getBranchSpacing()),overlap>0&&(OrgChart.Layout.LayoutAlgorithm.MoveBranch(this,innerLevel,overlap),Bridge.staticEquals(this.BoundaryChanged,null)?null:this.BoundaryChanged(this,new OrgChart.Layout.BoundaryChangedEventArgs(innerLevel.Boundary,innerLevel,this))));higherLevel.Boundary.MergeFrom(innerLevel.Boundary);higherLevel.BranchRoot.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor3(higherLevel.Boundary.getBoundingRect().getLeft(),higherLevel.BranchRoot.getState().BranchExterior.getTop(),higherLevel.Boundary.getBoundingRect().Size.Width,higherLevel.BranchRoot.getState().BranchExterior.Size.Height);break;default:throw new System.InvalidOperationException("This operation can only be invoked when performing vertical or horizontal layouts");}Bridge.staticEquals(this.BoundaryChanged,null)?null:this.BoundaryChanged(this,new OrgChart.Layout.BoundaryChangedEventArgs(higherLevel.Boundary,higherLevel,this))}this.m_pooledBoundaries.push(innerLevel.Boundary)}});Bridge.define("OrgChart.Layout.LayoutState.LayoutLevel",{BranchRoot:null,Boundary:null,ctor:function(node,boundary){this.$initialize();this.BranchRoot=node;this.Boundary=boundary}});Bridge.define("OrgChart.Layout.LayoutState.Operation",{$kind:"enum",statics:{Idle:0,Preparing:1,PreprocessVisualTree:2,VerticalLayout:3,HorizontalLayout:4,ConnectorsLayout:5,Completed:6}});Bridge.define("OrgChart.Layout.LayoutStateOperationChangedEventArgs",{State:null,ctor:function(state){this.$initialize();this.State=state}});Bridge.define("OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter.GroupIterator",{m_numberOfSiblings:0,m_numberOfGroups:0,Group:0,FromIndex:0,Count:0,MaxOnLeft:0,ctor:function(numberOfSiblings,numberOfGroups){this.$initialize();this.m_numberOfSiblings=numberOfSiblings;this.m_numberOfGroups=numberOfGroups},CountInGroup:function(){for(var countInRow=this.m_numberOfGroups*2|0,result=0,countToThisGroup=(this.Group*2|0)+2|0,firstInRow=0,countInThisRow;;){if(countInThisRow=firstInRow>=(this.m_numberOfSiblings-countInRow|0)?this.m_numberOfSiblings-firstInRow|0:countInRow,countInThisRow>=countToThisGroup)result=result+2|0;else{countToThisGroup=countToThisGroup-1|0;countInThisRow>=countToThisGroup&&(result=result+1|0);break}firstInRow=firstInRow+countInRow|0}return result},NextGroup:function(){return this.FromIndex=this.FromIndex+this.Count|0,this.FromIndex>0&&(this.Group=this.Group+1|0),this.Count=this.CountInGroup(),this.MaxOnLeft=(Bridge.Int.div(this.Count,2)|0)+this.Count%2|0,this.Count!==0}});Bridge.define("OrgChart.Layout.NodeLayoutInfo",{IsHidden:!1,NumberOfSiblings:0,NumberOfSiblingRows:0,NumberOfSiblingColumns:0,Connector:null,m_effectiveLayoutStrategy:null,config:{init:function(){this.TopLeft=new OrgChart.Layout.Point;this.Size=new OrgChart.Layout.Size;this.BranchExterior=new OrgChart.Layout.Rect;this.SiblingsRowV=new OrgChart.Layout.Dimensions}},setEffectiveLayoutStrategy:function(value){this.m_effectiveLayoutStrategy=value},getLeft:function(){return this.TopLeft.X},getRight:function(){return this.TopLeft.X+this.Size.Width},getTop:function(){return this.TopLeft.Y},getBottom:function(){return this.TopLeft.Y+this.Size.Height},getCenterH:function(){return this.TopLeft.X+this.Size.Width/2},getCenterV:function(){return this.TopLeft.Y+this.Size.Height/2},RequireLayoutStrategy:function(){if(this.m_effectiveLayoutStrategy==null)throw new System.Exception("effectiveLayoutStrategy is not set");return this.m_effectiveLayoutStrategy}});Bridge.define("OrgChart.Layout.Point",{$kind:"struct",statics:{getDefaultValue:function(){return new OrgChart.Layout.Point}},X:0,Y:0,$ctor1:function(x,y){this.$initialize();this.X=x;this.Y=y},ctor:function(){this.$initialize()},MoveH:function(offsetX){return new OrgChart.Layout.Point.$ctor1(this.X+offsetX,this.Y)},getHashCode:function(){return Bridge.addHash([1852403652,this.X,this.Y])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Point)?Bridge.equals(this.X,o.X)&&Bridge.equals(this.Y,o.Y):!1},$clone:function(to){var s=to||new OrgChart.Layout.Point;return s.X=this.X,s.Y=this.Y,s}});Bridge.define("OrgChart.Layout.Rect",{$kind:"struct",statics:{op_Addition:function(x,y){var left=Math.min(x.getLeft(),y.getLeft()),top=Math.min(x.getTop(),y.getTop()),right=Math.max(x.getRight(),y.getRight()),bottom=Math.max(x.getBottom(),y.getBottom());return new OrgChart.Layout.Rect.$ctor3(left,top,right-left,bottom-top)},getDefaultValue:function(){return new OrgChart.Layout.Rect}},config:{init:function(){this.TopLeft=new OrgChart.Layout.Point;this.Size=new OrgChart.Layout.Size}},$ctor3:function(x,y,w,h){if(this.$initialize(),w<0)throw new System.ArgumentOutOfRangeException("w");if(h<0)throw new System.ArgumentOutOfRangeException("h");this.TopLeft=new OrgChart.Layout.Point.$ctor1(x,y);this.Size=new OrgChart.Layout.Size.$ctor1(w,h)},$ctor1:function(topLeft,size){this.$initialize();this.TopLeft=topLeft;this.Size=size},$ctor2:function(size){this.$initialize();this.TopLeft=new OrgChart.Layout.Point.$ctor1(0,0);this.Size=size},ctor:function(){this.$initialize()},getBottomRight:function(){return new OrgChart.Layout.Point.$ctor1(this.TopLeft.X+this.Size.Width,this.TopLeft.Y+this.Size.Height)},getLeft:function(){return this.TopLeft.X},getRight:function(){return this.TopLeft.X+this.Size.Width},getCenterH:function(){return this.TopLeft.X+this.Size.Width/2},getCenterV:function(){return this.TopLeft.Y+this.Size.Height/2},getTop:function(){return this.TopLeft.Y},getBottom:function(){return this.TopLeft.Y+this.Size.Height},MoveH:function(offsetX){return new OrgChart.Layout.Rect.$ctor1(new OrgChart.Layout.Point.$ctor1(this.getLeft()+offsetX,this.getTop()),this.Size)},getHashCode:function(){return Bridge.addHash([1952671058,this.TopLeft,this.Size])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Rect)?Bridge.equals(this.TopLeft,o.TopLeft)&&Bridge.equals(this.Size,o.Size):!1},$clone:function(to){var s=to||new OrgChart.Layout.Rect;return s.TopLeft=this.TopLeft,s.Size=this.Size,s}});Bridge.define("OrgChart.Layout.Size",{$kind:"struct",statics:{getDefaultValue:function(){return new OrgChart.Layout.Size}},Width:0,Height:0,$ctor1:function(w,h){this.$initialize();this.Width=w;this.Height=h},ctor:function(){this.$initialize()},getHashCode:function(){return Bridge.addHash([1702521171,this.Width,this.Height])},equals:function(o){return Bridge.is(o,OrgChart.Layout.Size)?Bridge.equals(this.Width,o.Width)&&Bridge.equals(this.Height,o.Height):!1},$clone:function(to){var s=to||new OrgChart.Layout.Size;return s.Width=this.Width,s.Height=this.Height,s}});Bridge.define("OrgChart.Layout.StackOrientation",{$kind:"enum",statics:{InvalidValue:0,SingleRowHorizontal:1,SingleColumnVertical:2}});Bridge.define("OrgChart.Test.TestDataGen",{statics:{GenerateBoxSizes:function(boxContainer){var $t,seed=0,random,box;for(System.Diagnostics.Debug.writeln(seed.toString()),random=new System.Random.$ctor1(seed),$t=Bridge.getEnumerator(boxContainer.getBoxesById().System$Collections$Generic$IDictionary$2$System$Int32$OrgChart$Layout$Box$getValues(),OrgChart.Layout.Box);$t.moveNext();)box=$t.getCurrent(),box.IsSpecial||(box.Size=new OrgChart.Layout.Size.$ctor1(50+random.next$1(50)|0,50+random.next$1(50)|0))}},GenerateDataItems:function(dataSource,count,percentAssistants){for(var item,$t=Bridge.getEnumerator(this.GenerateRandomDataItems(count,percentAssistants));$t.moveNext();)item=$t.getCurrent(),dataSource.Items.add(item.getId(),item)},GenerateRandomDataItems:function(itemCount,percentAssistants){var random,items,i,firstInLayer,prevLayerSize,layerSize,i1,parentIndex,i2,assistantCount,i3;if(itemCount<0)throw new System.ArgumentOutOfRangeException("itemCount","Count must be zero or positive",null,itemCount);for(random=new System.Random.$ctor1(0),items=new(System.Collections.Generic.List$1(OrgChart.Test.TestDataItem))(itemCount),i=0;i<itemCount;i=i+1|0)items.add(Bridge.merge(new OrgChart.Test.TestDataItem,{setId:i.toString()}));for(firstInLayer=1,prevLayerSize=1;firstInLayer<itemCount;){for(layerSize=(15+prevLayerSize|0)+random.next$1(prevLayerSize*2|0)|0,i1=firstInLayer;i1<(firstInLayer+layerSize|0)&&i1<itemCount;i1=i1+1|0)parentIndex=(firstInLayer-1|0)-random.next$1(prevLayerSize)|0,items.getItem(i1).setParentId(items.getItem(parentIndex).getId());firstInLayer=firstInLayer+layerSize|0;prevLayerSize=layerSize}for(i2=0;i2<(Bridge.Int.div(items.getCount(),2)|0);i2=i2+1|0){var from=random.next$1(items.getCount()),to=random.next$1(items.getCount()),temp=items.getItem(from);items.setItem(from,items.getItem(to));items.setItem(to,temp)}if(percentAssistants>0)for(assistantCount=Math.min(items.getCount(),Bridge.Int.clip32(Math.ceil((items.getCount()*percentAssistants|0)/100))),i3=0;i3<assistantCount;i3=i3+1|0)items.getItem(random.next$1(items.getCount())).setIsAssistant(!0);return items}});Bridge.define("System.Diagnostics.DebuggerDisplayAttribute",{inherits:[System.Attribute],ctor:function(){this.$initialize();System.Attribute.ctor.call(this)}});Bridge.define("OrgChart.Layout.FishboneAssistantsLayoutStrategy",{inherits:[OrgChart.Layout.LayoutStrategyBase],getSupportsAssistants:function(){return!1},PreProcessThisNode:function(state,node){if(node.getState().NumberOfSiblings=node.getChildCount(),node.getState().NumberOfSiblings>0){node.getState().NumberOfSiblingColumns=1;node.getState().NumberOfSiblingRows=Bridge.Int.div(node.getState().NumberOfSiblings,2)|0;node.getState().NumberOfSiblings%2!=0&&(node.getState().NumberOfSiblingRows=node.getState().NumberOfSiblingRows+1|0);var spacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1);node.AddRegularChild(spacer)}},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,prevRowBottom,maxOnLeft,i,rowExterior,i2,child2,frame2;if(node.getLevel()===0)throw new System.InvalidOperationException("Should never be invoked on root node");for(prevRowBottom=node.getState().SiblingsRowV.To,maxOnLeft=this.MaxOnLeft(node),i=0;i<maxOnLeft;i=i+1|0){var spacing=i===0?this.ParentChildSpacing:this.SiblingSpacing,child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),frame=child.getState();OrgChart.Layout.LayoutAlgorithm.MoveTo(frame,frame.getLeft(),prevRowBottom+spacing);rowExterior=new OrgChart.Layout.Dimensions.$ctor1(frame.getTop(),frame.getBottom());i2=i+maxOnLeft|0;i2<node.getState().NumberOfSiblings&&(child2=System.Array.getItem(node.getChildren(),i2,OrgChart.Layout.BoxTree.Node),frame2=child2.getState(),OrgChart.Layout.LayoutAlgorithm.MoveTo(frame2,frame2.getLeft(),prevRowBottom+spacing),frame2.getBottom()>frame.getBottom()?OrgChart.Layout.LayoutAlgorithm.MoveTo(frame,frame.getLeft(),frame2.getCenterV()-frame.Size.Height/2):frame2.getBottom()<frame.getBottom()&&OrgChart.Layout.LayoutAlgorithm.MoveTo(frame2,frame2.getLeft(),frame.getCenterV()-frame2.Size.Height/2),frame2.BranchExterior=new OrgChart.Layout.Rect.$ctor1(frame2.TopLeft,frame2.Size),rowExterior=OrgChart.Layout.Dimensions.op_Addition(rowExterior,new OrgChart.Layout.Dimensions.$ctor1(frame2.getTop(),frame2.getBottom())),frame2.SiblingsRowV=rowExterior,OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child2),prevRowBottom=frame2.BranchExterior.getBottom());frame.BranchExterior=new OrgChart.Layout.Rect.$ctor1(frame.TopLeft,frame.Size);frame.SiblingsRowV=rowExterior;OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child);prevRowBottom=Math.max(prevRowBottom,frame.BranchExterior.getBottom())}},ApplyHorizontalLayout:function(state,level){var node=level.BranchRoot,i,child,rightmost,k,opposite,spacer,diff,carrier,desiredCenter;node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom()));var left=!0,countOnThisSide=0,maxOnLeft=this.MaxOnLeft(node);for(i=0;i<node.getState().NumberOfSiblings;i=i+1|0)if(child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child),(countOnThisSide=countOnThisSide+1|0)===maxOnLeft&&left){for(OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateSiblings(node,0,maxOnLeft)),left=!1,countOnThisSide=0,rightmost=System.Double.min,k=0;k<=i;k=k+1|0)rightmost=Math.max(rightmost,System.Array.getItem(node.getChildren(),k,OrgChart.Layout.BoxTree.Node).getState().BranchExterior.getRight());node.getState().NumberOfSiblings%2!=0?rightmost=Math.max(rightmost,child.getState().getRight()):(opposite=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node),rightmost=opposite.getElement().IsCollapsed||opposite.getChildCount()===0?Math.max(rightmost,child.getState().getRight()):Math.max(rightmost,child.getState().BranchExterior.getRight()));spacer=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node);OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(spacer.getState(),rightmost,node.getState().getBottom(),this.ParentConnectorShield,node.getState().BranchExterior.getBottom()-node.getState().getBottom());level.Boundary.MergeFrom$1(spacer)}OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateSiblings(node,maxOnLeft,node.getState().NumberOfSiblings));node.getLevel()>0&&node.getState().NumberOfSiblings>0&&(carrier=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),desiredCenter=node.getState().getCenterH(),diff=desiredCenter-carrier,OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff))},RouteConnectors:function(state,node){var count=node.getState().NumberOfSiblings,i,to,y;if(count!==0){this.NeedCarrierProtector(node)&&(count=count+1|0);var segments=System.Array.init(count,function(){return new OrgChart.Layout.Edge}),ix=0,maxOnLeft=this.MaxOnLeft(node),carrier=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node).getState(),from=carrier.getCenterH(),isLeft=!0,countOnThisSide=0,bottomMost=System.Double.min;for(i=0;i<node.getState().NumberOfSiblings;i=i+1|0)to=isLeft?System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getRight():System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getLeft(),y=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getCenterV(),bottomMost=Math.max(bottomMost,y),segments[Bridge.identity(ix,ix=ix+1|0)]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(from,y),new OrgChart.Layout.Point.$ctor1(to,y)),(countOnThisSide=countOnThisSide+1|0)===maxOnLeft&&(countOnThisSide=0,isLeft=!isLeft);this.NeedCarrierProtector(node)&&(segments[node.getState().NumberOfSiblings]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(carrier.getCenterH(),carrier.getTop()),new OrgChart.Layout.Point.$ctor1(carrier.getCenterH(),bottomMost)));node.getState().Connector=new OrgChart.Layout.Connector(segments)}},MaxOnLeft:function(node){return(Bridge.Int.div(node.getState().NumberOfSiblings,2)|0)+node.getState().NumberOfSiblings%2|0},NeedCarrierProtector:function(node){return node.getParentNode().getChildCount()===0},EnumerateSiblings:function(node,from,to){for(var $yield=[],i=from;i<to;i=i+1|0)$yield.push(System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node));return System.Array.toEnumerable($yield)}});Bridge.define("OrgChart.Layout.LinearLayoutStrategy",{inherits:[OrgChart.Layout.LayoutStrategyBase],getSupportsAssistants:function(){return!0},PreProcessThisNode:function(state,node){var verticalSpacer,horizontalSpacer;node.getChildCount()>0&&(node.getState().NumberOfSiblings=node.getElement().IsCollapsed?0:node.getChildCount(),node.getElement().IsCollapsed||(verticalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(verticalSpacer),horizontalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(horizontalSpacer)))},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,siblingsRowExterior,top,i,child,rect,i1,child1;if(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getAssistantsRoot()!=null&&(OrgChart.Layout.LayoutAlgorithm.CopyExteriorFrom(node.getAssistantsRoot().getState(),node.getState()),OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,node.getAssistantsRoot())),node.getState().NumberOfSiblings!==0){for(siblingsRowExterior=OrgChart.Layout.Dimensions.MinMax(),top=node.getAssistantsRoot()==null?node.getState().SiblingsRowV.To+this.ParentChildSpacing:node.getState().BranchExterior.getBottom()+this.ParentChildSpacing,i=0;i<node.getState().NumberOfSiblings;i=i+1|0)child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),rect=child.getState(),OrgChart.Layout.LayoutAlgorithm.MoveTo(child.getState(),0,top),child.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(child.getState().TopLeft,child.getState().Size),siblingsRowExterior=OrgChart.Layout.Dimensions.op_Addition(siblingsRowExterior,new OrgChart.Layout.Dimensions.$ctor1(top,top+rect.Size.Height));for(siblingsRowExterior=new OrgChart.Layout.Dimensions.$ctor1(siblingsRowExterior.From,siblingsRowExterior.To),i1=0;i1<node.getState().NumberOfSiblings;i1=i1+1|0)child1=System.Array.getItem(node.getChildren(),i1,OrgChart.Layout.BoxTree.Node),child1.getState().SiblingsRowV=siblingsRowExterior,OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child1)}},ApplyHorizontalLayout:function(state,level){var node=level.BranchRoot,i,child,verticalSpacer,firstInRow,horizontalSpacer;for(node.getAssistantsRoot()!=null&&OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,node.getAssistantsRoot()),i=0;i<node.getState().NumberOfSiblings;i=i+1|0)child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child);if(node.getLevel()>0&&node.getChildCount()>0){var rect=node.getState(),leftmost=System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),rightmost=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),desiredCenter=node.getState().NumberOfSiblings===1||this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Center?leftmost+(rightmost-leftmost)/2:this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Left?leftmost+this.ChildConnectorHookLength:rightmost-this.ChildConnectorHookLength,center=rect.getCenterH(),diff=center-desiredCenter;OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff);verticalSpacer=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node);OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(verticalSpacer.getState(),center-this.ParentConnectorShield/2,rect.getBottom(),this.ParentConnectorShield,System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-rect.getBottom());state.MergeSpacer(verticalSpacer);firstInRow=System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState();horizontalSpacer=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings+1|0,OrgChart.Layout.BoxTree.Node);OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(horizontalSpacer.getState(),firstInRow.getLeft(),firstInRow.SiblingsRowV.From-this.ParentChildSpacing,System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node).getState().getRight()-firstInRow.getLeft(),this.ParentChildSpacing);state.MergeSpacer(horizontalSpacer)}},RouteConnectors:function(state,node){var normalChildCount=node.getState().NumberOfSiblings,count=normalChildCount===0?0:normalChildCount===1?1:2+normalChildCount|0,space,i,childRect,childCenter;if(count===0){node.getState().Connector=null;return}var segments=System.Array.init(count,function(){return new OrgChart.Layout.Edge}),rootRect=node.getState(),center=rootRect.getCenterH();if(node.getChildren()==null)throw new System.Exception("State is present, but children not set");if(count===1)segments[0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()),new OrgChart.Layout.Point.$ctor1(center,System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().getTop()));else{for(space=System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-rootRect.getBottom(),segments[0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()),new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()+space-this.ChildConnectorHookLength)),i=0;i<normalChildCount;i=i+1|0)childRect=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState(),childCenter=childRect.getCenterH(),segments[1+i|0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(childCenter,childRect.getTop()),new OrgChart.Layout.Point.$ctor1(childCenter,childRect.getTop()-this.ChildConnectorHookLength));segments[count-1|0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(segments[1].To.X,segments[1].To.Y),new OrgChart.Layout.Point.$ctor1(segments[count-2|0].To.X,segments[1].To.Y))}node.getState().Connector=new OrgChart.Layout.Connector(segments)}});Bridge.define("OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter",{inherits:[OrgChart.Layout.LayoutStrategyBase],RealRoot:null,SpecialRoot:null,Iterator:null,ctor:function(realRoot){this.$initialize();OrgChart.Layout.LayoutStrategyBase.ctor.call(this);this.Iterator=new OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter.GroupIterator(realRoot.getState().NumberOfSiblings,realRoot.getState().NumberOfSiblingColumns);this.RealRoot=realRoot;this.SpecialRoot=Bridge.merge(new OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter.TreeNodeView(OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,realRoot.getElement().Id,!0)),{setLevel:this.RealRoot.getLevel(),setParentNode:this.RealRoot});this.SpecialRoot.getState().setEffectiveLayoutStrategy(this);var parentStrategy=Bridge.cast(realRoot.getState().RequireLayoutStrategy(),OrgChart.Layout.MultiLineFishboneLayoutStrategy);this.SiblingSpacing=parentStrategy.SiblingSpacing;this.ParentConnectorShield=parentStrategy.ParentConnectorShield;this.ParentChildSpacing=parentStrategy.ParentChildSpacing;this.ParentAlignment=parentStrategy.ParentAlignment;this.ChildConnectorHookLength=parentStrategy.ChildConnectorHookLength},getSupportsAssistants:function(){return!1},NextGroup:function(){var i,spacer;if(!this.Iterator.NextGroup())return!1;for(this.SpecialRoot.getState().NumberOfSiblings=this.Iterator.Count,this.SpecialRoot.Prepare(this.RealRoot.getState().NumberOfSiblingRows*2|0),i=0;i<this.Iterator.Count;i=i+1|0)this.SpecialRoot.AddChildView(System.Array.getItem(this.RealRoot.getChildren(),this.Iterator.FromIndex+i|0,OrgChart.Layout.BoxTree.Node));return spacer=System.Array.getItem(this.RealRoot.getChildren(),(this.RealRoot.getState().NumberOfSiblings+1|0)+this.Iterator.Group|0,OrgChart.Layout.BoxTree.Node),this.SpecialRoot.AddChildView(spacer),OrgChart.Layout.LayoutAlgorithm.CopyExteriorFrom(this.SpecialRoot.getState(),this.RealRoot.getState()),!0},PreProcessThisNode:function(){throw new System.NotSupportedException;},ApplyVerticalLayout:function(state){for(var rowExterior,i2,child2,frame2,$t,$t1,prevRowBottom=($t=this.RealRoot.getAssistantsRoot())!=null?$t.getState().BranchExterior.getBottom():($t1=null,$t1!=null?$t1:this.SpecialRoot.getState().SiblingsRowV.To),i=0;i<this.Iterator.MaxOnLeft;i=i+1|0){var spacing=i===0?this.ParentChildSpacing:this.SiblingSpacing,child=System.Array.getItem(this.SpecialRoot.getChildren(),i,OrgChart.Layout.BoxTree.Node),frame=child.getState();OrgChart.Layout.LayoutAlgorithm.MoveTo(frame,frame.getLeft(),prevRowBottom+spacing);rowExterior=new OrgChart.Layout.Dimensions.$ctor1(frame.getTop(),frame.getBottom());i2=i+this.Iterator.MaxOnLeft|0;i2<this.Iterator.Count&&(child2=System.Array.getItem(this.SpecialRoot.getChildren(),i2,OrgChart.Layout.BoxTree.Node),frame2=child2.getState(),OrgChart.Layout.LayoutAlgorithm.MoveTo(frame2,frame2.getLeft(),prevRowBottom+spacing),frame2.getBottom()>frame.getBottom()?OrgChart.Layout.LayoutAlgorithm.MoveTo(frame,frame.getLeft(),frame2.getCenterV()-frame.Size.Height/2):frame2.getBottom()<frame.getBottom()&&OrgChart.Layout.LayoutAlgorithm.MoveTo(frame2,frame2.getLeft(),frame.getCenterV()-frame2.Size.Height/2),frame2.BranchExterior=new OrgChart.Layout.Rect.$ctor1(frame2.TopLeft,frame2.Size),rowExterior=OrgChart.Layout.Dimensions.op_Addition(rowExterior,new OrgChart.Layout.Dimensions.$ctor1(frame2.getTop(),frame2.getBottom())),frame2.SiblingsRowV=rowExterior,OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child2),prevRowBottom=frame2.BranchExterior.getBottom());frame.BranchExterior=new OrgChart.Layout.Rect.$ctor1(frame.TopLeft,frame.Size);frame.SiblingsRowV=rowExterior;OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child);prevRowBottom=Math.max(prevRowBottom,frame.BranchExterior.getBottom())}},ApplyHorizontalLayout:function(state,level){var left,countOnThisSide,i,child,rightmost,k,spacer;if(!Bridge.referenceEquals(level.BranchRoot,this.SpecialRoot))throw new System.InvalidOperationException("Wrong root node received");for(left=!0,countOnThisSide=0,i=0;i<this.Iterator.Count;i=i+1|0)if(child=System.Array.getItem(this.SpecialRoot.getChildren(),i,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child),(countOnThisSide=countOnThisSide+1|0)===this.Iterator.MaxOnLeft&&left){for(OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateSiblings(0,this.Iterator.MaxOnLeft)),left=!1,countOnThisSide=0,rightmost=System.Double.min,k=0;k<i;k=k+1|0)rightmost=Math.max(rightmost,System.Array.getItem(this.SpecialRoot.getChildren(),k,OrgChart.Layout.BoxTree.Node).getState().BranchExterior.getRight());rightmost=Math.max(rightmost,child.getState().getRight());spacer=System.Array.getItem(this.SpecialRoot.getChildren(),this.SpecialRoot.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node);OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(spacer.getState(),rightmost,System.Array.getItem(this.SpecialRoot.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From,this.SiblingSpacing,child.getState().SiblingsRowV.To-System.Array.getItem(this.SpecialRoot.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From);level.Boundary.MergeFrom$1(spacer)}OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateSiblings(this.Iterator.MaxOnLeft,this.Iterator.Count))},EnumerateSiblings:function(from,to){for(var $yield=[],i=from;i<to;i=i+1|0)$yield.push(System.Array.getItem(this.SpecialRoot.getChildren(),i,OrgChart.Layout.BoxTree.Node));return System.Array.toEnumerable($yield)},RouteConnectors:function(){throw new System.NotSupportedException;}});Bridge.define("OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter.TreeNodeView",{inherits:[OrgChart.Layout.BoxTree.Node],ctor:function(element){this.$initialize();OrgChart.Layout.BoxTree.Node.ctor.call(this,element)},Prepare:function(capacity){this.getChildren()==null?this.setChildren(new(System.Collections.Generic.List$1(OrgChart.Layout.BoxTree.Node))(capacity)):System.Array.clear(this.getChildren(),OrgChart.Layout.BoxTree.Node)},AddChildView:function(node){System.Array.add(this.getChildren(),node,OrgChart.Layout.BoxTree.Node)}});Bridge.define("OrgChart.Layout.SingleColumnLayoutStrategy",{inherits:[OrgChart.Layout.LayoutStrategyBase],getSupportsAssistants:function(){return!0},PreProcessThisNode:function(state,node){if(this.ParentAlignment!==OrgChart.Layout.BranchParentAlignment.Left&&this.ParentAlignment!==OrgChart.Layout.BranchParentAlignment.Right)throw new System.InvalidOperationException("Unsupported value for ParentAlignment");if(node.getState().NumberOfSiblings=node.getElement().IsCollapsed?0:node.getChildCount(),node.getState().NumberOfSiblings>0&&node.getLevel()>0){node.getState().NumberOfSiblingColumns=1;node.getState().NumberOfSiblingRows=node.getChildCount();var verticalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1);node.AddRegularChild(verticalSpacer)}},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,prevRowExterior,row,rowExterior,childBranchBottom;for(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getAssistantsRoot()!=null&&(OrgChart.Layout.LayoutAlgorithm.CopyExteriorFrom(node.getAssistantsRoot().getState(),node.getState()),OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,node.getAssistantsRoot())),prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(node.getState().SiblingsRowV.From,node.getAssistantsRoot()==null?node.getState().SiblingsRowV.To:node.getState().BranchExterior.getBottom()),row=0;row<node.getState().NumberOfSiblings;row=row+1|0){var child=System.Array.getItem(node.getChildren(),row,OrgChart.Layout.BoxTree.Node),rect=child.getState(),top=prevRowExterior.To+(row===0?this.ParentChildSpacing:this.SiblingSpacing);OrgChart.Layout.LayoutAlgorithm.MoveTo(child.getState(),rect.getLeft(),top);child.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(child.getState().TopLeft,child.getState().Size);rowExterior=new OrgChart.Layout.Dimensions.$ctor1(top,top+rect.Size.Height);child=System.Array.getItem(node.getChildren(),row,OrgChart.Layout.BoxTree.Node);child.getState().SiblingsRowV=rowExterior;OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child);childBranchBottom=child.getState().BranchExterior.getBottom();prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(rowExterior.From,Math.max(childBranchBottom,rowExterior.To))}},ApplyHorizontalLayout:function(state,level){var node=level.BranchRoot,nodeState=node.getState(),row,child,edges,rect,diff,desiredLeft,desiredRight,verticalSpacer,spacerTop,spacerBottom;for(node.getAssistantsRoot()!=null&&OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,node.getAssistantsRoot()),row=0;row<nodeState.NumberOfSiblings;row=row+1|0)child=System.Array.getItem(node.getChildren(),row,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child);if(edges=OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateColumn(node)),node.getLevel()>0&&node.getChildCount()>0){if(rect=node.getState(),this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Left)desiredLeft=rect.getCenterH()+this.ParentConnectorShield/2,diff=desiredLeft-edges.From;else if(this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Right)desiredRight=rect.getCenterH()-this.ParentConnectorShield/2,diff=desiredRight-edges.To;else throw new System.InvalidOperationException("Invalid ParentAlignment setting");OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff);verticalSpacer=node.getLevel()>0?System.Array.getItem(node.getChildren(),node.getChildCount()-1|0,OrgChart.Layout.BoxTree.Node):null;verticalSpacer!=null&&(spacerTop=node.getState().getBottom(),spacerBottom=System.Array.getItem(node.getChildren(),node.getChildCount()-2|0,OrgChart.Layout.BoxTree.Node).getState().getBottom(),OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(verticalSpacer.getState(),rect.getCenterH()-this.ParentConnectorShield/2,spacerTop,this.ParentConnectorShield,spacerBottom-spacerTop),state.MergeSpacer(verticalSpacer))}},EnumerateColumn:function(branchRoot){for(var $yield=[],i=0;i<branchRoot.getState().NumberOfSiblings;i=i+1|0)$yield.push(System.Array.getItem(branchRoot.getChildren(),i,OrgChart.Layout.BoxTree.Node));return System.Array.toEnumerable($yield)},RouteConnectors:function(state,node){var ix,rect,destination;if(node.getChildCount()!==0){var count=1+node.getState().NumberOfSiblings|0,segments=System.Array.init(count,function(){return new OrgChart.Layout.Edge}),rootRect=node.getState(),center=rootRect.getCenterH(),verticalCarrierHeight=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node).getState().getCenterV()-node.getState().getBottom();for(segments[0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()),new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()+verticalCarrierHeight)),ix=0;ix<node.getState().NumberOfSiblings;ix=ix+1|0)rect=System.Array.getItem(node.getChildren(),ix,OrgChart.Layout.BoxTree.Node).getState(),destination=this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Left?rect.getLeft():rect.getRight(),segments[1+ix|0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rect.getCenterV()),new OrgChart.Layout.Point.$ctor1(destination,rect.getCenterV()));node.getState().Connector=new OrgChart.Layout.Connector(segments)}}});Bridge.define("OrgChart.Layout.StackingLayoutStrategy",{inherits:[OrgChart.Layout.LayoutStrategyBase],Orientation:0,ctor:function(){this.$initialize();OrgChart.Layout.LayoutStrategyBase.ctor.call(this);this.Orientation=OrgChart.Layout.StackOrientation.SingleRowHorizontal;this.ParentAlignment=OrgChart.Layout.BranchParentAlignment.InvalidValue;this.ChildConnectorHookLength=0;this.ParentConnectorShield=0;this.SiblingSpacing=5},getSupportsAssistants:function(){return!1},PreProcessThisNode:function(state,node){if(node.getState().NumberOfSiblings=node.getElement().IsCollapsed?0:node.getChildCount(),node.getState().NumberOfSiblings>0&&this.Orientation!==OrgChart.Layout.StackOrientation.SingleRowHorizontal&&this.Orientation!==OrgChart.Layout.StackOrientation.SingleColumnVertical)throw new System.InvalidOperationException("Unsupported value for orientation: "+System.Enum.toString(OrgChart.Layout.StackOrientation,this.Orientation));},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,siblingsRowExterior,top,i,child,rect,i1,child1,prevRowExterior,row,rowExterior,childBranchBottom;if(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getState().NumberOfSiblings!==0)if(siblingsRowExterior=OrgChart.Layout.Dimensions.MinMax(),this.Orientation===OrgChart.Layout.StackOrientation.SingleRowHorizontal){for(top=node.getAssistantsRoot()==null?node.getState().SiblingsRowV.To+this.ParentChildSpacing:node.getState().BranchExterior.getBottom()+this.ParentChildSpacing,i=0;i<node.getState().NumberOfSiblings;i=i+1|0)child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),rect=child.getState(),OrgChart.Layout.LayoutAlgorithm.MoveTo(child.getState(),0,top),child.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(child.getState().TopLeft,child.getState().Size),siblingsRowExterior=OrgChart.Layout.Dimensions.op_Addition(siblingsRowExterior,new OrgChart.Layout.Dimensions.$ctor1(top,top+rect.Size.Height));for(siblingsRowExterior=new OrgChart.Layout.Dimensions.$ctor1(siblingsRowExterior.From,siblingsRowExterior.To),i1=0;i1<node.getState().NumberOfSiblings;i1=i1+1|0)child1=System.Array.getItem(node.getChildren(),i1,OrgChart.Layout.BoxTree.Node),child1.getState().SiblingsRowV=siblingsRowExterior,OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child1)}else if(this.Orientation===OrgChart.Layout.StackOrientation.SingleColumnVertical)for(prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(node.getState().SiblingsRowV.From,node.getState().SiblingsRowV.To),row=0;row<node.getState().NumberOfSiblings;row=row+1|0){var child2=System.Array.getItem(node.getChildren(),row,OrgChart.Layout.BoxTree.Node),rect1=child2.getState(),top1=prevRowExterior.To+(row===0?this.ParentChildSpacing:this.SiblingSpacing);OrgChart.Layout.LayoutAlgorithm.MoveTo(child2.getState(),rect1.getLeft(),top1);child2.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(child2.getState().TopLeft,child2.getState().Size);rowExterior=new OrgChart.Layout.Dimensions.$ctor1(top1,top1+rect1.Size.Height);child2=System.Array.getItem(node.getChildren(),row,OrgChart.Layout.BoxTree.Node);child2.getState().SiblingsRowV=rowExterior;OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child2);childBranchBottom=child2.getState().BranchExterior.getBottom();prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(rowExterior.From,Math.max(childBranchBottom,rowExterior.To))}},ApplyHorizontalLayout:function(state,level){for(var node=level.BranchRoot,child,width,$t=Bridge.getEnumerator(node.getChildren(),OrgChart.Layout.BoxTree.Node);$t.moveNext();)child=$t.getCurrent(),OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child);if(node.getChildCount()>0)if(this.Orientation===OrgChart.Layout.StackOrientation.SingleRowHorizontal){width=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node).getState().getRight()-System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().getLeft();node.getState().Size=new OrgChart.Layout.Size.$ctor1(Math.max(node.getState().Size.Width,width),node.getState().Size.Height);var center=(System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().getLeft()+System.Array.getItem(node.getChildren(),node.getChildCount()-1|0,OrgChart.Layout.BoxTree.Node).getState().getRight())/2,desiredCenter=node.getState().getCenterH(),diff=desiredCenter-center;OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff)}else if(this.Orientation===OrgChart.Layout.StackOrientation.SingleColumnVertical){OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,node.getChildren());var center1=System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),desiredCenter1=node.getState().getCenterH(),diff1=desiredCenter1-center1;OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff1)}},RouteConnectors:function(){}});Bridge.define("OrgChart.Test.TestDataItem",{inherits:[OrgChart.Layout.IChartDataItem],config:{properties:{Id:null,IsAssistant:!1,ParentId:null,String1:null,String2:null,Date1:null},alias:["getId","OrgChart$Layout$IChartDataItem$getId","setId","OrgChart$Layout$IChartDataItem$setId","getIsAssistant","OrgChart$Layout$IChartDataItem$getIsAssistant","setIsAssistant","OrgChart$Layout$IChartDataItem$setIsAssistant"],init:function(){this.Date1=new Date(-864e13)}}});Bridge.define("OrgChart.Test.TestDataSource",{inherits:[OrgChart.Layout.IChartDataSource],Items:null,config:{alias:["getAllDataItemIds","OrgChart$Layout$IChartDataSource$getAllDataItemIds","getGetParentKeyFunc","OrgChart$Layout$IChartDataSource$getGetParentKeyFunc","getGetDataItemFunc","OrgChart$Layout$IChartDataSource$getGetDataItemFunc"],init:function(){this.Items=new(System.Collections.Generic.Dictionary$2(String,OrgChart.Test.TestDataItem))}},getAllDataItemIds:function(){return System.Linq.Enumerable.from(this.Items.getKeys()).orderBy($asm.$.OrgChart.Test.TestDataSource.f1)},getGetParentKeyFunc:function(){return Bridge.fn.bind(this,this.GetParentKey)},getGetDataItemFunc:function(){return Bridge.fn.bind(this,this.GetDataItem)},GetParentKey:function(itemId){return this.Items.get(itemId).getParentId()},GetDataItem:function(itemId){return this.Items.get(itemId)}});Bridge.ns("OrgChart.Test.TestDataSource",$asm.$);Bridge.apply($asm.$.OrgChart.Test.TestDataSource,{f1:function(x){return x}});Bridge.define("OrgChart.Layout.MultiLineFishboneLayoutStrategy",{inherits:[OrgChart.Layout.LinearLayoutStrategy],MaxGroups:4,getSupportsAssistants:function(){return!0},PreProcessThisNode:function(state,node){var parentSpacer,i,verticalSpacer,horizontalSpacer;if(this.MaxGroups<=0)throw new System.InvalidOperationException("MaxGroups must be a positive value");if(node.getChildCount()<=(this.MaxGroups*2|0)){OrgChart.Layout.LinearLayoutStrategy.prototype.PreProcessThisNode.call(this,state,node);return}if(node.getState().NumberOfSiblings=node.getChildCount(),node.getState().NumberOfSiblings>0){for(node.getState().NumberOfSiblingColumns=this.MaxGroups,node.getState().NumberOfSiblingRows=Bridge.Int.div(node.getState().NumberOfSiblings,this.MaxGroups*2|0)|0,node.getState().NumberOfSiblings%(this.MaxGroups*2|0)!=0&&(node.getState().NumberOfSiblingRows=node.getState().NumberOfSiblingRows+1|0),parentSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(parentSpacer),i=0;i<node.getState().NumberOfSiblingColumns;i=i+1|0)verticalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(verticalSpacer);node.getState().NumberOfSiblingColumns>1&&(horizontalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(horizontalSpacer))}},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,adapter;if(node.getState().NumberOfSiblings<=(this.MaxGroups*2|0)){OrgChart.Layout.LinearLayoutStrategy.prototype.ApplyVerticalLayout.call(this,state,level);return}for(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getAssistantsRoot()!=null&&(OrgChart.Layout.LayoutAlgorithm.CopyExteriorFrom(node.getAssistantsRoot().getState(),node.getState()),OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,node.getAssistantsRoot())),adapter=new OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter(node);adapter.NextGroup();)OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,adapter.SpecialRoot)},ApplyHorizontalLayout:function(state,level){var node=level.BranchRoot,adapter,rect,diff,carrier,desiredCenter1,ix,verticalSpacer;if(node.getState().NumberOfSiblings<=(this.MaxGroups*2|0)){OrgChart.Layout.LinearLayoutStrategy.prototype.ApplyHorizontalLayout.call(this,state,level);return}for(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getAssistantsRoot()!=null&&OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,node.getAssistantsRoot()),adapter=new OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter(node);adapter.NextGroup();)OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,adapter.SpecialRoot);if(rect=node.getState(),node.getLevel()>0){if(node.getState().NumberOfSiblingColumns>1){var leftCarrier=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings+1|0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),rightCarrier=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings+node.getState().NumberOfSiblingColumns|0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),desiredCenter=node.getState().NumberOfSiblings===1||this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Center?leftCarrier+(rightCarrier-leftCarrier)/2:this.ParentAlignment===OrgChart.Layout.BranchParentAlignment.Left?leftCarrier+this.ChildConnectorHookLength:rightCarrier-this.ChildConnectorHookLength;diff=rect.getCenterH()-desiredCenter}else carrier=System.Array.getItem(node.getChildren(),1+node.getState().NumberOfSiblings|0,OrgChart.Layout.BoxTree.Node).getState().getCenterH(),desiredCenter1=rect.getCenterH(),diff=desiredCenter1-carrier;OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff)}if(node.getLevel()>0&&(ix=node.getState().NumberOfSiblings,verticalSpacer=System.Array.getItem(node.getChildren(),ix,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(verticalSpacer.getState(),rect.getCenterH()-this.ParentConnectorShield/2,rect.getBottom(),this.ParentConnectorShield,System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-rect.getBottom()),state.MergeSpacer(verticalSpacer),ix=ix+1|0,ix=ix+node.getState().NumberOfSiblingColumns|0,node.getState().NumberOfSiblingColumns>1)){var horizontalSpacer=System.Array.getItem(node.getChildren(),ix,OrgChart.Layout.BoxTree.Node),leftmost=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings+1|0,OrgChart.Layout.BoxTree.Node).getState().TopLeft,rightmost=System.Array.getItem(node.getChildren(),ix-1|0,OrgChart.Layout.BoxTree.Node).getState().getRight();OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(horizontalSpacer.getState(),leftmost.X,leftmost.Y-this.ParentChildSpacing,rightmost-leftmost.X,this.ParentChildSpacing);state.MergeSpacer(horizontalSpacer)}},RouteConnectors:function(state,node){var count,iterator,i,to,y,leftGroup,rightGroup;if(node.getState().NumberOfSiblings<=(this.MaxGroups*2|0)){OrgChart.Layout.LinearLayoutStrategy.prototype.RouteConnectors.call(this,state,node);return}count=(1+node.getState().NumberOfSiblings|0)+node.getState().NumberOfSiblingColumns|0;node.getState().NumberOfSiblingColumns>1&&(count=count+1|0);var segments=System.Array.init(count,function(){return new OrgChart.Layout.Edge}),rootRect=node.getState(),center=rootRect.getCenterH(),ix=0,space=System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-rootRect.getBottom();for(segments[Bridge.identity(ix,ix=ix+1|0)]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()),new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()+space-this.ChildConnectorHookLength)),iterator=new OrgChart.Layout.MultiLineFishboneLayoutStrategy.SingleFishboneLayoutAdapter.GroupIterator(node.getState().NumberOfSiblings,node.getState().NumberOfSiblingColumns);iterator.NextGroup();){var carrier=System.Array.getItem(node.getChildren(),(1+node.getState().NumberOfSiblings|0)+iterator.Group|0,OrgChart.Layout.BoxTree.Node).getState(),from=carrier.getCenterH(),isLeft=!0,countOnThisSide=0;for(i=iterator.FromIndex;i<(iterator.FromIndex+iterator.Count|0);i=i+1|0)to=isLeft?System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getRight():System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getLeft(),y=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getCenterV(),segments[Bridge.identity(ix,ix=ix+1|0)]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(from,y),new OrgChart.Layout.Point.$ctor1(to,y)),(countOnThisSide=countOnThisSide+1|0)===iterator.MaxOnLeft&&(countOnThisSide=0,isLeft&&(segments[(1+node.getState().NumberOfSiblings|0)+iterator.Group|0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(carrier.getCenterH(),carrier.getTop()-this.ChildConnectorHookLength),new OrgChart.Layout.Point.$ctor1(carrier.getCenterH(),System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node).getState().getCenterV()))),isLeft=!isLeft)}ix=ix+node.getState().NumberOfSiblingColumns|0;node.getState().NumberOfSiblingColumns>1&&(leftGroup=System.Array.getItem(node.getChildren(),1+node.getState().NumberOfSiblings|0,OrgChart.Layout.BoxTree.Node).getState(),rightGroup=System.Array.getItem(node.getChildren(),((1+node.getState().NumberOfSiblings|0)+node.getState().NumberOfSiblingColumns|0)-1|0,OrgChart.Layout.BoxTree.Node).getState(),segments[ix]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(leftGroup.getCenterH(),leftGroup.getTop()-this.ChildConnectorHookLength),new OrgChart.Layout.Point.$ctor1(rightGroup.getCenterH(),rightGroup.getTop()-this.ChildConnectorHookLength)));node.getState().Connector=new OrgChart.Layout.Connector(segments)}});Bridge.define("OrgChart.Layout.MultiLineHangerLayoutStrategy",{inherits:[OrgChart.Layout.LinearLayoutStrategy],MaxSiblingsPerRow:4,getSupportsAssistants:function(){return!0},PreProcessThisNode:function(state,node){var lastRowBoxCount,ix,siblingSpacer,verticalSpacer,i,horizontalSpacer;if(this.MaxSiblingsPerRow<=0||this.MaxSiblingsPerRow%2!=0)throw new System.InvalidOperationException("MaxSiblingsPerRow must be a positive even value");if(node.getChildCount()<=this.MaxSiblingsPerRow){OrgChart.Layout.LinearLayoutStrategy.prototype.PreProcessThisNode.call(this,state,node);return}if(node.getState().NumberOfSiblings=node.getChildCount(),node.getState().NumberOfSiblings>0){for(lastRowBoxCount=node.getChildCount()%this.MaxSiblingsPerRow,node.getState().NumberOfSiblingColumns=1+this.MaxSiblingsPerRow|0,node.getState().NumberOfSiblingRows=Bridge.Int.div(node.getChildCount(),this.MaxSiblingsPerRow)|0,lastRowBoxCount!==0&&(node.getState().NumberOfSiblingRows=node.getState().NumberOfSiblingRows+1|0),node.getState().NumberOfSiblings=node.getChildCount()+node.getState().NumberOfSiblingRows|0,lastRowBoxCount>0&&lastRowBoxCount<=(Bridge.Int.div(this.MaxSiblingsPerRow,2)|0)&&(node.getState().NumberOfSiblings=node.getState().NumberOfSiblings-1|0),ix=Bridge.Int.div(this.MaxSiblingsPerRow,2)|0;ix<node.getState().NumberOfSiblings;)siblingSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.InsertRegularChild(ix,siblingSpacer),ix=ix+node.getState().NumberOfSiblingColumns|0;for(verticalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(verticalSpacer),i=0;i<node.getState().NumberOfSiblingRows;i=i+1|0)horizontalSpacer=OrgChart.Layout.Box.Special(OrgChart.Layout.Box.None,node.getElement().Id,!1),node.AddRegularChild(horizontalSpacer)}},ApplyVerticalLayout:function(state,level){var node=level.BranchRoot,prevRowExterior,row,i,child,rect,top,siblingsBottom,i1,child1,spacerIndex,spacerBottom,spacer;if(node.getState().NumberOfSiblings<=this.MaxSiblingsPerRow){OrgChart.Layout.LinearLayoutStrategy.prototype.ApplyVerticalLayout.call(this,state,level);return}for(node.getLevel()===0&&(node.getState().SiblingsRowV=new OrgChart.Layout.Dimensions.$ctor1(node.getState().getTop(),node.getState().getBottom())),node.getAssistantsRoot()!=null&&(OrgChart.Layout.LayoutAlgorithm.CopyExteriorFrom(node.getAssistantsRoot().getState(),node.getState()),OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,node.getAssistantsRoot())),prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(node.getState().SiblingsRowV.From,node.getAssistantsRoot()==null?node.getState().SiblingsRowV.To:node.getState().BranchExterior.getBottom()),row=0;row<node.getState().NumberOfSiblingRows;row=row+1|0){var siblingsRowExterior=OrgChart.Layout.Dimensions.MinMax(),spacing=row===0?this.ParentChildSpacing:this.SiblingSpacing,from=row*node.getState().NumberOfSiblingColumns|0,to=Math.min(from+node.getState().NumberOfSiblingColumns|0,node.getState().NumberOfSiblings);for(i=from;i<to;i=i+1|0)(child=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),child.getElement().IsSpecial)||(rect=child.getState(),top=prevRowExterior.To+spacing,OrgChart.Layout.LayoutAlgorithm.MoveTo(child.getState(),rect.getLeft(),top),child.getState().BranchExterior=new OrgChart.Layout.Rect.$ctor1(child.getState().TopLeft,child.getState().Size),siblingsRowExterior=OrgChart.Layout.Dimensions.op_Addition(siblingsRowExterior,new OrgChart.Layout.Dimensions.$ctor1(top,top+rect.Size.Height)));for(siblingsRowExterior=new OrgChart.Layout.Dimensions.$ctor1(siblingsRowExterior.From,siblingsRowExterior.To),siblingsBottom=System.Double.min,i1=from;i1<to;i1=i1+1|0)child1=System.Array.getItem(node.getChildren(),i1,OrgChart.Layout.BoxTree.Node),child1.getState().SiblingsRowV=siblingsRowExterior,OrgChart.Layout.LayoutAlgorithm.VerticalLayout(state,child1),siblingsBottom=Math.max(siblingsBottom,child1.getState().BranchExterior.getBottom());prevRowExterior=new OrgChart.Layout.Dimensions.$ctor1(siblingsRowExterior.From,Math.max(siblingsBottom,siblingsRowExterior.To));spacerIndex=from+(Bridge.Int.div(node.getState().NumberOfSiblingColumns,2)|0)|0;spacerIndex<node.getState().NumberOfSiblings&&(spacerBottom=row===(node.getState().NumberOfSiblingRows-1|0)?System.Array.getItem(node.getChildren(),spacerIndex-1|0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.To:prevRowExterior.To,spacer=System.Array.getItem(node.getChildren(),spacerIndex,OrgChart.Layout.BoxTree.Node).getState(),OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(spacer,0,prevRowExterior.From,this.ParentConnectorShield,spacerBottom-prevRowExterior.From))}},ApplyHorizontalLayout:function(state,level){var node=level.BranchRoot,col,row,ix,child,verticalSpacer,spacing,firstInRowIndex;if(node.getState().NumberOfSiblings<=this.MaxSiblingsPerRow){OrgChart.Layout.LinearLayoutStrategy.prototype.ApplyHorizontalLayout.call(this,state,level);return}for(node.getAssistantsRoot()!=null&&OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,node.getAssistantsRoot()),col=0;col<node.getState().NumberOfSiblingColumns;col=col+1|0){for(row=0;row<node.getState().NumberOfSiblingRows;row=row+1|0){if(ix=(row*node.getState().NumberOfSiblingColumns|0)+col|0,ix>=node.getState().NumberOfSiblings)break;child=System.Array.getItem(node.getChildren(),ix,OrgChart.Layout.BoxTree.Node);OrgChart.Layout.LayoutAlgorithm.HorizontalLayout(state,child)}OrgChart.Layout.LayoutAlgorithm.AlignHorizontalCenters(state,level,this.EnumerateColumn(node,col))}var rect=node.getState(),spacer=System.Array.getItem(node.getChildren(),Bridge.Int.div(node.getState().NumberOfSiblingColumns,2)|0,OrgChart.Layout.BoxTree.Node),desiredCenter=spacer.getState().getCenterH(),diff=rect.getCenterH()-desiredCenter;for(OrgChart.Layout.LayoutAlgorithm.MoveChildrenOnly(state,level,diff),verticalSpacer=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings,OrgChart.Layout.BoxTree.Node),OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(verticalSpacer.getState(),rect.getCenterH()-this.ParentConnectorShield/2,rect.getBottom(),this.ParentConnectorShield,System.Array.getItem(node.getChildren(),0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-rect.getBottom()),state.MergeSpacer(verticalSpacer),spacing=this.ParentChildSpacing,firstInRowIndex=0;firstInRowIndex<node.getState().NumberOfSiblings;firstInRowIndex=firstInRowIndex+node.getState().NumberOfSiblingColumns|0){var firstInRow=System.Array.getItem(node.getChildren(),firstInRowIndex,OrgChart.Layout.BoxTree.Node).getState(),lastInRow=System.Array.getItem(node.getChildren(),Math.min((firstInRowIndex+node.getState().NumberOfSiblingColumns|0)-1|0,node.getState().NumberOfSiblings-1|0),OrgChart.Layout.BoxTree.Node).getState(),horizontalSpacer=System.Array.getItem(node.getChildren(),(1+node.getState().NumberOfSiblings|0)+(Bridge.Int.div(firstInRowIndex,node.getState().NumberOfSiblingColumns)|0)|0,OrgChart.Layout.BoxTree.Node),width=lastInRow.getRight()>=verticalSpacer.getState().getRight()?lastInRow.getRight()-firstInRow.getLeft():verticalSpacer.getState().getRight()-firstInRow.getLeft();OrgChart.Layout.LayoutAlgorithm.AdjustSpacer(horizontalSpacer.getState(),firstInRow.getLeft(),firstInRow.SiblingsRowV.From-spacing,width,spacing);state.MergeSpacer(horizontalSpacer);spacing=this.SiblingSpacing}},EnumerateColumn:function(branchRoot,col){for(var ix,$yield=[],row=0;row<branchRoot.getState().NumberOfSiblingRows;row=row+1|0){if(ix=(row*branchRoot.getState().NumberOfSiblingColumns|0)+col|0,ix>=branchRoot.getState().NumberOfSiblings)break;$yield.push(System.Array.getItem(branchRoot.getChildren(),ix,OrgChart.Layout.BoxTree.Node))}return System.Array.toEnumerable($yield)},RouteConnectors:function(state,node){var $t,count,child,ix,i,child1,childRect,childCenter,lastChildHookIndex,firstInRowIndex,firstInRow,lastInRow;if(node.getState().NumberOfSiblings<=this.MaxSiblingsPerRow){OrgChart.Layout.LinearLayoutStrategy.prototype.RouteConnectors.call(this,state,node);return}for(count=1+node.getState().NumberOfSiblingRows|0,$t=Bridge.getEnumerator(node.getChildren(),OrgChart.Layout.BoxTree.Node);$t.moveNext();)child=$t.getCurrent(),child.getElement().IsSpecial||(count=count+1|0);var segments=System.Array.init(count,function(){return new OrgChart.Layout.Edge}),rootRect=node.getState(),center=rootRect.getCenterH(),verticalCarrierHeight=System.Array.getItem(node.getChildren(),node.getState().NumberOfSiblings-1|0,OrgChart.Layout.BoxTree.Node).getState().SiblingsRowV.From-this.ChildConnectorHookLength-rootRect.getBottom();for(segments[0]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()),new OrgChart.Layout.Point.$ctor1(center,rootRect.getBottom()+verticalCarrierHeight)),ix=1,i=0;i<node.getState().NumberOfSiblings;i=i+1|0)child1=System.Array.getItem(node.getChildren(),i,OrgChart.Layout.BoxTree.Node),child1.getElement().IsSpecial||(childRect=child1.getState(),childCenter=childRect.getCenterH(),segments[Bridge.identity(ix,ix=ix+1|0)]=new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(childCenter,childRect.getTop()),new OrgChart.Layout.Point.$ctor1(childCenter,childRect.getTop()-this.ChildConnectorHookLength)));for(lastChildHookIndex=(count-node.getState().NumberOfSiblingRows|0)-1|0,firstInRowIndex=1;firstInRowIndex<(count-node.getState().NumberOfSiblingRows|0);firstInRowIndex=firstInRowIndex+this.MaxSiblingsPerRow|0)firstInRow=segments[firstInRowIndex],lastInRow=segments[Math.min((firstInRowIndex+this.MaxSiblingsPerRow|0)-1|0,lastChildHookIndex)],segments[Bridge.identity(ix,ix=ix+1|0)]=lastInRow.From.X<segments[0].From.X?new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(firstInRow.To.X,firstInRow.To.Y),new OrgChart.Layout.Point.$ctor1(segments[0].To.X,firstInRow.To.Y)):new OrgChart.Layout.Edge.$ctor1(new OrgChart.Layout.Point.$ctor1(firstInRow.To.X,firstInRow.To.Y),new OrgChart.Layout.Point.$ctor1(lastInRow.To.X,firstInRow.To.Y));node.getState().Connector=new OrgChart.Layout.Connector(segments)}});var $m=Bridge.setMetadata,$n=[OrgChart.Layout,System,System.Collections.Generic,OrgChart.Annotations,OrgChart.Test];$m($n[3].ContractAnnotationAttribute,function(){return{m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Contract",t:16,rt:String,g:{a:2,n:"get_Contract",t:8,sn:"getContract",rt:String},s:{a:1,n:"set_Contract",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setContract",rt:Object,p:[String]}}],am:!0}});$m($n[0].Boundary.Step,function(){return{at:[new System.Diagnostics.DebuggerDisplayAttribute("{X}, {Top} - {Bottom}, {Node.Element.Id}")],m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Node",t:4,rt:$n[0].BoxTree.Node,sn:"Node",ro:!0}]}});$m($n[0].Box,function(){return{at:[new System.Diagnostics.DebuggerDisplayAttribute("{Id}, Size.Width}x{Size.Height}")],m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Special",is:!0,t:8,pi:[{n:"id",pt:$n[1].Int32,ps:0},{n:"visualParentId",pt:$n[1].Int32,ps:1},{n:"disableCollisionDetection",pt:Boolean,ps:2}],sn:"Special",rt:$n[0].Box,p:[$n[1].Int32,$n[1].Int32,Boolean]},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"AssistantLayoutStrategyId",t:4,rt:String,sn:"AssistantLayoutStrategyId"},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"DataId",t:4,rt:String,sn:"DataId",ro:!0},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"LayoutStrategyId",t:4,rt:String,sn:"LayoutStrategyId"}]}});$m($n[0].BoxContainer,function(){return{m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"SystemRoot",t:16,rt:$n[0].Box,g:{a:2,n:"get_SystemRoot",t:8,sn:"getSystemRoot",rt:$n[0].Box},s:{a:2,n:"set_SystemRoot",t:8,pi:[{n:"value",pt:$n[0].Box,ps:0}],sn:"setSystemRoot",rt:Object,p:[$n[0].Box]}}]}});$m($n[0].BoxTree.Node,function(){return{m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"AssistantsRoot",t:16,rt:$n[0].BoxTree.Node,g:{a:2,n:"get_AssistantsRoot",t:8,sn:"getAssistantsRoot",rt:$n[0].BoxTree.Node},s:{a:3,n:"set_AssistantsRoot",t:8,pi:[{n:"value",pt:$n[0].BoxTree.Node,ps:0}],sn:"setAssistantsRoot",rt:Object,p:[$n[0].BoxTree.Node]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"Children",t:16,rt:$n[2].IList$1(OrgChart.Layout.BoxTree.Node),g:{a:2,n:"get_Children",t:8,sn:"getChildren",rt:$n[2].IList$1(OrgChart.Layout.BoxTree.Node)},s:{a:3,n:"set_Children",t:8,pi:[{n:"value",pt:$n[2].IList$1(OrgChart.Layout.BoxTree.Node),ps:0}],sn:"setChildren",rt:Object,p:[$n[2].IList$1(OrgChart.Layout.BoxTree.Node)]}},{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Element",t:16,rt:$n[0].Box,g:{a:2,n:"get_Element",t:8,sn:"getElement",rt:$n[0].Box},s:{a:1,n:"set_Element",t:8,pi:[{n:"value",pt:$n[0].Box,ps:0}],sn:"setElement",rt:Object,p:[$n[0].Box]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"ParentNode",t:16,rt:$n[0].BoxTree.Node,g:{a:2,n:"get_ParentNode",t:8,sn:"getParentNode",rt:$n[0].BoxTree.Node},s:{a:2,n:"set_ParentNode",t:8,pi:[{n:"value",pt:$n[0].BoxTree.Node,ps:0}],sn:"setParentNode",rt:Object,p:[$n[0].BoxTree.Node]}},{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"State",t:16,rt:$n[0].NodeLayoutInfo,g:{a:2,n:"get_State",t:8,sn:"getState",rt:$n[0].NodeLayoutInfo},s:{a:1,n:"set_State",t:8,pi:[{n:"value",pt:$n[0].NodeLayoutInfo,ps:0}],sn:"setState",rt:Object,p:[$n[0].NodeLayoutInfo]}}]}});$m($n[0].Connector,function(){return{m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Segments",t:16,rt:Array,g:{a:2,n:"get_Segments",t:8,sn:"getSegments",rt:Array},s:{a:1,n:"set_Segments",t:8,pi:[{n:"value",pt:Array,ps:0}],sn:"setSegments",rt:Object,p:[Array]}}]}});$m($n[0].Diagram,function(){return{m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"VisualTree",t:16,rt:$n[0].BoxTree,g:{a:2,n:"get_VisualTree",t:8,sn:"getVisualTree",rt:$n[0].BoxTree},s:{a:2,n:"set_VisualTree",t:8,pi:[{n:"value",pt:$n[0].BoxTree,ps:0}],sn:"setVisualTree",rt:Object,p:[$n[0].BoxTree]}}]}});$m($n[0].DiagramLayoutSettings,function(){return{m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"DefaultAssistantLayoutStrategyId",t:16,rt:String,g:{a:2,n:"get_DefaultAssistantLayoutStrategyId",t:8,sn:"getDefaultAssistantLayoutStrategyId",rt:String},s:{a:2,n:"set_DefaultAssistantLayoutStrategyId",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setDefaultAssistantLayoutStrategyId",rt:Object,p:[String]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"DefaultLayoutStrategyId",t:16,rt:String,g:{a:2,n:"get_DefaultLayoutStrategyId",t:8,sn:"getDefaultLayoutStrategyId",rt:String},s:{a:2,n:"set_DefaultLayoutStrategyId",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setDefaultLayoutStrategyId",rt:Object,p:[String]}},{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"LayoutStrategies",t:16,rt:$n[2].Dictionary$2(String,OrgChart.Layout.LayoutStrategyBase),g:{a:2,n:"get_LayoutStrategies",t:8,sn:"getLayoutStrategies",rt:$n[2].Dictionary$2(String,OrgChart.Layout.LayoutStrategyBase)},s:{a:1,n:"set_LayoutStrategies",t:8,pi:[{n:"value",pt:$n[2].Dictionary$2(String,OrgChart.Layout.LayoutStrategyBase),ps:0}],sn:"setLayoutStrategies",rt:Object,p:[$n[2].Dictionary$2(String,OrgChart.Layout.LayoutStrategyBase)]}}]}});$m($n[0].Frame1,function(){return{at:[new System.Diagnostics.DebuggerDisplayAttribute("{Exterior.Left}:{Exterior.Top}, {Exterior.Size.Width}x{Exterior.Size.Height}")],m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"Connector",t:4,rt:$n[0].Connector,sn:"Connector"}]}});$m($n[0].IChartDataSource,function(){return{m:[{at:[new OrgChart.Annotations.NotNullAttribute],ab:!0,a:2,n:"AllDataItemIds",t:16,rt:$n[2].IEnumerable$1(String),g:{ab:!0,a:2,n:"get_AllDataItemIds",t:8,sn:"OrgChart$Layout$IChartDataSource$getAllDataItemIds",rt:$n[2].IEnumerable$1(String)},s:{ab:!0,a:1,n:"set_AllDataItemIds",t:8,pi:[{n:"value",pt:$n[2].IEnumerable$1(String),ps:0}],sn:"OrgChart$Layout$IChartDataSource$setAllDataItemIds",rt:Object,p:[$n[2].IEnumerable$1(String)]}},{at:[new OrgChart.Annotations.NotNullAttribute],ab:!0,a:2,n:"GetDataItemFunc",t:16,rt:Function,g:{ab:!0,a:2,n:"get_GetDataItemFunc",t:8,sn:"OrgChart$Layout$IChartDataSource$getGetDataItemFunc",rt:Function},s:{ab:!0,a:1,n:"set_GetDataItemFunc",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"OrgChart$Layout$IChartDataSource$setGetDataItemFunc",rt:Object,p:[Function]}},{at:[new OrgChart.Annotations.NotNullAttribute],ab:!0,a:2,n:"GetParentKeyFunc",t:16,rt:Function,g:{ab:!0,a:2,n:"get_GetParentKeyFunc",t:8,sn:"OrgChart$Layout$IChartDataSource$getGetParentKeyFunc",rt:Function},s:{ab:!0,a:1,n:"set_GetParentKeyFunc",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"OrgChart$Layout$IChartDataSource$setGetParentKeyFunc",rt:Object,p:[Function]}}]}});$m($n[0].LayoutState,function(){return{m:[{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"BoxSizeFunc",t:16,rt:Function,g:{a:2,n:"get_BoxSizeFunc",t:8,sn:"getBoxSizeFunc",rt:Function},s:{a:2,n:"set_BoxSizeFunc",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"setBoxSizeFunc",rt:Object,p:[Function]}},{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Diagram",t:16,rt:$n[0].Diagram,g:{a:2,n:"get_Diagram",t:8,sn:"getDiagram",rt:$n[0].Diagram},s:{a:1,n:"set_Diagram",t:8,pi:[{n:"value",pt:$n[0].Diagram,ps:0}],sn:"setDiagram",rt:Object,p:[$n[0].Diagram]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"LayoutOptimizerFunc",t:16,rt:Function,g:{a:2,n:"get_LayoutOptimizerFunc",t:8,sn:"getLayoutOptimizerFunc",rt:Function},s:{a:2,n:"set_LayoutOptimizerFunc",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"setLayoutOptimizerFunc",rt:Object,p:[Function]}},{at:[new OrgChart.Annotations.NotNullAttribute],a:1,n:"m_layoutStack",t:4,rt:$n[2].Stack$1(OrgChart.Layout.LayoutState.LayoutLevel),sn:"m_layoutStack",ro:!0},{at:[new OrgChart.Annotations.NotNullAttribute],a:1,n:"m_pooledBoundaries",t:4,rt:$n[2].Stack$1(OrgChart.Layout.Boundary),sn:"m_pooledBoundaries",ro:!0},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"BoundaryChanged",t:2,ad:{a:2,n:"add_BoundaryChanged",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"addBoundaryChanged",rt:Object,p:[Function]},r:{a:2,n:"remove_BoundaryChanged",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"removeBoundaryChanged",rt:Object,p:[Function]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"OperationChanged",t:2,ad:{a:2,n:"add_OperationChanged",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"addOperationChanged",rt:Object,p:[Function]},r:{a:2,n:"remove_OperationChanged",t:8,pi:[{n:"value",pt:Function,ps:0}],sn:"removeOperationChanged",rt:Object,p:[Function]}}]}});$m($n[0].LayoutState.LayoutLevel,function(){return{at:[new System.Diagnostics.DebuggerDisplayAttribute("{BranchRoot.Element.Id}, {Boundary.BoundingRect.Top}..{Boundary.BoundingRect.Bottom}")]}});$m($n[0].NodeLayoutInfo,function(){return{m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"RequireLayoutStrategy",t:8,sn:"RequireLayoutStrategy",rt:$n[0].LayoutStrategyBase},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"Connector",t:4,rt:$n[0].Connector,sn:"Connector"}]}});$m($n[0].Rect,function(){return{at:[new System.Diagnostics.DebuggerDisplayAttribute("{TopLeft.X}:{TopLeft.Y}, {Size.Width}x{Size.Height}")]}});$m($n[4].TestDataItem,function(){return{m:[{at:[new OrgChart.Annotations.NotNullAttribute],a:2,n:"Id",t:16,rt:String,g:{a:2,n:"get_Id",t:8,sn:"getId",rt:String},s:{a:2,n:"set_Id",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setId",rt:Object,p:[String]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"ParentId",t:16,rt:String,g:{a:2,n:"get_ParentId",t:8,sn:"getParentId",rt:String},s:{a:2,n:"set_ParentId",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setParentId",rt:Object,p:[String]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"String1",t:16,rt:String,g:{a:2,n:"get_String1",t:8,sn:"getString1",rt:String},s:{a:2,n:"set_String1",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setString1",rt:Object,p:[String]}},{at:[new OrgChart.Annotations.CanBeNullAttribute],a:2,n:"String2",t:16,rt:String,g:{a:2,n:"get_String2",t:8,sn:"getString2",rt:String},s:{a:2,n:"set_String2",t:8,pi:[{n:"value",pt:String,ps:0}],sn:"setString2",rt:Object,p:[String]}}]}})});