package com.arms.api.keycloak.user.controller;

import com.arms.api.keycloak.user.service.KeycloakUserService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

import java.util.List;

@Controller
@AllArgsConstructor
@Slf4j
public class KeycloakUserController {

    private final RealmResource realmResource;

    private final KeycloakUserService keycloakUserService;

    @GetMapping("/auth-user/search-user/{userName}")
    @ResponseBody
    public Mono<List<UserRepresentation>> getUser(
            ServerWebExchange exchange,
            @PathVariable("userName") String userName
    ) {
        log.info("userName -> " + userName);
        List<UserRepresentation> userRepresentations
                = realmResource.users().search(userName, 0, 1000, true);
        return Mono.just(userRepresentations);
    }

    @GetMapping("/auth-user/users")
    @ResponseBody
    public Mono<List<UserRepresentation>> getUsers(ServerWebExchange exchange) {
        List<UserRepresentation> userRepresentations = realmResource.users().list();
        return Mono.just(userRepresentations);
    }

    @GetMapping("/auth-user/user/{user-id}/check-permission/{current-page}")
    @ResponseBody
    public Mono<Void> ckeckPermissions(ServerWebExchange exchange,
                                        @PathVariable("user-id") String userId,
                                        @PathVariable("current-page") String currentPage) {
        Boolean ckeckPermission = keycloakUserService.ckeckPermissions(userId, currentPage);

        if (!ckeckPermission) {
            Mono<WebSession> webSessionMono = exchange.getSession();

            return webSessionMono.flatMap(session ->
                    Mono.fromRunnable(() -> {
                        ServerHttpResponse httpResponse = exchange.getResponse();
                        httpResponse.setStatusCode(HttpStatus.FORBIDDEN);
                    })
                    .then(exchange.getResponse().setComplete())
            );
        }

        return Mono.empty();
    }
}
