/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.schedule.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ScheduleTaskDispatcher
implements CommandLineRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTaskDispatcher.class);
    private ApplicationContext applicationContext;
    private final Map<String, Runnable> feignClientTaskMap = new HashMap();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Runnable getTask(String name) {
        Runnable task = (Runnable)this.feignClientTaskMap.get(name);
        if (task == null) {
            log.warn("ScheduleTaskDispatcher :: No task found for this (schedule or method) name : {}", (Object)name);
            throw new IllegalArgumentException("ScheduleTaskDispatcher :: No task found for name: " + name);
        }
        return task;
    }

    public boolean contains(String name) {
        return this.feignClientTaskMap.containsKey(name);
    }

    public void run(String ... args) throws Exception {
        Map feignClientBeans = this.applicationContext.getBeansWithAnnotation(FeignClient.class);
        for (Map.Entry entry : feignClientBeans.entrySet()) {
            Object feignClientProxy = entry.getValue();
            Class<?>[] interfaces = feignClientProxy.getClass().getInterfaces();
            Class feignClientInterface = Arrays.stream(interfaces).filter(iface -> iface.isAnnotationPresent(FeignClient.class)).findFirst().orElse(null);
            if (feignClientInterface == null) {
                log.error("Could not find FeignClient interface for bean : {}", entry.getKey());
                continue;
            }
            for (Method method : feignClientInterface.getDeclaredMethods()) {
                if (Modifier.isPublic(method.getModifiers()) && method.getParameters().length == 0) {
                    String key = method.getName();
                    Runnable task = () -> {
                        block4: {
                            try {
                                log.info("  Executing Feign Client Method: {} (no parameters)", (Object)key);
                                Object result = method.invoke(feignClientProxy, new Object[0]);
                                if (method.getReturnType() == Void.TYPE) {
                                    log.info("  Method {} executed (void return type).", (Object)key);
                                } else {
                                    log.info("  Method {} executed. Result: {}", (Object)key, result);
                                }
                            }
                            catch (Exception e) {
                                log.error(" Error executing Feign Client Method {} : {}", (Object)key, (Object)e.getMessage());
                                if (e.getCause() == null) break block4;
                                log.error("  Caused by: {} : {}", (Object)e.getCause().getClass().getSimpleName(), (Object)e.getCause().getMessage());
                            }
                        }
                    };
                    this.feignClientTaskMap.put(key, task);
                    log.info("  Added task:  {}", (Object)key);
                    continue;
                }
                log.info("  Skipping method (has parameters or not public):  {}", (Object)method.getName());
            }
        }
    }
}

