package com.arms.egovframework.javaservice.esframework.model.dto.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import lombok.*;

@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class AggregationRequestDTO {

	private List<SubGroupFieldDTO> subGroupFieldDTOS = new ArrayList<>();

	private String mainField;

	private String mainFieldAlias;

	private boolean isContentView;

	private boolean isAscending;

	private int size = 10000;

	public static SubGroupDTOBuilder builder() {
		return new SubGroupDTOBuilder();
	}

	public static class SubGroupDTOBuilder {
		private String mainField;
		private String mainFieldAlias;
		private boolean isContentView = false;
		private boolean isAscending = false;
		private int size = 10000;
		private List<SubGroupFieldDTO> subGroupFieldDTOS = new ArrayList<>();

		public SubGroupDTOBuilder mainField(String mainField) {
			this.mainField = mainField;
			return this;
		}

		public SubGroupDTOBuilder mainFieldAlias(String mainFieldAlias) {
			this.mainFieldAlias = mainFieldAlias;
			return this;
		}

		public SubGroupDTOBuilder isContentView(boolean isContentView) {
			this.isContentView = isContentView;
			return this;
		}

		public SubGroupDTOBuilder isAscending(boolean isAscending) {
			this.isAscending = isAscending;
			return this;
		}

		public SubGroupDTOBuilder size(int size) {
			this.size = size;
			return this;
		}

		public SubGroupDTOBuilder subGroupFieldDTOS(List<SubGroupFieldDTO> subGroupFieldDTOS) {
			this.subGroupFieldDTOS = subGroupFieldDTOS;
			return this;
		}

		public SubGroupDTOBuilder addGroup(SubGroupFieldDTO... fields) {
			if (this.subGroupFieldDTOS == null) {
				this.subGroupFieldDTOS = new ArrayList<>();
			}
			this.subGroupFieldDTOS.addAll(Arrays.asList(fields));
			return this;
		}

		public AggregationRequestDTO build() {
			AggregationRequestDTO dto = new AggregationRequestDTO();
			dto.setMainField(this.mainField);
			dto.setMainFieldAlias(this.mainFieldAlias);
			dto.setContentView(this.isContentView);
			dto.setAscending(this.isAscending);
			dto.setSize(this.size);
			dto.setSubGroupFieldDTOS(this.subGroupFieldDTOS);
			return dto;
		}
	}
}
