package com.arms.api.newsletter.controller;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.newsletter.model.NewsletterVO;
import com.arms.api.newsletter.service.NewsletterService;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/engine/newsletter")
@Slf4j
@AllArgsConstructor
public class NewsletterController {

    private final NewsletterService newsletterService;

    @PostMapping("/addNewsletter")
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> addNewsletter(@RequestBody NewsletterDTO newsletterDTO) {
        log.info("NewsletterController :: addNewsletter");

        return ResponseEntity.ok(CommonResponse.success(newsletterService.addNewsletter(newsletterDTO)));
    }

    @GetMapping("/{newsletterId}")
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> getNewsletter(@PathVariable("newsletterId") String newsletterId) {
        log.info("NewsletterController :: getNewsletter");

        return ResponseEntity.ok(CommonResponse.success(newsletterService.getNewsletter(newsletterId)));
    }

    @PutMapping("/updateNewsletter")
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>>  updateNewsletter(@RequestBody NewsletterDTO newsletterDTO) {
        log.info("NewsletterController :: updateNewsletter");

        return ResponseEntity.ok(CommonResponse.success(newsletterService.updateNewsletter(newsletterDTO)));
    }

    @DeleteMapping("/{newsletterId}")
    public ResponseEntity<CommonResponse.ApiResult<NewsletterVO>> deleteNewsletter(@PathVariable("newsletterId") String newsletterId) {
        log.info("NewsletterController :: deleteNewsletter");

        return ResponseEntity.ok(CommonResponse.success(newsletterService.deleteNewsletter(newsletterId)));
    }

}
