package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.User;
import lombok.*;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
@Slf4j
@EqualsAndHashCode(of = {"issue"})
public class OnPremissRedmineIssueVO {

    private Issue issue;

    private User user;

    private ServerInfo serverInfo;

    private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;

    private boolean excludeFromSave;

    private List<Long> linkedIssuePdServiceIds;

    private List<Long> linkedIssuePdServiceVersions;

    public OnPremissRedmineIssueVO markAsExcludedFromSave(){
        return OnPremissRedmineIssueVO.builder()
                .issue(this.issue)
                .user(this.user)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(this.almIssueWithRequirementDTO)
                .excludeFromSave(true)
                .build();
    }

    public OnPremissRedmineIssueVO appliedLinkedIssuePdServiceElement(List<AlmIssueWithRequirementDTO> almIssueWithRequirementDTOS){
        return OnPremissRedmineIssueVO.builder()
                .issue(this.issue)
                .user(this.user)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(
                        almIssueWithRequirementDTOS
                                .stream()
                                .filter(a->a.getIssueKey().equals(String.valueOf(issue.getId())))
                                .findFirst()
                                .orElseGet(()->this.almIssueWithRequirementDTO)
                )
                .linkedIssuePdServiceIds(almIssueWithRequirementDTOS.stream().map(AlmIssueWithRequirementDTO::getServiceId).toList())
                .linkedIssuePdServiceVersions(almIssueWithRequirementDTOS.stream().flatMap(a->a.getVersions().stream()).toList())
                .excludeFromSave(this.excludeFromSave)
                .build();
    }

    public String recentId(){
        return this.serverInfo.getConnectId() +"_"+issue.getProjectId()+"_"+issue.getId();
    }

    public String recentId(String id){
        return this.serverInfo.getConnectId() +"_"+issue.getProjectId()+"_"+id;
    }


    public Set<String> relationRecentIds(){

        List<IssueRelation> issueRelations = new ArrayList<>(this.issue.getRelations());

        Integer issueId = issue.getId();

        return issueRelations.stream().map(a->{
            if(issueId.equals(a.getIssueId())){
                return almIssueWithRequirementDTO.extractIssueKeyFromMainKey(String.valueOf(a.getIssueToId()));
            }else{
                return almIssueWithRequirementDTO.extractIssueKeyFromMainKey(String.valueOf(a.getIssueId()));
            }
        }).collect(Collectors.toSet());

    }


}
