package com.arms.api.analysis.cost.controller;

import com.arms.api.analysis.cost.model.dto.CostAggrDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.dto.CostRequestDTO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CostVO;
import com.arms.api.analysis.cost.service.AnalysisCost;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/engine/analysis-cost")
@Slf4j
@AllArgsConstructor
public class AnalysisCostController {

    private final AnalysisCost analysisCost;

    @PostMapping("/assignee-list")
    public ResponseEntity<List<CostVO>> getAssigneeList(@RequestBody CostAggrDTO costAggrDTO) {

        log.info("AnalysisCostController :: getAssigneeList");

        return ResponseEntity.ok(analysisCost.getAssigneeList(costAggrDTO));
    }

    @PostMapping("/version-requirement/assignee-list")
    public ResponseEntity<List<CostVO>> getAssigneeListByProductVersionAndRequirement(@RequestBody CostAggrDTO costAggrDTO) {

        log.info("AnalysisCostController :: getAssigneeListByProductVersionAndRequirement");

        return ResponseEntity.ok(analysisCost.getAssigneeListByProductVersionAndRequirement(costAggrDTO));
    }

    // 캔들스틱에서 사용
    @PostMapping("/aggregation/assignee-account-id")
    public ResponseEntity<List<CostVO>> aggregationByAssigneeAccountId(@RequestBody CostAggrDTO costAggrDTO) {

        log.info("AnalysisCostController :: aggregationByAssigneeAccountId");

        return ResponseEntity.ok(analysisCost.aggregationByAssigneeAccountId(costAggrDTO));
    }

    // 캔들스틱 사용
    @PostMapping("/aggregation/assignee-account-id-and-req-link")
    public ResponseEntity<List<CostVO>> aggregationByReqLinkAndAssigneeAccountId(@RequestBody CostAggrDTO costAggrDTO) {

        log.info("AnalysisCostController :: aggregationByReqLinkAndAssigneeAccountId");

        return ResponseEntity.ok(analysisCost.aggregationByReqLinkAndAssigneeAccountId(costAggrDTO));
    }

    @PostMapping("/calculateWorkdayByAccountId")
    public ResponseEntity<List<AssigneeTimeDiffVO>> calculateWorkdayByAccountId(@RequestBody CostRequestDTO costRequestDTO) {

        log.info("AnalysisCostController :: calculateWorkdayByAccountId");

        return ResponseEntity.ok(analysisCost.calculateWorkdayByAccountId(costRequestDTO));
    }

    @PostMapping("/calculation-cost")
    public ResponseEntity<?> calculationCost(@RequestBody CostDTO costDTO) {

        log.info("AnalysisCostController :: calculationCost");

        return ResponseEntity.ok(analysisCost.calculationCost(costDTO));
    }
}
