package com.arms.api.wiki.model;

import com.arms.egovframework.javaservice.esframework.annotation.*;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;
import java.util.List;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@Document(indexName = "wiki")
@ElasticSearchTemplateConfig
@ElasticSearchIndex
public class WikiEntity implements BaseEntity {

    @Id
    @ReadOnlyProperty
    private String id;

    @RecentId
    @JsonProperty("wiki_id")
    @Field(type = FieldType.Keyword, name = "wiki_id")
    private String wikiId;

    @Recent
    @Field(type = FieldType.Boolean, name = "recent")
    private boolean recent;

    @Field(type = FieldType.Text, name = "contents")
    private String contents;

    @Field(type = FieldType.Keyword, name = "version")
    private Long version;

    @Field(type = FieldType.Text, name = "diagram_xmls")
    private List<String> diagramXmls;

    @Field(type = FieldType.Keyword, name = "product_service_id")
    private String pdServiceId;

    @Field(type = FieldType.Keyword, name = "author")
    private String author;

    @Field(type = FieldType.Date, name = "created_date")
    @ElasticSearchCreatedDate
    @Setter
    private Date createdDate;

    @Field(type = FieldType.Date, name = "updated_date")
    @ElasticSearchUpdateDate
    @Setter
    private Date updatedDate;

    public void updateWikiEntity(WikiEntity wikiEntity) {
        if (wikiEntity.contents != null) {
            this.contents = wikiEntity.contents;
        }

        if (wikiEntity.diagramXmls != null) {
            this.diagramXmls = wikiEntity.diagramXmls;
        }

        if(wikiEntity.version != null) {
            this.version = wikiEntity.version;
        }

        if (wikiEntity.pdServiceId != null) {
            this.pdServiceId = wikiEntity.pdServiceId;
        }
    }

    public String generateIdWithVersion() {
        return this.id + "_" + this.version;
    }
}
