package com.arms.api.issue.almapi.strategy;

import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;

import java.util.List;
import java.util.Map;

public interface IssueStrategy {

    AlmIssueVO createIssue(AlmIssueDTO almIssueDTO);

    Map<String,Object> updateIssue(AlmIssueDTO almIssueDTO);

    Map<String, Object> updateIssueStatus(AlmIssueDTO almIssueDTO);

    Map<String,Object> deleteIssue(AlmIssueDTO almIssueDTO);

    AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO) ;

    boolean isExistIssue(AlmIssueDTO almIssueDTO) ;

    List<AlmIssueEntity> discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO);

    default void cloudJiraTestApiRequest(){
        throw new UnsupportedOperationException("Not supported.");
    }
}
