/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.model;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchIndex;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.annotation.RecentId;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="wiki")
@ElasticSearchTemplateConfig
@ElasticSearchIndex
public class WikiEntity
implements BaseEntity {
    @Id
    @ReadOnlyProperty
    private String id;
    @RecentId
    @JsonProperty(value="wiki_id")
    @Field(type=FieldType.Keyword, name="wiki_id")
    private String wikiId;
    @Recent
    @Field(type=FieldType.Boolean, name="recent")
    private boolean recent;
    @Field(type=FieldType.Text, name="contents")
    private String contents;
    @Field(type=FieldType.Keyword, name="version")
    private Long version;
    @Field(type=FieldType.Text, name="diagram_xmls")
    private List<String> diagramXmls;
    @Field(type=FieldType.Keyword, name="product_service_id")
    private String pdServiceId;
    @Field(type=FieldType.Keyword, name="author")
    private String author;
    @Field(type=FieldType.Date, name="created_date")
    @ElasticSearchCreatedDate
    private Date createdDate;
    @Field(type=FieldType.Date, name="updated_date")
    @ElasticSearchUpdateDate
    private Date updatedDate;

    public void updateWikiEntity(WikiEntity wikiEntity) {
        if (wikiEntity.contents != null) {
            this.contents = wikiEntity.contents;
        }
        if (wikiEntity.diagramXmls != null) {
            this.diagramXmls = wikiEntity.diagramXmls;
        }
        if (wikiEntity.version != null) {
            this.version = wikiEntity.version;
        }
        if (wikiEntity.pdServiceId != null) {
            this.pdServiceId = wikiEntity.pdServiceId;
        }
    }

    public String generateIdWithVersion() {
        return this.id + "_" + this.version;
    }

    @Generated
    public static WikiEntityBuilder builder() {
        return new WikiEntityBuilder();
    }

    @Generated
    public WikiEntity() {
    }

    @Generated
    public WikiEntity(String id, String wikiId, boolean recent, String contents, Long version, List<String> diagramXmls, String pdServiceId, String author, Date createdDate, Date updatedDate) {
        this.id = id;
        this.wikiId = wikiId;
        this.recent = recent;
        this.contents = contents;
        this.version = version;
        this.diagramXmls = diagramXmls;
        this.pdServiceId = pdServiceId;
        this.author = author;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getWikiId() {
        return this.wikiId;
    }

    @Generated
    public boolean isRecent() {
        return this.recent;
    }

    @Generated
    public String getContents() {
        return this.contents;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public List<String> getDiagramXmls() {
        return this.diagramXmls;
    }

    @Generated
    public String getPdServiceId() {
        return this.pdServiceId;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setWikiId(String wikiId) {
        this.wikiId = wikiId;
    }

    @Generated
    public void setRecent(boolean recent) {
        this.recent = recent;
    }

    @Generated
    public void setContents(String contents) {
        this.contents = contents;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setDiagramXmls(List<String> diagramXmls) {
        this.diagramXmls = diagramXmls;
    }

    @Generated
    public void setPdServiceId(String pdServiceId) {
        this.pdServiceId = pdServiceId;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Generated
    public static class WikiEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String wikiId;
        @Generated
        private boolean recent;
        @Generated
        private String contents;
        @Generated
        private Long version;
        @Generated
        private List<String> diagramXmls;
        @Generated
        private String pdServiceId;
        @Generated
        private String author;
        @Generated
        private Date createdDate;
        @Generated
        private Date updatedDate;

        @Generated
        WikiEntityBuilder() {
        }

        @Generated
        public WikiEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="wiki_id")
        @Generated
        public WikiEntityBuilder wikiId(String wikiId) {
            this.wikiId = wikiId;
            return this;
        }

        @Generated
        public WikiEntityBuilder recent(boolean recent) {
            this.recent = recent;
            return this;
        }

        @Generated
        public WikiEntityBuilder contents(String contents) {
            this.contents = contents;
            return this;
        }

        @Generated
        public WikiEntityBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public WikiEntityBuilder diagramXmls(List<String> diagramXmls) {
            this.diagramXmls = diagramXmls;
            return this;
        }

        @Generated
        public WikiEntityBuilder pdServiceId(String pdServiceId) {
            this.pdServiceId = pdServiceId;
            return this;
        }

        @Generated
        public WikiEntityBuilder author(String author) {
            this.author = author;
            return this;
        }

        @Generated
        public WikiEntityBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Generated
        public WikiEntityBuilder updatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        @Generated
        public WikiEntity build() {
            return new WikiEntity(this.id, this.wikiId, this.recent, this.contents, this.version, this.diagramXmls, this.pdServiceId, this.author, this.createdDate, this.updatedDate);
        }

        @Generated
        public String toString() {
            return "WikiEntity.WikiEntityBuilder(id=" + this.id + ", wikiId=" + this.wikiId + ", recent=" + this.recent + ", contents=" + this.contents + ", version=" + this.version + ", diagramXmls=" + String.valueOf(this.diagramXmls) + ", pdServiceId=" + this.pdServiceId + ", author=" + this.author + ", createdDate=" + String.valueOf(this.createdDate) + ", updatedDate=" + String.valueOf(this.updatedDate) + ")";
        }
    }
}

