/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util;

import java.util.regex.Pattern;
import org.springframework.util.ObjectUtils;

public class ParseUtil {
    public static String extractUsernameFromEmail(String emailAddress) {
        String EMAIL_REGEX = "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$";
        if (emailAddress == null || !Pattern.matches(EMAIL_REGEX, emailAddress)) {
            return null;
        }
        int atIndex = emailAddress.indexOf(64);
        if (atIndex > 0) {
            return emailAddress.substring(0, atIndex);
        }
        return null;
    }

    public static String getLastSegment(String ids) {
        if (ObjectUtils.isEmpty((Object)ids)) {
            return null;
        }
        String[] parts = ids.split("_");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return ids;
    }

    public static String getPrefixIncludingLastDelimiter(String ids) {
        if (ObjectUtils.isEmpty((Object)ids)) {
            return ids;
        }
        int lastIndex = ids.lastIndexOf(95);
        if (lastIndex == -1) {
            return ids;
        }
        return ids.substring(0, lastIndex + 1);
    }

    public static String timeFormat(int \ubd84) {
        int \uc8fc = \ubd84 / 2400;
        int \uc77c = \ubd84 % 2400 / 480;
        int \uc2dc\uac04 = \ubd84 % 480 / 60;
        int \ub0a8\uc740\uc2dc\uac04 = \ubd84 % 60;
        StringBuilder \ud3ec\ub9f7\ud305 = new StringBuilder();
        if (\uc8fc > 0) {
            \ud3ec\ub9f7\ud305.append(\uc8fc).append("w ");
        }
        if (\uc77c > 0) {
            \ud3ec\ub9f7\ud305.append(\uc77c).append("d ");
        }
        if (\uc2dc\uac04 > 0) {
            \ud3ec\ub9f7\ud305.append(\uc2dc\uac04).append("h ");
        }
        if (\ub0a8\uc740\uc2dc\uac04 > 0 || \uc8fc == 0 && \uc77c == 0 && \uc2dc\uac04 == 0) {
            \ud3ec\ub9f7\ud305.append(\ub0a8\uc740\uc2dc\uac04).append("m ");
        }
        return \ud3ec\ub9f7\ud305.toString().trim();
    }
}

