/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.serverinfo.service;

import com.arms.api.issue.almapi.msa_communicate.BackendJiraServer;
import com.arms.api.serverinfo.model.JiraServerPureEntity;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.ServerInfoEntity;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.UUIDUtil;
import com.arms.api.util.aes.AES256Decryption;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.errors.ErrorCode;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="serverInfo_\uc11c\ube44\uc2a4")
public class ServerInfoServiceImpl
implements ServerInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerInfoServiceImpl.class);
    private final EsCommonRepositoryWrapper<ServerInfoEntity> esCommonRepositoryWrapper;
    private final ModelMapper modelMapper;
    private final BackendJiraServer backendJiraServer;
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final AES256Decryption aes256Decryption;

    @Override
    public String getDecryptPasswordOrToken(ServerInfo serverInfo) {
        return this.aes256Decryption.decrypt(serverInfo.getPasswordOrToken());
    }

    @Override
    public ServerInfoEntity saveOrUpdateServerInfo(ServerInfo serverInfo) {
        ServerInfoEntity result;
        ServerInfoEntity serverInfoEntity = (ServerInfoEntity)this.modelMapper.map((Object)serverInfo, ServerInfoEntity.class);
        try {
            result = this.esCommonRepositoryWrapper.save(serverInfoEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public List<ServerInfo> serverInfoListByConnectIds(List<String> connectIds) {
        return connectIds.stream().map(this.esCommonRepositoryWrapper::findDocById).filter(Objects::nonNull).map(serverInfoEntity -> {
            ServerInfo serverInfo = (ServerInfo)this.modelMapper.map(serverInfoEntity, ServerInfo.class);
            serverInfo.setUserId("");
            serverInfo.setPasswordOrToken("");
            return serverInfo;
        }).collect(Collectors.toList());
    }

    @Override
    @Async
    @DwrSendAlarm(messageOnStart="serverInfo \ubc31\uc5c5 \uc2dc\uc791", messageOnEnd="serverInfo \ubc31\uc5c5 \uc885\ub8cc")
    @SlackSendAlarm(messageOnStart="serverInfo \ubc31\uc5c5 \uc2dc\uc791", messageOnEnd="serverInfo \ubc31\uc5c5 \uc885\ub8cc")
    public void serverInfoBackup() {
        String logMessagePrefix = "[ ServerInfoServiceImpl :: serverInfoBackup ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, startTime.format(this.timeFormatter)});
        ResponseEntity<List<JiraServerPureEntity>> response = this.backendJiraServer.getJiraServerMonitor();
        List serverInfoList = (List)response.getBody();
        Optional.ofNullable(serverInfoList).orElseGet(Collections::emptyList).forEach(serverInfo -> {
            ServerInfoEntity serverInfoEntity = Optional.ofNullable(this.esCommonRepositoryWrapper.findDocById(serverInfo.getC_jira_server_etc())).orElseGet(ServerInfoEntity::new);
            serverInfoEntity.setUri(serverInfo.getC_jira_server_base_url());
            serverInfoEntity.setType(serverInfo.getC_jira_server_type());
            serverInfoEntity.setUserId(serverInfo.getC_jira_server_connect_id());
            serverInfoEntity.setPasswordOrToken(serverInfo.getC_jira_server_connect_pw());
            serverInfoEntity.setConnectId(serverInfo.getC_jira_server_etc());
            this.esCommonRepositoryWrapper.save(serverInfoEntity);
        });
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    @Override
    public void deleteServerInfo(String serverId) {
        this.esCommonRepositoryWrapper.deleteById(serverId);
    }

    @Override
    public ServerInfo verifyServerInfo(String serverId) {
        if (serverId == null) {
            log.error("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \uc0c1\uc138\uc815\ubcf4 \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        ServerInfo serverInfo = this.getServerInfo(serverId);
        if (serverInfo == null) {
            log.error("\ub4f1\ub85d\ub41c \uc11c\ubc84 \uc815\ubcf4\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
            throw new IllegalArgumentException(ErrorCode.SERVER_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (serverInfo.getUri() == null || serverInfo.getUri().isEmpty()) {
            throw new IllegalArgumentException(ErrorCode.SERVER_URI_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (serverInfo.getUserId() == null || serverInfo.getUserId().isEmpty()) {
            log.error("\uc0ac\uc6a9\uc790 \uc544\uc774\ub514 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException(ErrorCode.SERVER_ID_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        String decryptPasswordOrToken = this.getDecryptPasswordOrToken(serverInfo);
        if (decryptPasswordOrToken == null || decryptPasswordOrToken.isEmpty()) {
            log.info("\ube44\ubc00 \ubc88\ud638 \ubc0f \ud1a0\ud070 \uc815\ubcf4 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException(ErrorCode.SERVER_PW_OR_API_TOKEN_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        return serverInfo;
    }

    private ServerInfo getServerInfo(String serverId) {
        ServerInfoEntity serverInfoEntity = this.esCommonRepositoryWrapper.findDocById(serverId);
        return (ServerInfo)this.modelMapper.map((Object)serverInfoEntity, ServerInfo.class);
    }

    @Override
    public Map<String, String> getServerIdToTypeMap() {
        return this.esCommonRepositoryWrapper.findAllHits().toDocs().stream().collect(Collectors.toMap(ServerInfoEntity::getConnectId, ServerInfoEntity::getType));
    }

    @Generated
    public ServerInfoServiceImpl(EsCommonRepositoryWrapper<ServerInfoEntity> esCommonRepositoryWrapper, ModelMapper modelMapper, BackendJiraServer backendJiraServer, AES256Decryption aes256Decryption) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.modelMapper = modelMapper;
        this.backendJiraServer = backendJiraServer;
        this.aes256Decryption = aes256Decryption;
    }
}

