/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.newsletter.service;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.newsletter.model.NewsletterVO;
import com.arms.api.newsletter.service.NewsletterService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class NewsletterServiceImpl
implements NewsletterService {
    private final EsCommonRepositoryWrapper<NewsletterEntity> esCommonRepositoryWrapper;

    @Override
    public NewsletterVO addNewsletter(NewsletterDTO newsletterDTO) {
        NewsletterEntity newsletterEntity = this.esCommonRepositoryWrapper.save(newsletterDTO.createEntity());
        return NewsletterVO.builder().id(newsletterEntity.getId()).contents(newsletterEntity.getContents()).build();
    }

    @Override
    public NewsletterVO getNewsletter(String newsletterId) {
        NewsletterEntity newsletterEntity = this.esCommonRepositoryWrapper.findDocById(newsletterId);
        return NewsletterVO.builder().id(newsletterEntity.getId()).contents(newsletterEntity.getContents()).build();
    }

    @Override
    public NewsletterVO updateNewsletter(NewsletterDTO newsletterDTO) {
        String newsletterId = newsletterDTO.getId();
        NewsletterEntity newsletterEntity = this.esCommonRepositoryWrapper.findDocById(newsletterId);
        if (newsletterEntity == null) {
            throw new IllegalArgumentException("\ub274\uc2a4\ub808\ud130\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        newsletterEntity.updateNewsletterEntity(newsletterDTO.createEntity());
        NewsletterEntity savedEntity = this.esCommonRepositoryWrapper.save(newsletterEntity);
        return NewsletterVO.builder().id(savedEntity.getId()).contents(savedEntity.getContents()).build();
    }

    @Override
    public NewsletterVO deleteNewsletter(String newsletterId) {
        NewsletterEntity newsletterEntity = this.esCommonRepositoryWrapper.findDocById(newsletterId);
        if (newsletterEntity == null) {
            throw new IllegalArgumentException("\ub274\uc2a4\ub808\ud130\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        List<NewsletterEntity> docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("id", newsletterEntity.getId())).toDocs();
        for (NewsletterEntity doc : docs) {
            this.esCommonRepositoryWrapper.deleteById(doc.getId());
        }
        return NewsletterVO.builder().id(newsletterEntity.getId()).contents(newsletterEntity.getContents()).build();
    }

    @Generated
    public NewsletterServiceImpl(EsCommonRepositoryWrapper<NewsletterEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

