/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.type.strategy;

import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.issue.type.strategy.IssueTypeStrategy;
import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraIssueTypeStrategy
implements IssueTypeStrategy {
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final ServerInfoService serverInfoService;

    @Override
    public List<IssueTypeVO> getIssueTypeList(ServerInfo serverInfo) {
        String endpoint = this.jiraApi.getEndpoint().getIssue().getIssuetype();
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List issueTypeList = (List)this.jiraUtil.get(webClient, endpoint, new ParameterizedTypeReference<List<IssueTypeDTO>>(this){}).block();
            return Optional.ofNullable(issueTypeList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(this::convertIssueTypeVO).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), String.format("%s[%s] :: getIssueTypeList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public List<IssueTypeVO> getIssueTypeListByProject(ServerInfo serverInfo, String projectId) {
        String endpoint = this.jiraApi.getEndpoint().getIssue().getIssuetype() + "/project?projectId=" + projectId;
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List issueTypeList = (List)this.jiraUtil.get(webClient, endpoint, new ParameterizedTypeReference<List<IssueTypeDTO>>(this){}).block();
            return Optional.ofNullable(issueTypeList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(this::convertIssueTypeVO).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), String.format("%s[%s] :: getIssueTypeListByProject Error :: projectId[%s]", serverInfo.getType(), serverInfo.getUri(), projectId));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private IssueTypeVO convertIssueTypeVO(IssueTypeDTO issueTypeDTO) {
        return IssueTypeVO.builder().self(issueTypeDTO.getSelf()).id(issueTypeDTO.getId()).description(issueTypeDTO.getDescription()).name(issueTypeDTO.getName()).subtask(issueTypeDTO.getSubtask()).untranslatedName(issueTypeDTO.getUntranslatedName()).hierarchyLevel(issueTypeDTO.getHierarchyLevel()).build();
    }

    @Generated
    public CloudJiraIssueTypeStrategy(JiraUtil jiraUtil, JiraApi jiraApi, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.serverInfoService = serverInfoService;
    }
}

