/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.status.service;

import com.arms.api.issue.status.strategy.CloudJiraIssueStatusStrategy;
import com.arms.api.issue.status.strategy.IssueStatusStrategy;
import com.arms.api.issue.status.strategy.IssueStatusStrategyFactory;
import com.arms.api.issue.status.strategy.OnPremiseJiraIssueStatusStrategy;
import com.arms.api.issue.status.strategy.OnPremiseRedmineIssueStatusStrategy;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IssueStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueStatusService.class);
    private final ServerInfoService ServerInfoService;
    private final CloudJiraIssueStatusStrategy cloudJiraIssueStatusStrategy;
    private final OnPremiseJiraIssueStatusStrategy onPremiseJiraIssueStatusStrategy;
    private final OnPremiseRedmineIssueStatusStrategy onPremiseRedmineIssueStatusStrategy;

    private IssueStatusStrategyFactory settingIssueStatusStrategy(ServerInfo serverInfo) {
        IssueStatusStrategy issueStatusStrategy;
        if (serverInfo == null || StringUtils.isEmpty((CharSequence)serverInfo.getType())) {
            log.error("\uc9c0\ub77c\uc774\uc288 \uc0c1\ud0dc \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc9c0\ub77c\uc774\uc288 \uc0c1\ud0dc \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            issueStatusStrategy = this.cloudJiraIssueStatusStrategy;
        } else if (serverType == ServerType.ON_PREMISS) {
            issueStatusStrategy = this.onPremiseJiraIssueStatusStrategy;
        } else if (serverType == ServerType.REDMINE_ON_PREMISS) {
            issueStatusStrategy = this.onPremiseRedmineIssueStatusStrategy;
        } else {
            throw new IllegalArgumentException("\uc774\uc288\uc0c1\ud0dc \uc804\ub7b5 \ud655\uc778 Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo_\uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf((Object)serverType) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        IssueStatusStrategyFactory issueStatusStrategyFactory = new IssueStatusStrategyFactory();
        issueStatusStrategyFactory.registerIssueStatusStrategy(issueStatusStrategy);
        return issueStatusStrategyFactory;
    }

    public List<IssueStatusVO> getIssueStatusList(String connectId) {
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(connectId);
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            log.error("\uc9c0\ub77c \ud074\ub77c\uc6b0\ub4dc \ud0c0\uc785[{}] \uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d_\uac00\uc838\uc624\uae30\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", (Object)connectId);
            throw new IllegalArgumentException("\ud074\ub77c\uc6b0\ub4dc \ud0c0\uc785\uc740 \uc774\uc288 \uc0c1\ud0dc \ubaa9\ub85d \uac00\uc838\uc624\uae30\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueStatusStrategyFactory issueStatusStrategy = this.settingIssueStatusStrategy(serverInfo);
        List<IssueStatusVO> issueStatusList = issueStatusStrategy.getIssueStatusList(serverInfo);
        return issueStatusList;
    }

    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(String connectId, String projectId) {
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(connectId);
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.ON_PREMISS) {
            log.error("\uc9c0\ub77c \uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785[{}] getIssueStatusListByProject \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", (Object)connectId);
            throw new IllegalArgumentException("\uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785\uc740 getIssueStatusListByProject \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (serverType == ServerType.REDMINE_ON_PREMISS) {
            log.error("\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288\uc0c1\ud0dc_\uc804\ub7b5 {} getIssueStatusListByProject \uc0ac\uc6a9\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", (Object)connectId);
            throw new IllegalArgumentException("\ub808\ub4dc\ub9c8\uc778 \uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785\uc740 getIssueStatusListByProject \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueStatusStrategyFactory issueStatusStrategy = this.settingIssueStatusStrategy(serverInfo);
        List<CloudJiraByIssueTypeIssueStatusVO> issueStatusList = issueStatusStrategy.getIssueStatusListByProject(serverInfo, projectId);
        return issueStatusList;
    }

    @Generated
    public IssueStatusService(ServerInfoService ServerInfoService2, CloudJiraIssueStatusStrategy cloudJiraIssueStatusStrategy, OnPremiseJiraIssueStatusStrategy onPremiseJiraIssueStatusStrategy, OnPremiseRedmineIssueStatusStrategy onPremiseRedmineIssueStatusStrategy) {
        this.ServerInfoService = ServerInfoService2;
        this.cloudJiraIssueStatusStrategy = cloudJiraIssueStatusStrategy;
        this.onPremiseJiraIssueStatusStrategy = onPremiseJiraIssueStatusStrategy;
        this.onPremiseRedmineIssueStatusStrategy = onPremiseRedmineIssueStatusStrategy;
    }
}

