/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.priority.strategy;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.strategy.IssuePriorityStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Priority;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OnpremiseJiraIssuePriorityStrategy
implements IssuePriorityStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnpremiseJiraIssuePriorityStrategy.class);
    private final JiraUtil jiraUtil;
    private final ServerInfoService serverInfoService;

    @Override
    public List<IssuePriorityDTO> getIssuePriorityList(ServerInfo serverInfo) {
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        Iterable jiraPriorityList = (Iterable)restClient.getMetadataClient().getPriorities().claim();
        if (jiraPriorityList == null) {
            log.error("{}({}) \uc11c\ubc84\uc5d0 \uc124\uc815\ub41c \uc774\uc288 \uc6b0\uc120\uc21c\uc704\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.", (Object)serverInfo.getType(), (Object)serverInfo.getUri());
            return Collections.emptyList();
        }
        return StreamSupport.stream(jiraPriorityList.spliterator(), false).map(this::convertIssuePriorityDTO).collect(Collectors.toList());
    }

    private IssuePriorityDTO convertIssuePriorityDTO(Priority priority) {
        IssuePriorityDTO issuePriorityDTO = new IssuePriorityDTO();
        issuePriorityDTO.setSelf(String.valueOf(priority.getSelf()));
        issuePriorityDTO.setId(String.valueOf(priority.getId()));
        issuePriorityDTO.setName(priority.getName());
        issuePriorityDTO.setDescription(priority.getDescription());
        return issuePriorityDTO;
    }

    @Generated
    public OnpremiseJiraIssuePriorityStrategy(JiraUtil jiraUtil, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.serverInfoService = serverInfoService;
    }
}

