/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.util.StreamUtil;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremissJiraIssueVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremissJiraIssueVO.class);
    private Issue issue;
    private ServerInfo serverInfo;
    private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;
    private boolean excludeFromSave;
    private List<Long> linkedIssuePdServiceIds;
    private List<Long> linkedIssuePdServiceVersions;

    public OnPremissJiraIssueVO markAsExcludedFromSave() {
        return OnPremissJiraIssueVO.builder().issue(this.issue).serverInfo(this.serverInfo).almIssueWithRequirementDTO(this.almIssueWithRequirementDTO).excludeFromSave(true).build();
    }

    public OnPremissJiraIssueVO appliedLinkedIssuePdServiceElement(List<AlmIssueWithRequirementDTO> almIssueWithRequirementDTOS) {
        return OnPremissJiraIssueVO.builder().issue(this.issue).serverInfo(this.serverInfo).almIssueWithRequirementDTO(almIssueWithRequirementDTOS.stream().filter(a -> a.getIssueKey().equals(this.issue.getKey())).findFirst().orElseGet(() -> this.almIssueWithRequirementDTO)).linkedIssuePdServiceIds(almIssueWithRequirementDTOS.stream().map(AlmIssueWithRequirementDTO::getServiceId).toList()).linkedIssuePdServiceVersions(almIssueWithRequirementDTOS.stream().flatMap(a -> a.getVersions().stream()).toList()).excludeFromSave(this.excludeFromSave).build();
    }

    public String recentId() {
        return this.serverInfo.getConnectId() + "_" + this.issue.getProject().getKey() + "_" + this.issue.getKey();
    }

    public String recentId(String key) {
        return this.serverInfo.getConnectId() + "_" + this.issue.getProject().getKey() + "_" + key;
    }

    public Set<String> relationRecentIds() {
        List issueRelations = StreamUtil.toStream(this.issue.getIssueLinks()).toList();
        return issueRelations.stream().map(a -> {
            String projectKey = Arrays.stream(a.getTargetIssueKey().split("-")).findFirst().orElseGet(() -> this.almIssueWithRequirementDTO.getProjectKeyOrId());
            return this.almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey, a.getTargetIssueKey());
        }).collect(Collectors.toSet());
    }

    @Generated
    public static OnPremissJiraIssueVOBuilder builder() {
        return new OnPremissJiraIssueVOBuilder();
    }

    @Generated
    public Issue getIssue() {
        return this.issue;
    }

    @Generated
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Generated
    public AlmIssueWithRequirementDTO getAlmIssueWithRequirementDTO() {
        return this.almIssueWithRequirementDTO;
    }

    @Generated
    public boolean isExcludeFromSave() {
        return this.excludeFromSave;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceIds() {
        return this.linkedIssuePdServiceIds;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceVersions() {
        return this.linkedIssuePdServiceVersions;
    }

    @Generated
    public OnPremissJiraIssueVO() {
    }

    @Generated
    public OnPremissJiraIssueVO(Issue issue, ServerInfo serverInfo, AlmIssueWithRequirementDTO almIssueWithRequirementDTO, boolean excludeFromSave, List<Long> linkedIssuePdServiceIds, List<Long> linkedIssuePdServiceVersions) {
        this.issue = issue;
        this.serverInfo = serverInfo;
        this.almIssueWithRequirementDTO = almIssueWithRequirementDTO;
        this.excludeFromSave = excludeFromSave;
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnPremissJiraIssueVO)) {
            return false;
        }
        OnPremissJiraIssueVO other = (OnPremissJiraIssueVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Issue this$issue = this.getIssue();
        Issue other$issue = other.getIssue();
        return !(this$issue == null ? other$issue != null : !this$issue.equals(other$issue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OnPremissJiraIssueVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Issue $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        return result;
    }

    @Generated
    public static class OnPremissJiraIssueVOBuilder {
        @Generated
        private Issue issue;
        @Generated
        private ServerInfo serverInfo;
        @Generated
        private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;
        @Generated
        private boolean excludeFromSave;
        @Generated
        private List<Long> linkedIssuePdServiceIds;
        @Generated
        private List<Long> linkedIssuePdServiceVersions;

        @Generated
        OnPremissJiraIssueVOBuilder() {
        }

        @Generated
        public OnPremissJiraIssueVOBuilder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVOBuilder serverInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVOBuilder almIssueWithRequirementDTO(AlmIssueWithRequirementDTO almIssueWithRequirementDTO) {
            this.almIssueWithRequirementDTO = almIssueWithRequirementDTO;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVOBuilder excludeFromSave(boolean excludeFromSave) {
            this.excludeFromSave = excludeFromSave;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVOBuilder linkedIssuePdServiceIds(List<Long> linkedIssuePdServiceIds) {
            this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVOBuilder linkedIssuePdServiceVersions(List<Long> linkedIssuePdServiceVersions) {
            this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
            return this;
        }

        @Generated
        public OnPremissJiraIssueVO build() {
            return new OnPremissJiraIssueVO(this.issue, this.serverInfo, this.almIssueWithRequirementDTO, this.excludeFromSave, this.linkedIssuePdServiceIds, this.linkedIssuePdServiceVersions);
        }

        @Generated
        public String toString() {
            return "OnPremissJiraIssueVO.OnPremissJiraIssueVOBuilder(issue=" + String.valueOf(this.issue) + ", serverInfo=" + String.valueOf(this.serverInfo) + ", almIssueWithRequirementDTO=" + String.valueOf(this.almIssueWithRequirementDTO) + ", excludeFromSave=" + this.excludeFromSave + ", linkedIssuePdServiceIds=" + String.valueOf(this.linkedIssuePdServiceIds) + ", linkedIssuePdServiceVersions=" + String.valueOf(this.linkedIssuePdServiceVersions) + ")";
        }
    }
}

