/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.dashboard.service;

import com.arms.api.analysis.resource.model.dto.ResourceRequestDTO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.service.AnalysisResource;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.ReqIssueStatusByWeekVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeReqLinkVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.dashboard.model.vo.\uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4;
import com.arms.api.dashboard.service.Dashboard;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.ParseUtil;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="DashboardService")
public class DashboardImpl
implements Dashboard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final AnalysisResource resourceService;

    @Override
    public List<TopNReqAssigneeReqLinkVO> topNAssigneeReqLinks(DashboardDTO dashboardDTO, Integer rankSize) {
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setPdServiceAndIsReq(dashboardDTO.getPdServiceAndIsReq());
        Map<String, UniqueAssigneeVO> uniquedAssigneeMap = this.listToMapConvert(this.resourceService.findAssigneesInfo(resourceDTO));
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").subGroupFieldDTOS(List.of(SubGroupFieldDTO.builder().subField("cReqLink").subFieldAlias("cReqLink").build())).build()).andTermQueryMust("pdServiceId", dashboardDTO.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", dashboardDTO.getPdServiceVersions()).andExistsQueryFilter("assignee").andTermQueryMust("isReq", dashboardDTO.getIsReq()));
        List<DocumentBucket> documentBuckets = aggregations.deepestList();
        HashMap<String, TopNReqAssigneeReqLinkVO> accountIdReqLinkVOMap = new HashMap<String, TopNReqAssigneeReqLinkVO>();
        for (DocumentBucket doc : documentBuckets) {
            String accountId = doc.valueByName("accountId");
            if (accountIdReqLinkVOMap.get(accountId) == null) {
                UniqueAssigneeVO uniqueAssigneeVO = uniquedAssigneeMap.get(accountId);
                String emailId = ParseUtil.extractUsernameFromEmail(uniqueAssigneeVO.getEmailAddress());
                String nameWithEmailId = uniqueAssigneeVO.getName() + Optional.ofNullable(emailId).map(name -> "(" + name + ")").orElse("");
                accountIdReqLinkVOMap.put(accountId, TopNReqAssigneeReqLinkVO.builder().name(uniquedAssigneeMap.get(accountId).getName()).nameWithEmailId(nameWithEmailId).emailAddress(uniqueAssigneeVO.getEmailAddress()).reqCount(doc.countByName("accountId")).reqLinks(new ArrayList<String>(List.of(doc.valueByName("cReqLink")))).build());
                continue;
            }
            TopNReqAssigneeReqLinkVO topNReqAssigneeReqLinkVO = (TopNReqAssigneeReqLinkVO)accountIdReqLinkVOMap.get(accountId);
            topNReqAssigneeReqLinkVO.addReqCount(doc.countByName("accountId"));
            topNReqAssigneeReqLinkVO.getReqLinks().add(doc.valueByName("cReqLink"));
        }
        return accountIdReqLinkVOMap.values().stream().sorted(Comparator.comparing(TopNReqAssigneeReqLinkVO::getReqCount, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(TopNReqAssigneeReqLinkVO::getName, Comparator.nullsLast(String::compareTo))).limit(rankSize != null && rankSize > 0 ? (long)rankSize.intValue() : Long.MAX_VALUE).toList();
    }

    @Override
    public List<TopNReqAssigneeVO> topNReqAssignee(DashboardDTO dashboardDTO, Integer rankSize) {
        ArrayList<TopNReqAssigneeVO> returnList = new ArrayList<TopNReqAssigneeVO>();
        ResourceRequestDTO resourceDTO = new ResourceRequestDTO();
        resourceDTO.setPdServiceAndIsReq(dashboardDTO.getPdServiceAndIsReq());
        Map<String, UniqueAssigneeVO> uniquedAssigneeMap = this.listToMapConvert(this.resourceService.findAssigneesInfo(resourceDTO));
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").build()).andTermQueryMust("pdServiceId", dashboardDTO.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", dashboardDTO.getPdServiceVersions()).andExistsQueryFilter("assignee").andTermQueryMust("isReq", dashboardDTO.getIsReq()));
        List<DocumentBucket> documentBuckets = aggregations.deepestList();
        if (documentBuckets.isEmpty()) {
            return Collections.emptyList();
        }
        for (DocumentBucket doc : documentBuckets) {
            String accountId = doc.valueByName("accountId");
            Long reqCount = doc.countByName("accountId");
            UniqueAssigneeVO uniqueAssigneeVO = uniquedAssigneeMap.get(accountId);
            String emailId = ParseUtil.extractUsernameFromEmail(uniqueAssigneeVO.getEmailAddress());
            String nameWithEmailId = uniqueAssigneeVO.getName() + Optional.ofNullable(emailId).map(name -> "(" + name + ")").orElse("");
            returnList.add(TopNReqAssigneeVO.builder().accountId(accountId).reqCount(reqCount).name(uniqueAssigneeVO.getName()).emailAddress(uniqueAssigneeVO.getEmailAddress()).nameWithEmailId(nameWithEmailId).build());
        }
        return returnList.stream().sorted(Comparator.comparing(TopNReqAssigneeVO::getReqCount, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(TopNReqAssigneeVO::getName, Comparator.nullsLast(String::compareTo))).limit(rankSize != null && rankSize > 0 ? (long)rankSize.intValue() : Long.MAX_VALUE).toList();
    }

    @Override
    public Map<String, \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4> aggregateWeeklyReqIssueStatus(DashboardDTO dashboardDTO) {
        LocalDate now = LocalDate.now(ZoneId.of("UTC"));
        LocalDate monthAgo = now.minusWeeks(4L);
        \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4 historicalData = this.getPriorCumulativeData(dashboardDTO, monthAgo);
        HashMap<String, Long> totalStatuses = new HashMap<String, Long>(historicalData.getStatuses());
        long totalIssues = historicalData.getTotalIssues();
        long totalRequirements = historicalData.getTotalRequirements();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocsByWeek(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("created").mainFieldAlias("created").subGroupFieldDTOS(List.of(SubGroupFieldDTO.builder().subField("status.status_name.keyword").subFieldAlias("statusName").build())).build()).andTermQueryMust("pdServiceId", dashboardDTO.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", dashboardDTO.getPdServiceVersions()).andTermQueryMust("isReq", true).andRangeQueryFilter(RangeQueryFilter.of("created").lte(now).gte(monthAgo)));
        List<DocumentBucket> deepestList = documentAggregations.deepestList();
        List<ReqIssueStatusByWeekVO> issueStatusByCreatedDateVOS = deepestList.stream().map(documentBucket -> ReqIssueStatusByWeekVO.builder().created(this.transformDate(documentBucket.valueByName("created"))).statusName(documentBucket.valueByName("statusName")).count(documentBucket.countByName("statusName")).build()).toList();
        Map issueStatusByCreated = issueStatusByCreatedDateVOS.stream().collect(Collectors.groupingBy(ReqIssueStatusByWeekVO::getCreated, TreeMap::new, Collectors.toList()));
        TreeMap<String, \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4> aggrResultMap = new TreeMap<String, \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4>();
        if (issueStatusByCreated.isEmpty()) {
            \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4 defaultAggregation = \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4.builder().totalIssues(totalIssues).totalRequirements(totalRequirements).statuses(new HashMap<String, Long>(totalStatuses)).build();
            aggrResultMap.put("\ucd5c\uadfc \ud55c \ub2ec \uac04\uc758 \ub370\uc774\ud130\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc544 \ub204\uc801 \ub370\uc774\ud130\ub97c \ud45c\uc2dc\ud569\ub2c8\ub2e4.", defaultAggregation);
        } else {
            for (Map.Entry entry : issueStatusByCreated.entrySet()) {
                String date = (String)entry.getKey();
                List vos = (List)entry.getValue();
                long totalRequirements1 = vos.stream().mapToLong(ReqIssueStatusByWeekVO::getCount).sum();
                Map<String, Long> statuses = vos.stream().collect(Collectors.groupingBy(ReqIssueStatusByWeekVO::getStatusName, Collectors.summingLong(ReqIssueStatusByWeekVO::getCount)));
                \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4 \uc8fc\ubcc4_\uc9d1\uacc4 = \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4.builder().totalRequirements(totalRequirements1).statuses(statuses).totalIssues(totalRequirements1).build();
                aggrResultMap.put(date, \uc8fc\ubcc4_\uc9d1\uacc4);
            }
            for (\uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4 monthlyAggregation : aggrResultMap.values()) {
                monthlyAggregation.setTotalIssues(totalIssues += monthlyAggregation.getTotalIssues());
                monthlyAggregation.setTotalRequirements(totalRequirements += monthlyAggregation.getTotalRequirements());
                Map<String, Long> currentStatuses = monthlyAggregation.getStatuses();
                for (Map.Entry<String, Long> entry : currentStatuses.entrySet()) {
                    totalStatuses.merge(entry.getKey(), entry.getValue(), Long::sum);
                }
                monthlyAggregation.setStatuses(new HashMap<String, Long>(totalStatuses));
            }
        }
        return aggrResultMap;
    }

    private \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4 getPriorCumulativeData(DashboardDTO dashboardDTO, LocalDate monthAgo) {
        Long pdServiceId = dashboardDTO.getPdServiceId();
        List<Long> pdServiceVersions = dashboardDTO.getPdServiceVersions();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("status.status_name.keyword").mainFieldAlias("statusName").build()).andTermQueryMust("pdServiceId", dashboardDTO.getPdServiceId()).andTermQueryMust("isReq", true).andTermsQueryFilter("pdServiceVersions", dashboardDTO.getPdServiceVersions()).andRangeQueryFilter(RangeQueryFilter.of("created").lt(monthAgo)));
        Long totalIssuesCount = documentAggregations.getTotalHits();
        Long totalRequirementsCount = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("isReq", true).andTermQueryMust("pdServiceId", dashboardDTO.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", dashboardDTO.getPdServiceVersions()).andRangeQueryFilter(RangeQueryFilter.of("created").lt(monthAgo))).getTotalHits();
        HashMap<String, Long> statusMap = new HashMap<String, Long>();
        for (DocumentBucket documentBucket : documentAggregations.deepestList()) {
            String statusName = documentBucket.valueByName("statusName");
            long docCount = documentBucket.countByName("statusName");
            statusMap.put(statusName, docCount);
        }
        return new \uc694\uad6c\uc0ac\ud56d_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\uc8fc\ubcc4_\uc9d1\uacc4(totalIssuesCount, statusMap, totalRequirementsCount);
    }

    private String transformDate(String date) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(date);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(offsetDateTime);
    }

    private Map<String, UniqueAssigneeVO> listToMapConvert(List<UniqueAssigneeVO> list) {
        return list.stream().collect(Collectors.toMap(UniqueAssigneeVO::getAccountId, Function.identity(), (existing, incoming) -> existing));
    }

    @Generated
    public DashboardImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, AnalysisResource resourceService) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.resourceService = resourceService;
    }
}

