/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.bbs.model.entity;

import com.arms.api.bbs.model.constant.BoardType;
import com.arms.api.bbs.model.constant.PostType;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="bbs")
@Setting(settingPath="/es-settings/bbs-index-settings.json")
public class BbsEntity
implements BaseEntity {
    @Id
    @Field(type=FieldType.Keyword, name="id")
    private String id;
    @Field(type=FieldType.Keyword, name="post_type")
    private PostType postType;
    @Field(type=FieldType.Keyword, name="group_id")
    private String groupId;
    @Field(type=FieldType.Text, name="subject_name", analyzer="ngram_analyzer", searchAnalyzer="standard")
    private String subjectName;
    @Field(type=FieldType.Text, name="contents")
    private String contents;
    @Field(type=FieldType.Keyword, name="board_type")
    private BoardType boardType;
    @Field(type=FieldType.Text, name="user_name")
    private String userName;
    @Field(type=FieldType.Text, name="password")
    private String password;
    @Field(type=FieldType.Date, name="created_date")
    @ElasticSearchCreatedDate
    private Date createdDate;
    @Field(type=FieldType.Date, name="updated_date")
    @ElasticSearchUpdateDate
    private Date updatedDate;
    @Field(type=FieldType.Keyword, name="path")
    private String path;
    @Field(type=FieldType.Integer, name="indent")
    private Integer indent;
    @Field(type=FieldType.Integer, name="view_count")
    private Integer viewCount;

    public void generateGroupId() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSSSSSS");
        this.path = this.groupId = now.format(formatter);
        this.indent = 0;
    }

    public void generatePath(String parentUpperPath) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSSSSSS");
        this.groupId = parentUpperPath.split("/")[0];
        this.path = parentUpperPath + "/" + now.format(formatter);
        this.indent = this.path.split("/").length - 1;
    }

    public void updateBbsEntity(BbsEntity bbsEntity) {
        if (bbsEntity.subjectName != null) {
            this.subjectName = bbsEntity.subjectName;
        }
        if (bbsEntity.boardType != null) {
            this.boardType = bbsEntity.boardType;
        }
        if (bbsEntity.postType != null) {
            this.postType = bbsEntity.postType;
        }
        if (bbsEntity.path != null) {
            this.path = bbsEntity.path;
        }
        if (bbsEntity.contents != null) {
            this.contents = bbsEntity.contents;
        }
    }

    public void updateGroupIdAndPath(String groupId) {
        this.path = this.path.replace(this.groupId, groupId);
        this.groupId = groupId;
    }

    public void viewCountUp() {
        this.viewCount = Optional.ofNullable(this.viewCount).orElse(0) + 1;
    }

    public void viewCountInit() {
        this.viewCount = Optional.ofNullable(this.viewCount).orElse(0);
    }

    private BbsEntity() {
    }

    @Generated
    public static BbsEntityBuilder builder() {
        return new BbsEntityBuilder();
    }

    @Generated
    public BbsEntity(String id, PostType postType, String groupId, String subjectName, String contents, BoardType boardType, String userName, String password, Date createdDate, Date updatedDate, String path, Integer indent, Integer viewCount) {
        this.id = id;
        this.postType = postType;
        this.groupId = groupId;
        this.subjectName = subjectName;
        this.contents = contents;
        this.boardType = boardType;
        this.userName = userName;
        this.password = password;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
        this.path = path;
        this.indent = indent;
        this.viewCount = viewCount;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public PostType getPostType() {
        return this.postType;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getSubjectName() {
        return this.subjectName;
    }

    @Generated
    public String getContents() {
        return this.contents;
    }

    @Generated
    public BoardType getBoardType() {
        return this.boardType;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Integer getIndent() {
        return this.indent;
    }

    @Generated
    public Integer getViewCount() {
        return this.viewCount;
    }

    @Generated
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Generated
    public static class BbsEntityBuilder {
        @Generated
        private String id;
        @Generated
        private PostType postType;
        @Generated
        private String groupId;
        @Generated
        private String subjectName;
        @Generated
        private String contents;
        @Generated
        private BoardType boardType;
        @Generated
        private String userName;
        @Generated
        private String password;
        @Generated
        private Date createdDate;
        @Generated
        private Date updatedDate;
        @Generated
        private String path;
        @Generated
        private Integer indent;
        @Generated
        private Integer viewCount;

        @Generated
        BbsEntityBuilder() {
        }

        @Generated
        public BbsEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public BbsEntityBuilder postType(PostType postType) {
            this.postType = postType;
            return this;
        }

        @Generated
        public BbsEntityBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Generated
        public BbsEntityBuilder subjectName(String subjectName) {
            this.subjectName = subjectName;
            return this;
        }

        @Generated
        public BbsEntityBuilder contents(String contents) {
            this.contents = contents;
            return this;
        }

        @Generated
        public BbsEntityBuilder boardType(BoardType boardType) {
            this.boardType = boardType;
            return this;
        }

        @Generated
        public BbsEntityBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Generated
        public BbsEntityBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public BbsEntityBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Generated
        public BbsEntityBuilder updatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        @Generated
        public BbsEntityBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public BbsEntityBuilder indent(Integer indent) {
            this.indent = indent;
            return this;
        }

        @Generated
        public BbsEntityBuilder viewCount(Integer viewCount) {
            this.viewCount = viewCount;
            return this;
        }

        @Generated
        public BbsEntity build() {
            return new BbsEntity(this.id, this.postType, this.groupId, this.subjectName, this.contents, this.boardType, this.userName, this.password, this.createdDate, this.updatedDate, this.path, this.indent, this.viewCount);
        }

        @Generated
        public String toString() {
            return "BbsEntity.BbsEntityBuilder(id=" + this.id + ", postType=" + String.valueOf((Object)this.postType) + ", groupId=" + this.groupId + ", subjectName=" + this.subjectName + ", contents=" + this.contents + ", boardType=" + String.valueOf((Object)this.boardType) + ", userName=" + this.userName + ", password=" + this.password + ", createdDate=" + String.valueOf(this.createdDate) + ", updatedDate=" + String.valueOf(this.updatedDate) + ", path=" + this.path + ", indent=" + this.indent + ", viewCount=" + this.viewCount + ")";
        }
    }
}

