/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.time.service;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.analysis.time.dto.TimeDTO;
import com.arms.api.analysis.time.service.AnalysisTime;
import com.arms.api.analysis.time.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.vo.DateIssueCountVO;
import com.arms.api.analysis.time.vo.HeatMapDateVO;
import com.arms.api.analysis.time.vo.HeatMapVO;
import com.arms.api.analysis.time.vo.IssueKeyUpdateCountVO;
import com.arms.api.analysis.time.vo.KeyVerSummaryByIssueVO;
import com.arms.api.analysis.time.vo.RidgeLineVO;
import com.arms.api.analysis.time.vo.ScatterChartVO;
import com.arms.api.analysis.time.vo.StatusCountVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.requirement.service.RequirementService;
import com.arms.api.util.ParseUtil;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationCardinalityRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="analysisTime")
public class AnalysisTimeImpl
implements AnalysisTime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisTimeImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final RequirementService requirementService;

    @Override
    public DateIssueCountVO getDateHistogramCardinalityData(TimeDTO timeDTO) {
        Long pdServiceId = timeDTO.getPdServiceAndIsReq().getPdServiceId();
        List<Long> versions = timeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        DocumentAggregations reqIssueAggregations = this.esCommonRepositoryWrapper.aggregateDocsCardinalityByDay(SimpleQuery.aggregation(AggregationCardinalityRequestDTO.builder().mainFieldAlias("updated").mainField("updated").cardinality(SubGroupFieldDTO.builder().subFieldAlias("key").subField("key").build()).build()).andTermQueryMust("pdServiceId", pdServiceId).andTermsQueryFilter("pdServiceVersions", versions).andTermQueryMust("isReq", Boolean.TRUE).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(String.valueOf(timeDTO.getStartDate()), String.valueOf(timeDTO.getEndDate()))));
        HashMap<String, Integer> reqIssueCountsOfDate = new HashMap<String, Integer>();
        for (DocumentBucket docBucket : reqIssueAggregations.deepestList()) {
            String date = docBucket.valueByName("updated");
            Float key = docBucket.floatCountByName("key");
            int integerOfKey = Math.round(key.floatValue());
            reqIssueCountsOfDate.put(this.transformDate(date), integerOfKey);
        }
        DocumentAggregations allIssueAggregations = this.esCommonRepositoryWrapper.aggregateDocsCardinalityByDay(SimpleQuery.aggregation(AggregationCardinalityRequestDTO.builder().mainFieldAlias("updated").mainField("updated").cardinality(SubGroupFieldDTO.builder().subFieldAlias("key").subField("key").build()).build()).andTermsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", versions).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(String.valueOf(timeDTO.getStartDate()), String.valueOf(timeDTO.getEndDate()))));
        HashMap<String, Integer> allIssueCountsOfDate = new HashMap<String, Integer>();
        for (DocumentBucket documentBucket : allIssueAggregations.deepestList()) {
            String date = documentBucket.valueByName("updated");
            Float key = documentBucket.floatCountByName("key");
            int integerOfKey = Math.round(key.floatValue());
            allIssueCountsOfDate.put(this.transformDate(date), integerOfKey);
        }
        HashMap<String, Integer> notReqIssueCountsOfDate = new HashMap<String, Integer>(allIssueCountsOfDate);
        for (Map.Entry entry : reqIssueCountsOfDate.entrySet()) {
            String date = (String)entry.getKey();
            Integer totalCount = notReqIssueCountsOfDate.getOrDefault(date, 0);
            Integer reqCount = (Integer)entry.getValue();
            notReqIssueCountsOfDate.put(date, Math.max(0, totalCount - reqCount));
        }
        return DateIssueCountVO.builder().reqIssuesDateCountMap(reqIssueCountsOfDate).notReqIssuesCountMap(notReqIssueCountsOfDate).build();
    }

    @Override
    public HeatMapVO getHeatMapDataByUpdated(TimeDTO timeDTO) {
        TimeDTO processedTimeDTO = this.processTimeRangeDTO(timeDTO);
        DateIssueCountVO dateHistogramCardinalityData = this.getDateHistogramCardinalityData(processedTimeDTO);
        List<HeatMapDateVO> reqIssueDateVO = this.processHeatMapData(dateHistogramCardinalityData.getReqIssuesDateCountMap());
        List<HeatMapDateVO> notReqIssueDateVO = this.processHeatMapData(dateHistogramCardinalityData.getNotReqIssuesCountMap());
        return HeatMapVO.builder().requirement(reqIssueDateVO).relationIssue(notReqIssueDateVO).build();
    }

    private TimeDTO processTimeRangeDTO(TimeDTO originalDTO) {
        LocalDate now = LocalDate.now(ZoneId.of("UTC"));
        String startDate = originalDTO.getStartDate();
        String endDate = originalDTO.getEndDate();
        if (startDate == null && endDate == null) {
            return this.copyWithDates(originalDTO, String.valueOf(now.minusYears(1L)), String.valueOf(now));
        }
        if (startDate != null && endDate == null) {
            LocalDate startLocalDate = LocalDate.parse(startDate);
            LocalDate endLocalDate = startLocalDate.plusYears(1L);
            endLocalDate = endLocalDate.isAfter(now) ? now : endLocalDate;
            return this.copyWithDates(originalDTO, startDate, String.valueOf(endLocalDate));
        }
        if (startDate == null && endDate != null) {
            LocalDate endLocalDate = LocalDate.parse(endDate);
            return this.copyWithDates(originalDTO, String.valueOf(endLocalDate.minusYears(1L)), endDate);
        }
        return originalDTO;
    }

    private TimeDTO copyWithDates(TimeDTO originalDTO, String startDate, String endDate) {
        TimeDTO newDTO = new TimeDTO();
        newDTO.setPdServiceAndIsReq(originalDTO.getPdServiceAndIsReq());
        newDTO.setStartDate(startDate);
        newDTO.setEndDate(endDate);
        return newDTO;
    }

    private List<HeatMapDateVO> processHeatMapData(Map<String, Integer> issueCountsOfDate) {
        return issueCountsOfDate.entrySet().stream().map(entry -> new HeatMapDateVO((String)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }

    @Override
    public List<AlmIssueStatVO> getMultiCombinationChartData(TimeDTO timeDTO) {
        List<AlmIssueStatVO> createdIssueStatusByDate = this.getCreatedIssueStatusByDate(timeDTO);
        List<AlmIssueStatVO> updatedIssueStatusByDate = this.getUpdatedIssueStatusByDate(timeDTO);
        LinkedHashMap mergedMap = new LinkedHashMap();
        createdIssueStatusByDate.stream().filter(Objects::nonNull).forEach(stat -> mergedMap.put(stat.getDate(), AlmIssueStatVO.builder().date(stat.getDate()).totalRequirements(stat.getTotalRequirements()).totalRelationIssues(stat.getTotalRelationIssues()).requirementStatuses(new ArrayList<StatusCountVO>()).relationIssueStatuses(new ArrayList<StatusCountVO>()).build()));
        updatedIssueStatusByDate.stream().filter(Objects::nonNull).forEach(stat -> mergedMap.compute(stat.getDate(), (key, existing) -> {
            if (existing == null) {
                return AlmIssueStatVO.builder().date(stat.getDate()).totalRequirements(0L).totalRelationIssues(0L).requirementStatuses(stat.getRequirementStatuses()).relationIssueStatuses(stat.getRelationIssueStatuses()).build();
            }
            return AlmIssueStatVO.builder().date(existing.getDate()).totalRequirements(existing.getTotalRequirements()).totalRelationIssues(existing.getTotalRelationIssues()).requirementStatuses(stat.getRequirementStatuses()).relationIssueStatuses(stat.getRelationIssueStatuses()).build();
        }));
        return mergedMap.values().stream().sorted(Comparator.comparing(AlmIssueStatVO::getDate)).collect(Collectors.toList());
    }

    private List<AlmIssueStatVO> getCreatedIssueStatusByDate(TimeDTO timeDTO) {
        Long pdServiceId = timeDTO.getPdServiceAndIsReq().getPdServiceId();
        List<Long> versions = timeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        List<AlmIssueEntity> allIssues = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", versions).andRangeQueryFilter(RangeQueryFilter.of("created").betweenDate(String.valueOf(timeDTO.getStartDate()), String.valueOf(timeDTO.getEndDate()))).andExistsQueryFilter("status").orderBy(SortDTO.builder().field("overallUpdatedDate").sortType("desc").build())).toDocs();
        LinkedHashMap tempMap = new LinkedHashMap();
        allIssues.stream().filter(Objects::nonNull).forEach(entity -> {
            String date = this.transformDate(entity.stringValueOfCreatedDate());
            if (date == null) {
                return;
            }
            boolean isReqIssue = this.isRequirementIssueWithMatchingService((AlmIssueEntity)entity, pdServiceId);
            tempMap.compute(date, (key, existingStatVO) -> {
                if (existingStatVO == null) {
                    return AlmIssueStatVO.builder().date(date).totalRequirements(isReqIssue ? 1L : 0L).totalRelationIssues(isReqIssue ? 0L : 1L).build();
                }
                if (isReqIssue) {
                    existingStatVO.addTotalRequirements(1L);
                } else {
                    existingStatVO.addTotalRelationIssues(1L);
                }
                return existingStatVO;
            });
        });
        return new ArrayList<AlmIssueStatVO>(tempMap.values());
    }

    private List<AlmIssueStatVO> getUpdatedIssueStatusByDate(TimeDTO timeDTO) {
        Long pdServiceId = timeDTO.getPdServiceAndIsReq().getPdServiceId();
        List<Long> versions = timeDTO.getPdServiceAndIsReq().getPdServiceVersions();
        List<AlmIssueEntity> allIssues = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", versions).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(String.valueOf(timeDTO.getStartDate()), String.valueOf(timeDTO.getEndDate()))).andExistsQueryFilter("status").orderBy(SortDTO.builder().field("overallUpdatedDate").sortType("desc").build())).toDocs();
        ArrayList<AlmIssueEntity> reqIssues = new ArrayList<AlmIssueEntity>();
        ArrayList<AlmIssueEntity> notReqIssues = new ArrayList<AlmIssueEntity>();
        for (AlmIssueEntity issue : allIssues) {
            if (this.isRequirementIssueWithMatchingService(issue, pdServiceId)) {
                reqIssues.add(issue);
                continue;
            }
            notReqIssues.add(issue);
        }
        LinkedHashMap tempMap = new LinkedHashMap();
        allIssues.stream().filter(Objects::nonNull).forEach(entity -> {
            String date = this.transformDate(entity.stringValueOfUpdatedDate());
            if (date == null) {
                return;
            }
            String status = this.extractStatusName((AlmIssueEntity)entity);
            boolean isReqIssue = this.isRequirementIssueWithMatchingService((AlmIssueEntity)entity, pdServiceId);
            tempMap.compute(date, (key, existingStatVO) -> this.updateOrCreateStatVO(date, status, isReqIssue, (AlmIssueStatVO)existingStatVO));
        });
        return new ArrayList<AlmIssueStatVO>(tempMap.values());
    }

    @Override
    public List<ScatterChartVO> getScatterData(TimeDTO timeDTO) {
        TimeDTO processedTimeDTO = this.processTimeRangeDTO(timeDTO);
        DateIssueCountVO dateHistogramCardinalityData = this.getDateHistogramCardinalityData(processedTimeDTO);
        Map<String, Integer> reqIssuesDateCountMap = dateHistogramCardinalityData.getReqIssuesDateCountMap();
        Map<String, Integer> notReqIssuesCountMap = dateHistogramCardinalityData.getNotReqIssuesCountMap();
        HashMap scatterChartVOMap = new HashMap();
        reqIssuesDateCountMap.forEach((date, count) -> {
            ScatterChartVO scatterChartVO = scatterChartVOMap.computeIfAbsent(date, key -> ScatterChartVO.builder().date((String)key).requirement(0L).relationIssue(0L).build());
            scatterChartVO.addRequirement(count.intValue());
        });
        notReqIssuesCountMap.forEach((date, count) -> {
            ScatterChartVO scatterChartVO = scatterChartVOMap.computeIfAbsent(date, key -> ScatterChartVO.builder().date((String)key).requirement(0L).relationIssue(0L).build());
            scatterChartVO.addRelationIssue(count.intValue());
        });
        return scatterChartVOMap.values().stream().sorted(Comparator.comparing(ScatterChartVO::getDate)).toList();
    }

    @Override
    public List<AlmIssueEntity> getUpdatedReqIssueByDateRange(TimeAggrDTO timeAggrDTO) {
        return this.findReqUpdatesHistory(timeAggrDTO);
    }

    @Override
    public List<RidgeLineVO> getRidgeLineData(TimeDTO timeDTO) {
        Long pdServiceId = timeDTO.getPdServiceAndIsReq().getPdServiceId();
        List<AlmIssueEntity> retrievedReqIssues = this.retrieveReqIssues(timeDTO);
        if (retrievedReqIssues.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, KeyVerSummaryByIssueVO> keyToSummaryMap = this.buildKeyVerSummaryMapByIssues(retrievedReqIssues);
        Set recentIdSetOfReqIssue = retrievedReqIssues.stream().map(AlmIssueEntity::getRecentId).collect(Collectors.toSet());
        HashMap<String, Map<String, IssueKeyUpdateCountVO>> dateIssueUpdateCountsMap = new HashMap<String, Map<String, IssueKeyUpdateCountVO>>();
        List<AlmIssueEntity> allIssuesByUpdateHistory = this.findAllIssuesByUpdateHistory(timeDTO);
        if (allIssuesByUpdateHistory.isEmpty()) {
            return Collections.emptyList();
        }
        for (AlmIssueEntity issue : allIssuesByUpdateHistory) {
            List<String> linkedIssues;
            String updateDate = this.transformDate(issue.stringValueOfUpdatedDate());
            if (this.isRequirementIssueWithMatchingService(issue, pdServiceId)) {
                String key = issue.getKey();
                this.processDateIssueUpdateCountsMapByIssueKey(dateIssueUpdateCountsMap, updateDate, key);
            }
            if (!ObjectUtils.isEmpty((Object)issue.getPdServiceId()) && ObjectUtils.nullSafeEquals((Object)issue.getPdServiceId(), (Object)pdServiceId) && issue.getIsReq().equals(Boolean.FALSE)) {
                String parentReqKey = issue.getParentReqKey();
                String parentReqRecentId = this.getParentReqRecentId(issue);
                if (!ObjectUtils.isEmpty((Object)parentReqRecentId) && recentIdSetOfReqIssue.contains(parentReqRecentId)) {
                    this.processDateIssueUpdateCountsMapByIssueKey(dateIssueUpdateCountsMap, updateDate, parentReqKey);
                }
            }
            if (ObjectUtils.isEmpty(linkedIssues = issue.getLinkedIssues())) continue;
            for (String linkedIssueRecentId : linkedIssues) {
                if (!recentIdSetOfReqIssue.contains(linkedIssueRecentId)) continue;
                String keyOfRecentId = ParseUtil.getLastSegment(linkedIssueRecentId);
                this.processDateIssueUpdateCountsMapByIssueKey(dateIssueUpdateCountsMap, updateDate, keyOfRecentId);
            }
        }
        ArrayList<RidgeLineVO> ridgeLineData = new ArrayList<RidgeLineVO>();
        dateIssueUpdateCountsMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            String date = (String)e.getKey();
            for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                String key = (String)entry.getKey();
                IssueKeyUpdateCountVO issueKeyUpdateCountVO = (IssueKeyUpdateCountVO)entry.getValue();
                KeyVerSummaryByIssueVO keyVerSummaryByIssue = (KeyVerSummaryByIssueVO)keyToSummaryMap.get(key);
                String versionsWithComma = this.versionLinkWithComma(keyVerSummaryByIssue.getVersions().stream().map(String::valueOf).collect(Collectors.toList()));
                ridgeLineData.add(RidgeLineVO.builder().updateDate(date).key(key).version(versionsWithComma).summary(keyVerSummaryByIssue.getSummary()).updatedCount(issueKeyUpdateCountVO.getUpdateCount()).build());
            }
        });
        if (ridgeLineData.size() == 1) {
            return this.reRenderRidgeLineDate(ridgeLineData);
        }
        return ridgeLineData;
    }

    private Map<String, KeyVerSummaryByIssueVO> buildKeyVerSummaryMapByIssues(List<AlmIssueEntity> issueEntityList) {
        if (ObjectUtils.isEmpty(issueEntityList)) {
            return Collections.emptyMap();
        }
        return issueEntityList.stream().collect(Collectors.toMap(AlmIssueEntity::getKey, issue -> KeyVerSummaryByIssueVO.builder().key(issue.getKey()).summary(issue.getSummary()).versions(issue.getPdServiceVersions()).build(), (existing, incoming) -> {
            List<Long> mergedVersions = Stream.concat(existing.getVersions().stream(), incoming.getVersions().stream()).distinct().sorted().collect(Collectors.toList());
            return KeyVerSummaryByIssueVO.builder().key(existing.getKey()).summary(existing.getSummary()).versions(mergedVersions).build();
        }));
    }

    private String getParentReqRecentId(AlmIssueEntity issue) {
        String parentReqIssueKey = issue.getParentReqKey();
        String connectIdWithProjectKey = ParseUtil.getPrefixIncludingLastDelimiter(issue.recentId());
        if (ObjectUtils.isEmpty((Object)issue.getParentReqKey())) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)issue.getRecentId())) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)connectIdWithProjectKey)) {
            return null;
        }
        return connectIdWithProjectKey + parentReqIssueKey;
    }

    private void processDateIssueUpdateCountsMapByIssueKey(Map<String, Map<String, IssueKeyUpdateCountVO>> dateIssueUpdateCountsMap, String updateDate, String key) {
        dateIssueUpdateCountsMap.computeIfAbsent(updateDate, k -> new HashMap()).compute(key, (k, existing) -> {
            if (existing == null) {
                return IssueKeyUpdateCountVO.builder().key(key).updateCount(1L).build();
            }
            existing.addUpdateCount(1L);
            return existing;
        });
    }

    private String versionLinkWithComma(List<String> versions) {
        if (versions == null || versions.isEmpty()) {
            return "";
        }
        if (versions.size() == 1) {
            return versions.getFirst();
        }
        return versions.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private List<AlmIssueEntity> findReqUpdatesHistory(TimeAggrDTO timeAggrDTO) {
        return this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter("pdServiceId", timeAggrDTO.getPdServiceLink()).andTermsQueryFilter("pdServiceVersions", timeAggrDTO.getPdServiceVersionLinks()).andTermQueryFilter("isReq", true).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(timeAggrDTO.getStartDate(), timeAggrDTO.getEndDate()))).toDocs();
    }

    private List<AlmIssueEntity> findReqIssueWithOverallUpdateHistory(TimeDTO timeDTO) {
        return this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryMust("pdServiceId", timeDTO.fetchPdServiceLink()).andTermsQueryFilter("pdServiceVersions", timeDTO.fetchPdServiceVersionLinks()).andTermQueryMust("isReq", timeDTO.fetchIsReq()).andRangeQueryFilter(RangeQueryFilter.of("overallUpdatedDate").betweenDate(timeDTO.getStartDate(), timeDTO.getEndDate())).orderBy(SortDTO.builder().field("overallUpdatedDate").sortType("desc").build())).toDocs();
    }

    private List<AlmIssueEntity> findAllIssuesByUpdateHistory(TimeDTO timeDTO) {
        return this.esCommonRepositoryWrapper.findHits(SimpleQuery.termsQueryFilter("linkedIssuePdServiceIds", List.of(timeDTO.fetchPdServiceLink())).andTermsQueryFilter("linkedIssuePdServiceVersions", timeDTO.fetchPdServiceVersionLinks()).andTermQueryMust("isReq", timeDTO.fetchIsReq()).andExistsQueryFilter("assignee").andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(timeDTO.getStartDate(), timeDTO.getEndDate())).orderBy(SortDTO.builder().field("updated").sortType("desc").build())).toDocs();
    }

    private List<RidgeLineVO> reRenderRidgeLineDate(List<RidgeLineVO> ridgeLineData) {
        if (ridgeLineData.size() == 1) {
            RidgeLineVO singleData = ridgeLineData.getFirst();
            LocalDate currentDate = LocalDate.parse(singleData.getUpdateDate());
            String previousDate = currentDate.minusDays(1L).toString();
            String nextDate = currentDate.plusDays(1L).toString();
            RidgeLineVO previousDayData = RidgeLineVO.builder().version(singleData.getVersion()).updateDate(previousDate).key(singleData.getKey()).updatedCount(0L).summary(singleData.getSummary()).build();
            RidgeLineVO nextDayData = RidgeLineVO.builder().version(singleData.getVersion()).updateDate(nextDate).key(singleData.getKey()).updatedCount(0L).summary(singleData.getSummary()).build();
            return List.of(previousDayData, singleData, nextDayData);
        }
        return ridgeLineData;
    }

    private String transformDate(String date) {
        String subDate = date.substring(0, 10);
        LocalDate localDate = LocalDate.parse(subDate);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(localDate);
    }

    private boolean isRequirementIssueWithMatchingService(AlmIssueEntity issue, Long pdServiceId) {
        if (ObjectUtils.isEmpty((Object)issue.getPdServiceId())) {
            return false;
        }
        if (!issue.getIsReq().booleanValue()) {
            return false;
        }
        if (!issue.getPdServiceId().equals(pdServiceId)) {
            return false;
        }
        return issue.getIsReq() != false && issue.getPdServiceId().equals(pdServiceId);
    }

    private String extractStatusName(AlmIssueEntity entity) {
        if (entity.getStatus() != null && entity.getStatus().getName() != null) {
            return entity.getStatus().getName();
        }
        return "UNKNOWN";
    }

    private AlmIssueStatVO updateOrCreateStatVO(String date, String status, boolean isReqIssue, AlmIssueStatVO existingStatVO) {
        Map<String, Long> requirementStatusMap = this.getStatusMap(existingStatVO, true);
        Map<String, Long> relationIssueStatusMap = this.getStatusMap(existingStatVO, false);
        if (isReqIssue) {
            requirementStatusMap.merge(status, 1L, Long::sum);
        } else {
            relationIssueStatusMap.merge(status, 1L, Long::sum);
        }
        return AlmIssueStatVO.builder().date(date).requirementStatuses(this.toStatusCountList(requirementStatusMap)).relationIssueStatuses(this.toStatusCountList(relationIssueStatusMap)).build();
    }

    private Map<String, Long> getStatusMap(AlmIssueStatVO statVO, boolean isReqIssue) {
        List<StatusCountVO> statusList;
        if (statVO == null) {
            return new HashMap<String, Long>();
        }
        List<StatusCountVO> list = statusList = isReqIssue ? statVO.getRequirementStatuses() : statVO.getRelationIssueStatuses();
        if (statusList == null) {
            return new HashMap<String, Long>();
        }
        return statusList.stream().collect(Collectors.toMap(StatusCountVO::getStatus, StatusCountVO::getCount, (existing, replacement) -> existing));
    }

    private List<StatusCountVO> toStatusCountList(Map<String, Long> statusMap) {
        return statusMap.entrySet().stream().map(entry -> new StatusCountVO((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    private List<AlmIssueEntity> retrieveReqIssues(TimeDTO timeDTO) {
        TimeDTO processedTimeDTO = this.applyDefaultTimeRangeByOneYear(timeDTO);
        PdServiceAndIsReqDTO pdServiceAndIsReq = processedTimeDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List<Long> pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryMust("pdServiceId", pdServiceId).andTermsQueryFilter("pdServiceVersions", pdServiceVersions).andTermQueryFilter("isReq", Boolean.TRUE).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(processedTimeDTO.getStartDate(), processedTimeDTO.getEndDate())).andExistsQueryFilter("assignee")).toDocs();
    }

    private TimeDTO applyDefaultTimeRangeByOneYear(TimeDTO originalDTO) {
        LocalDate now = LocalDate.now(ZoneId.of("UTC"));
        String startDate = originalDTO.getStartDate();
        String endDate = originalDTO.getEndDate();
        if (startDate == null && endDate == null) {
            return this.copyWithDates(originalDTO, String.valueOf(now.minusYears(1L)), String.valueOf(now));
        }
        if (startDate != null && endDate == null) {
            LocalDate startLocalDate = LocalDate.parse(startDate);
            LocalDate endLocalDate = startLocalDate.plusYears(1L);
            endLocalDate = endLocalDate.isAfter(now) ? now : endLocalDate;
            return this.copyWithDates(originalDTO, startDate, String.valueOf(endLocalDate));
        }
        if (startDate == null && endDate != null) {
            LocalDate endLocalDate = LocalDate.parse(endDate);
            return this.copyWithDates(originalDTO, String.valueOf(endLocalDate.minusYears(1L)), endDate);
        }
        if (startDate != null && endDate != null) {
            LocalDate endLocalDate = LocalDate.parse(endDate);
            String newStartDate = String.valueOf(endLocalDate.minusYears(1L));
            return this.copyWithDates(originalDTO, newStartDate, endDate);
        }
        return originalDTO;
    }

    public void updateOrAddIssueCount(Set<IssueKeyUpdateCountVO> issueKeyUpdateCountVOS, String inputKey) {
        IssueKeyUpdateCountVO foundVO = null;
        for (IssueKeyUpdateCountVO vo : issueKeyUpdateCountVOS) {
            if (!vo.getKey().equals(inputKey)) continue;
            foundVO = vo;
            break;
        }
        if (foundVO != null) {
            foundVO.addUpdateCount(1L);
        } else {
            IssueKeyUpdateCountVO newVO = new IssueKeyUpdateCountVO(inputKey, 1L);
            issueKeyUpdateCountVOS.add(newVO);
        }
    }

    @Generated
    public AnalysisTimeImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, RequirementService requirementService) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.requirementService = requirementService;
    }
}

