package com.arms.api.util.communicate.external.response.jira;

import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class CReqProperty {
    private Long cReqPriorityLink;
    private String cReqPriorityName;
    private Long cReqDifficultyLink;
    private String cReqDifficultyName;
    private Long cReqStateLink;
    private String cReqStateName;

    public static CReqProperty of(Long cReqPriorityLink, String cReqPriorityName, Long cReqDifficultyLink, String cReqDifficultyName, Long cReqStateLink, String cReqStateName) {
        return new CReqProperty(cReqPriorityLink, cReqPriorityName, cReqDifficultyLink, cReqDifficultyName, cReqStateLink, cReqStateName);
    }

    public static CReqProperty of(ReqStatusEntity reqStatusEntity) {
        return new CReqProperty(
                reqStatusEntity.getC_req_priority_link(), reqStatusEntity.getC_req_priority_name(),
                reqStatusEntity.getC_req_difficulty_link(), reqStatusEntity.getC_req_difficulty_name(),
                reqStatusEntity.getC_req_state_link(), reqStatusEntity.getC_req_state_name()
        );
    }

}
