package com.arms.api.util.aspect;

import com.arms.api.util.slack.SlackProperty;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
@Slf4j
@AllArgsConstructor
public class DwrSendAdvice {

    protected final Chat chat;

    @Before("@annotation(dwrSendAlarm)")
    public void beforeMethod(JoinPoint joinPoint, DwrSendAlarm dwrSendAlarm) {
        try{
            if(!ObjectUtils.isEmpty(dwrSendAlarm.messageOnStart())){
                chat.sendMessageByEngine(dwrSendAlarm.messageOnStart());
            }

        }catch (RuntimeException e){
            log.error(e.getMessage());
        }
    }

    @AfterReturning("@annotation(dwrSendAlarm)")
    public void afterMethod(JoinPoint joinPoint, DwrSendAlarm dwrSendAlarm) {
        try{
            if(!ObjectUtils.isEmpty(dwrSendAlarm.messageOnEnd())){
                chat.sendMessageByEngine(dwrSendAlarm.messageOnEnd());
            }

        }catch (RuntimeException e){
            log.error(e.getMessage());
        }
    }
}
