package com.arms.api.requirement.reqstatus.model;

import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Builder
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class IssueListVO {

    // 요구사항 구분
    private String isReqName;

    // ALM 이슈 키
    private String key;

    // 버전명
    private String pdServiceVersionNames;

    // ALM 이슈 제목 (summary to issueTitle)
    private String issueTitle;

    // ALM Project
    private String almProjectName;

    // ALM Assignee
    private String assigneeName;
    private String assigneeEmail;
    private String accountId;

    // ALM Issue Properties
    private String issueStatus;
    private String issueType;
    private String issuePriority;

    // ALM Issue 관련 날짜
    private String createDate;
    private String updatedDate;
    private String resolutionDate;
    private String deletedDate;
    private String overallUpdatedDate;

    private Long pdServiceId; // 히든
    private Long[] pdServiceVersions; // 히든

    private Boolean isReq; // 히든
    private String etc; // 히든
    private String docId; // 히든
    private String issueId;
    private String parentReqKey; // 히든
    private String upperKey; // 히든
    private Long cReqLink; // 히든

}
